/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.apache.crimson.parser.AttributeDecl;
import org.apache.crimson.parser.AttributesExImpl;
import org.apache.crimson.parser.ContentModel;
import org.apache.crimson.parser.ElementDecl;
import org.apache.crimson.parser.ElementValidator;
import org.apache.crimson.parser.EndOfInputException;
import org.apache.crimson.parser.ExternalEntity;
import org.apache.crimson.parser.InputEntity;
import org.apache.crimson.parser.InternalEntity;
import org.apache.crimson.parser.Resolver;
import org.apache.crimson.parser.SimpleHashtable;
import org.apache.crimson.util.MessageCatalog;
import org.apache.crimson.util.XmlChars;
import org.apache.crimson.util.XmlNames;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class Parser2 {
    private InputEntity in;
    private AttributesExImpl attTmp;
    private StringBuffer strTmp;
    private char[] nameTmp;
    private NameCache nameCache;
    private char[] charTmp = new char[2];
    private String[] namePartsTmp = new String[3];
    private boolean seenNSDecl;
    private NamespaceSupport nsSupport;
    private Vector nsAttTmp;
    private boolean isValidating = false;
    private boolean fastStandalone = false;
    private boolean isInAttribute = false;
    private boolean namespaces;
    private boolean prefixes;
    private boolean inExternalPE;
    private boolean doLexicalPE;
    private boolean donePrologue;
    private boolean isStandalone;
    private String rootElementName;
    private boolean ignoreDeclarations;
    private SimpleHashtable elements = new SimpleHashtable(47);
    private SimpleHashtable params = new SimpleHashtable(7);
    Hashtable notations = new Hashtable(7);
    SimpleHashtable entities = new SimpleHashtable(17);
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private EntityResolver resolver;
    private ErrorHandler errHandler;
    private Locale locale;
    private Locator locator = new DocLocator();
    private DeclHandler declHandler;
    private LexicalHandler lexicalHandler;
    private boolean disallowDoctypeDecl = false;
    private String propertyEntityExpansionLimit = null;
    private String propertyDisallowDoctypeDecl = null;
    private String propertyElementAttributeLimit = null;
    private int entityExpansionCount = 0;
    private int entityExpansionLimit = -1;
    private int elementAttributeLimit = -1;
    private static final int DEFAULT_ENTITY_EXPANSION_LIMIT = 64000;
    private static final int DEFAULT_ELEMENT_ATTRIBUTE_LIMIT = 10000;
    private static final boolean supportValidation = true;
    static final String strANY = "ANY";
    static final String strEMPTY = "EMPTY";
    static final String SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT = "entityExpansionLimit";
    static final String SYSTEM_PROPERTY_DISALLOW_DOCTYPE_DECL = "disallowDoctypeDecl";
    static final String SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT = "elementAttributeLimit";
    static final boolean SECURITY_DEBUG = false;
    private static final NullHandler nullHandler = new NullHandler();
    private static final String XmlLang = "xml:lang";
    static final Catalog messages = new Catalog();
    static /* synthetic */ Class class$org$apache$crimson$parser$Parser2;

    private char getc() throws IOException, SAXException {
        if (!this.inExternalPE || !this.doLexicalPE) {
            char c = this.in.getc();
            if (c == '%' && this.doLexicalPE) {
                this.fatal("P-080");
            }
            return c;
        }
        while (this.in.isEOF()) {
            if (this.in.isInternal() || this.doLexicalPE && !this.in.isDocument()) {
                this.in = this.in.pop();
                continue;
            }
            this.fatal("P-064", new Object[]{this.in.getName()});
        }
        char c = this.in.getc();
        if (c == '%' && this.doLexicalPE) {
            String string = this.maybeGetName();
            if (string == null) {
                this.fatal("P-011");
            }
            this.nextChar(';', "F-021", string);
            Object object = this.params.get(string);
            this.pushReader(" ".toCharArray(), null, false);
            if (object instanceof InternalEntity) {
                this.pushReader(((InternalEntity)object).buf, string, false);
            } else if (object instanceof ExternalEntity) {
                this.pushReader((ExternalEntity)object);
            } else if (object == null) {
                this.fatal("V-022");
            } else {
                throw new InternalError();
            }
            this.pushReader(" ".toCharArray(), null, false);
            return this.in.getc();
        }
        return c;
    }

    private int parseCharNumber() throws SAXException, IOException {
        int n = 0;
        if (this.getc() != 'x') {
            this.ungetc();
            while (true) {
                char c;
                if ((c = this.getc()) >= '0' && c <= '9') {
                    n *= 10;
                    n += c - 48;
                    continue;
                }
                if (c == ';') {
                    return n;
                }
                this.fatal("P-049");
            }
        }
        while (true) {
            char c;
            if ((c = this.getc()) >= '0' && c <= '9') {
                n <<= 4;
                n += c - 48;
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                n <<= 4;
                n += 10 + (c - 97);
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                n <<= 4;
                n += 10 + (c - 65);
                continue;
            }
            if (c == ';') {
                return n;
            }
            this.fatal("P-050");
        }
    }

    public Parser2() {
        this.setHandlers();
        this.setSecurityConstraintValues();
    }

    void afterDocument() {
    }

    void afterRoot() throws SAXException {
    }

    private void init() {
        this.in = null;
        this.attTmp = new AttributesExImpl();
        this.strTmp = new StringBuffer();
        this.nameTmp = new char[20];
        this.nameCache = new NameCache();
        if (this.namespaces) {
            this.nsSupport = new NamespaceSupport();
            if (this.isValidating && !this.prefixes) {
                this.nsAttTmp = new Vector();
            }
        }
        this.isStandalone = false;
        this.rootElementName = null;
        this.isInAttribute = false;
        this.inExternalPE = false;
        this.doLexicalPE = false;
        this.donePrologue = false;
        this.entities.clear();
        this.notations.clear();
        this.params.clear();
        this.elements.clear();
        this.ignoreDeclarations = false;
        this.builtin("amp", "&#38;");
        this.builtin("lt", "&#60;");
        this.builtin("gt", ">");
        this.builtin("quot", "\"");
        this.builtin("apos", "'");
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (this.resolver == null) {
            this.resolver = new Resolver();
        }
        this.setHandlers();
        this.entityExpansionCount = 0;
        if (this.entityExpansionLimit < 0) {
            this.entityExpansionLimit = 64000;
        }
        if (this.elementAttributeLimit < 0) {
            this.elementAttributeLimit = 10000;
        }
    }

    private void maybeTextDecl() throws IOException, SAXException {
        if (!this.in.isXmlDeclOrTextDeclPrefix()) {
            return;
        }
        this.peek("<?xml");
        this.readVersion(false, "1.0");
        this.readEncoding(true);
        this.maybeWhitespace();
        if (!this.peek("?>")) {
            this.fatal("P-057");
        }
    }

    private void maybeXmlDecl() throws IOException, SAXException {
        if (!this.in.isXmlDeclOrTextDeclPrefix()) {
            return;
        }
        this.peek("<?xml");
        this.readVersion(true, "1.0");
        this.readEncoding(false);
        this.readStandalone();
        this.maybeWhitespace();
        if (!this.peek("?>")) {
            char c = this.getc();
            this.fatal("P-023", new Object[]{Integer.toHexString(c), new Character(c)});
        }
    }

    private void readStandalone() throws IOException, SAXException {
        String string = this.maybeReadAttribute("standalone", false);
        if (string == null || "no".equals(string)) {
            return;
        }
        if ("yes".equals(string)) {
            this.isStandalone = true;
            return;
        }
        this.fatal("P-029", new Object[]{string});
    }

    private void setHandlers() {
        if (this.contentHandler == null) {
            this.contentHandler = nullHandler;
        }
        if (this.errHandler == null) {
            this.errHandler = nullHandler;
        }
        if (this.dtdHandler == null) {
            this.dtdHandler = nullHandler;
        }
        if (this.lexicalHandler == null) {
            this.lexicalHandler = nullHandler;
        }
        if (this.declHandler == null) {
            this.declHandler = nullHandler;
        }
    }

    void setSecurityConstraintValues() {
        try {
            this.propertyEntityExpansionLimit = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(Parser2.SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT);
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            this.propertyDisallowDoctypeDecl = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(Parser2.SYSTEM_PROPERTY_DISALLOW_DOCTYPE_DECL);
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            this.propertyElementAttributeLimit = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(Parser2.SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT);
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (this.propertyEntityExpansionLimit == null || this.propertyDisallowDoctypeDecl == null) {
            try {
                FileInputStream fileInputStream = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws FileNotFoundException {
                        String string = System.getProperty("java.home");
                        String string2 = string + File.separator + "lib" + File.separator + "jaxp.properties";
                        File file = new File(string2);
                        if (file.exists()) {
                            return new FileInputStream(file);
                        }
                        return null;
                    }
                });
                if (fileInputStream != null) {
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    if (this.propertyEntityExpansionLimit == null) {
                        this.propertyEntityExpansionLimit = properties.getProperty(SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT);
                    }
                    if (this.propertyDisallowDoctypeDecl == null) {
                        this.propertyDisallowDoctypeDecl = properties.getProperty(SYSTEM_PROPERTY_DISALLOW_DOCTYPE_DECL);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (this.propertyEntityExpansionLimit != null) {
                this.entityExpansionLimit = Integer.parseInt(this.propertyEntityExpansionLimit);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.propertyDisallowDoctypeDecl != null && (this.propertyDisallowDoctypeDecl.equals("true") || this.propertyDisallowDoctypeDecl.equals("TRUE"))) {
            this.disallowDoctypeDecl = true;
        }
        try {
            if (this.propertyElementAttributeLimit != null) {
                this.elementAttributeLimit = Integer.parseInt(this.propertyElementAttributeLimit);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void ungetc() {
        this.in.ungetc();
    }

    public boolean isFastStandalone() {
        return this.fastStandalone;
    }

    private boolean maybeAttlistDecl() throws IOException, SAXException {
        InputEntity inputEntity = this.peekDeclaration("!ATTLIST");
        if (inputEntity == null) {
            return false;
        }
        String string = this.getMarkupDeclname("F-016", true);
        ElementDecl elementDecl = (ElementDecl)this.elements.get(string);
        if (elementDecl == null) {
            elementDecl = new ElementDecl(string);
            if (!this.ignoreDeclarations) {
                this.elements.put(string, elementDecl);
            }
        }
        this.maybeWhitespace();
        while (!this.peek(">")) {
            Object object;
            string = this.maybeGetName();
            if (string == null) {
                this.fatal("P-044", new Object[]{new Character(this.getc())});
            }
            this.whitespace("F-001");
            AttributeDecl attributeDecl = new AttributeDecl(string);
            boolean bl = attributeDecl.isFromInternalSubset = !this.inExternalPE;
            if (this.peek("CDATA")) {
                attributeDecl.type = "CDATA";
            } else if (this.peek("IDREFS")) {
                attributeDecl.type = "IDREFS";
            } else if (this.peek("IDREF")) {
                attributeDecl.type = "IDREF";
            } else if (this.peek("ID")) {
                attributeDecl.type = "ID";
                if (elementDecl.id != null) {
                    if (this.isValidating) {
                        this.error("V-016", new Object[]{elementDecl.id});
                    }
                } else {
                    elementDecl.id = string;
                }
            } else if (this.peek("ENTITY")) {
                attributeDecl.type = "ENTITY";
            } else if (this.peek("ENTITIES")) {
                attributeDecl.type = "ENTITIES";
            } else if (this.peek("NMTOKENS")) {
                attributeDecl.type = "NMTOKENS";
            } else if (this.peek("NMTOKEN")) {
                attributeDecl.type = "NMTOKEN";
            } else if (this.peek("NOTATION")) {
                attributeDecl.type = "NOTATION";
                this.whitespace("F-002");
                this.nextChar('(', "F-029", null);
                this.maybeWhitespace();
                object = new Vector();
                do {
                    if ((string = this.maybeGetName()) == null) {
                        this.fatal("P-068");
                    }
                    if (this.isValidating && this.notations.get(string) == null) {
                        this.notations.put(string, string);
                    }
                    ((Vector)object).addElement(string);
                    this.maybeWhitespace();
                    if (!this.peek("|")) continue;
                    this.maybeWhitespace();
                } while (!this.peek(")"));
                attributeDecl.values = new String[((Vector)object).size()];
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    attributeDecl.values[i] = (String)((Vector)object).elementAt(i);
                }
            } else if (this.peek("(")) {
                attributeDecl.type = "ENUMERATION";
                this.maybeWhitespace();
                object = new Vector();
                do {
                    string = this.getNmtoken();
                    ((Vector)object).addElement(string);
                    this.maybeWhitespace();
                    if (!this.peek("|")) continue;
                    this.maybeWhitespace();
                } while (!this.peek(")"));
                attributeDecl.values = new String[((Vector)object).size()];
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    attributeDecl.values[i] = (String)((Vector)object).elementAt(i);
                }
            } else {
                this.fatal("P-045", new Object[]{string, new Character(this.getc())});
            }
            this.whitespace("F-003");
            if (this.peek("#REQUIRED")) {
                attributeDecl.valueDefault = "#REQUIRED";
                attributeDecl.isRequired = true;
            } else if (this.peek("#FIXED")) {
                if (this.isValidating && attributeDecl.type == "ID") {
                    this.error("V-017", new Object[]{attributeDecl.name});
                }
                attributeDecl.valueDefault = "#FIXED";
                attributeDecl.isFixed = true;
                this.whitespace("F-004");
                this.doLexicalPE = false;
                this.parseLiteral(false);
                this.doLexicalPE = true;
                attributeDecl.defaultValue = attributeDecl.type != "CDATA" ? this.normalize(false) : this.strTmp.toString();
                if (attributeDecl.type != "CDATA") {
                    this.validateAttributeSyntax(attributeDecl, attributeDecl.defaultValue);
                }
            } else if (this.peek("#IMPLIED")) {
                attributeDecl.valueDefault = "#IMPLIED";
            } else {
                if (this.isValidating && attributeDecl.type == "ID") {
                    this.error("V-018", new Object[]{attributeDecl.name});
                }
                this.doLexicalPE = false;
                this.parseLiteral(false);
                this.doLexicalPE = true;
                attributeDecl.defaultValue = attributeDecl.type != "CDATA" ? this.normalize(false) : this.strTmp.toString();
                if (attributeDecl.type != "CDATA") {
                    this.validateAttributeSyntax(attributeDecl, attributeDecl.defaultValue);
                }
            }
            if (XmlLang.equals(attributeDecl.name) && attributeDecl.defaultValue != null && !this.isXmlLang(attributeDecl.defaultValue)) {
                this.error("P-033", new Object[]{attributeDecl.defaultValue});
            }
            if (!this.ignoreDeclarations && elementDecl.attributes.get(attributeDecl.name) == null) {
                elementDecl.attributes.put(attributeDecl.name, attributeDecl);
                if (attributeDecl.type == "ENUMERATION" || attributeDecl.type == "NOTATION") {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (attributeDecl.type == "NOTATION") {
                        stringBuffer.append(attributeDecl.type);
                        stringBuffer.append(" ");
                    }
                    if (attributeDecl.values.length > 1) {
                        stringBuffer.append("(");
                    }
                    for (int i = 0; i < attributeDecl.values.length; ++i) {
                        stringBuffer.append(attributeDecl.values[i]);
                        if (i + 1 >= attributeDecl.values.length) continue;
                        stringBuffer.append("|");
                    }
                    if (attributeDecl.values.length > 1) {
                        stringBuffer.append(")");
                    }
                    object = stringBuffer.toString();
                } else {
                    object = attributeDecl.type;
                }
                this.declHandler.attributeDecl(elementDecl.name, attributeDecl.name, (String)object, attributeDecl.valueDefault, attributeDecl.defaultValue);
            }
            this.maybeWhitespace();
        }
        if (this.isValidating && inputEntity != this.in) {
            this.error("V-013", null);
        }
        return true;
    }

    private boolean maybeConditionalSect() throws IOException, SAXException {
        if (!this.peek("<![")) {
            return false;
        }
        InputEntity inputEntity = this.in;
        this.maybeWhitespace();
        String string = this.maybeGetName();
        if (string == null) {
            this.fatal("P-046");
        }
        this.maybeWhitespace();
        this.nextChar('[', "F-030", null);
        if ("INCLUDE".equals(string)) {
            while (true) {
                if (this.in.isEOF() && this.in != inputEntity) {
                    this.in = this.in.pop();
                    continue;
                }
                if (this.in.isEOF()) {
                    if (this.isValidating) {
                        this.error("V-020", null);
                    }
                    this.in = this.in.pop();
                }
                if (!this.peek("]]>")) {
                    this.doLexicalPE = false;
                    if (this.maybeWhitespace() || this.maybePEReference()) continue;
                    this.doLexicalPE = true;
                    if (this.maybeMarkupDecl() || this.maybeConditionalSect()) continue;
                    this.fatal("P-047");
                    continue;
                }
                break;
            }
        } else if ("IGNORE".equals(string)) {
            int n = 1;
            this.doLexicalPE = false;
            while (n > 0) {
                char c = this.getc();
                if (c == '<') {
                    if (!this.peek("![")) continue;
                    ++n;
                    continue;
                }
                if (c != ']' || !this.peek("]>")) continue;
                --n;
            }
        } else {
            this.fatal("P-048", new Object[]{string});
        }
        return true;
    }

    private boolean maybeDoctypeDecl() throws IOException, SAXException {
        if (!this.peek("<!DOCTYPE")) {
            return false;
        }
        if (this.disallowDoctypeDecl) {
            this.fatal("P-085", new Object[]{SYSTEM_PROPERTY_DISALLOW_DOCTYPE_DECL});
        }
        ExternalEntity externalEntity = null;
        this.rootElementName = this.getMarkupDeclname("F-014", true);
        if (this.maybeWhitespace() && (externalEntity = this.maybeExternalID()) != null) {
            this.lexicalHandler.startDTD(this.rootElementName, externalEntity.publicId, externalEntity.verbatimSystemId);
            this.maybeWhitespace();
        } else {
            this.lexicalHandler.startDTD(this.rootElementName, null, null);
        }
        if (this.in.peekc('[')) {
            while (true) {
                if (this.in.isEOF() && !this.in.isDocument()) {
                    this.in = this.in.pop();
                    continue;
                }
                if (this.maybeMarkupDecl() || this.maybePEReference() || this.maybeWhitespace()) continue;
                if (!this.peek("<![")) break;
                this.fatal("P-028");
            }
            this.nextChar(']', "F-024", null);
            this.maybeWhitespace();
        }
        this.nextChar('>', "F-025", null);
        if (externalEntity != null) {
            externalEntity.name = "[dtd]";
            externalEntity.isPE = true;
            this.externalParameterEntity(externalEntity);
        }
        this.params.clear();
        this.lexicalHandler.endDTD();
        Vector vector = new Vector();
        Object object = this.notations.keys();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            Object object2 = this.notations.get(string);
            if (object2 == Boolean.TRUE) {
                if (this.isValidating) {
                    this.error("V-003", new Object[]{string});
                }
                vector.addElement(string);
                continue;
            }
            if (!(object2 instanceof String)) continue;
            if (this.isValidating) {
                this.error("V-004", new Object[]{string});
            }
            vector.addElement(string);
        }
        while (!vector.isEmpty()) {
            object = vector.firstElement();
            vector.removeElement(object);
            this.notations.remove(object);
        }
        return true;
    }

    private boolean maybeElementDecl() throws IOException, SAXException {
        InputEntity inputEntity = this.peekDeclaration("!ELEMENT");
        if (inputEntity == null) {
            return false;
        }
        String string = this.getMarkupDeclname("F-015", true);
        ElementDecl elementDecl = (ElementDecl)this.elements.get(string);
        boolean bl = false;
        if (elementDecl != null) {
            if (elementDecl.contentType != null) {
                if (this.isValidating && elementDecl.contentType != null) {
                    this.error("V-012", new Object[]{string});
                }
                elementDecl = new ElementDecl(string);
            }
        } else {
            elementDecl = new ElementDecl(string);
            if (!this.ignoreDeclarations) {
                this.elements.put(elementDecl.name, elementDecl);
                bl = true;
            }
        }
        elementDecl.isFromInternalSubset = !this.inExternalPE;
        this.whitespace("F-000");
        if (this.peek(strEMPTY)) {
            elementDecl.contentType = strEMPTY;
            elementDecl.ignoreWhitespace = true;
        } else if (this.peek(strANY)) {
            elementDecl.contentType = strANY;
            elementDecl.ignoreWhitespace = false;
        } else {
            elementDecl.contentType = this.getMixedOrChildren(elementDecl);
        }
        this.maybeWhitespace();
        char c = this.getc();
        if (c != '>') {
            this.fatal("P-036", new Object[]{string, new Character(c)});
        }
        if (this.isValidating && inputEntity != this.in) {
            this.error("V-013", null);
        }
        if (bl) {
            this.declHandler.elementDecl(elementDecl.name, elementDecl.contentType);
        }
        return true;
    }

    private boolean maybeEntityDecl() throws IOException, SAXException {
        boolean bl;
        SimpleHashtable simpleHashtable;
        InputEntity inputEntity = this.peekDeclaration("!ENTITY");
        if (inputEntity == null) {
            return false;
        }
        this.doLexicalPE = false;
        this.whitespace("F-005");
        if (this.in.peekc('%')) {
            this.whitespace("F-006");
            simpleHashtable = this.params;
        } else {
            simpleHashtable = this.entities;
        }
        this.ungetc();
        this.doLexicalPE = true;
        String string = this.getMarkupDeclname("F-017", false);
        this.whitespace("F-007");
        ExternalEntity externalEntity = this.maybeExternalID();
        boolean bl2 = bl = simpleHashtable.get(string) == null;
        if (!bl && simpleHashtable == this.entities) {
            this.warning("P-054", new Object[]{string});
        }
        bl &= !this.ignoreDeclarations;
        if (externalEntity == null) {
            this.doLexicalPE = false;
            this.parseLiteral(true);
            this.doLexicalPE = true;
            if (bl) {
                char[] cArray = new char[this.strTmp.length()];
                if (cArray.length != 0) {
                    this.strTmp.getChars(0, cArray.length, cArray, 0);
                }
                InternalEntity internalEntity = new InternalEntity(string, cArray);
                internalEntity.isPE = simpleHashtable == this.params;
                internalEntity.isFromInternalSubset = !this.inExternalPE;
                simpleHashtable.put(string, internalEntity);
                if (simpleHashtable == this.params) {
                    string = "%" + string;
                }
                this.declHandler.internalEntityDecl(string, new String(cArray));
            }
        } else {
            if (simpleHashtable == this.entities && this.maybeWhitespace() && this.peek("NDATA")) {
                externalEntity.notation = this.getMarkupDeclname("F-018", false);
                if (this.isValidating && this.notations.get(externalEntity.notation) == null) {
                    this.notations.put(externalEntity.notation, Boolean.TRUE);
                }
            }
            externalEntity.name = string;
            externalEntity.isPE = simpleHashtable == this.params;
            boolean bl3 = externalEntity.isFromInternalSubset = !this.inExternalPE;
            if (bl) {
                simpleHashtable.put(string, externalEntity);
                if (externalEntity.notation != null) {
                    this.dtdHandler.unparsedEntityDecl(string, externalEntity.publicId, externalEntity.systemId, externalEntity.notation);
                } else {
                    if (simpleHashtable == this.params) {
                        string = "%" + string;
                    }
                    this.declHandler.externalEntityDecl(string, externalEntity.publicId, externalEntity.systemId);
                }
            }
        }
        this.maybeWhitespace();
        this.nextChar('>', "F-031", string);
        if (this.isValidating && inputEntity != this.in) {
            this.error("V-013", null);
        }
        return true;
    }

    private boolean maybeMarkupDecl() throws IOException, SAXException {
        return this.maybeElementDecl() || this.maybeAttlistDecl() || this.maybeEntityDecl() || this.maybeNotationDecl() || this.maybePI(false) || this.maybeComment(false);
    }

    private boolean maybeNotationDecl() throws IOException, SAXException {
        Object object;
        InputEntity inputEntity = this.peekDeclaration("!NOTATION");
        if (inputEntity == null) {
            return false;
        }
        String string = this.getMarkupDeclname("F-019", false);
        ExternalEntity externalEntity = new ExternalEntity(this.in);
        this.whitespace("F-011");
        if (this.peek("PUBLIC")) {
            this.whitespace("F-009");
            externalEntity.publicId = this.parsePublicId();
            if (this.maybeWhitespace()) {
                if (!this.peek(">")) {
                    externalEntity.systemId = this.parseSystemId();
                } else {
                    this.ungetc();
                }
            }
        } else if (this.peek("SYSTEM")) {
            this.whitespace("F-008");
            externalEntity.systemId = this.parseSystemId();
        } else {
            this.fatal("P-062");
        }
        this.maybeWhitespace();
        this.nextChar('>', "F-032", string);
        if (this.isValidating && inputEntity != this.in) {
            this.error("V-013", null);
        }
        if (externalEntity.systemId != null && externalEntity.systemId.indexOf(35) != -1) {
            this.error("P-056", new Object[]{externalEntity.systemId});
        }
        if ((object = this.notations.get(string)) != null && object instanceof ExternalEntity) {
            this.warning("P-063", new Object[]{string});
        } else if (!this.ignoreDeclarations) {
            this.notations.put(string, externalEntity);
            this.dtdHandler.notationDecl(string, externalEntity.publicId, externalEntity.systemId);
        }
        return true;
    }

    private boolean maybePEReference() throws IOException, SAXException {
        if (!this.in.peekc('%')) {
            return false;
        }
        String string = this.maybeGetName();
        if (string == null) {
            this.fatal("P-011");
        }
        this.nextChar(';', "F-021", string);
        Object object = this.params.get(string);
        if (object instanceof InternalEntity) {
            InternalEntity internalEntity = (InternalEntity)object;
            this.pushReader(internalEntity.buf, string, false);
        } else if (object instanceof ExternalEntity) {
            this.externalParameterEntity((ExternalEntity)object);
        } else if (object == null) {
            this.ignoreDeclarations = true;
            if (this.isValidating) {
                this.error("V-022", new Object[]{string});
            } else {
                this.warning("V-022", new Object[]{string});
            }
        }
        return true;
    }

    private boolean maybeWhitespace() throws IOException, SAXException {
        if (!this.inExternalPE || !this.doLexicalPE) {
            return this.in.maybeWhitespace();
        }
        char c = this.getc();
        boolean bl = false;
        while (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
            bl = true;
            if (this.in.isEOF() && !this.in.isInternal()) {
                return bl;
            }
            c = this.getc();
        }
        this.ungetc();
        return bl;
    }

    private int surrogatesToCharTmp(int n) throws SAXException {
        if (n <= 65535) {
            if (XmlChars.isChar(n)) {
                this.charTmp[0] = (char)n;
                return 1;
            }
        } else if (n <= 0x10FFFF) {
            this.charTmp[0] = (char)(0xD800 | (n -= 65536) >> 10 & 0x3FF);
            this.charTmp[1] = (char)(0xDC00 | n & 0x3FF);
            return 2;
        }
        this.fatal("P-051", new Object[]{Integer.toHexString(n)});
        return -1;
    }

    private void maybeMisc(boolean bl) throws IOException, SAXException {
        while (!(bl && this.in.isEOF() || !this.maybeComment(false) && !this.maybePI(false) && !this.maybeWhitespace())) {
        }
    }

    private void parseLiteral(boolean bl) throws IOException, SAXException {
        boolean bl2 = this.doLexicalPE;
        char c = this.getc();
        InputEntity inputEntity = this.in;
        if (c != '\'' && c != '\"') {
            this.fatal("P-007");
        }
        this.isInAttribute = !bl;
        this.strTmp = new StringBuffer();
        while (true) {
            String string;
            if (this.in != inputEntity && this.in.isEOF()) {
                this.in = this.in.pop();
                continue;
            }
            char c2 = this.getc();
            if (c2 == c && this.in == inputEntity) break;
            if (c2 == '&') {
                string = this.maybeGetName();
                if (string != null) {
                    this.nextChar(';', "F-020", string);
                    if (bl) {
                        this.strTmp.append('&');
                        this.strTmp.append(string);
                        this.strTmp.append(';');
                        continue;
                    }
                    this.expandEntityInLiteral(string, this.entities, bl);
                    continue;
                }
                c2 = this.getc();
                if (c2 == '#') {
                    int n = this.parseCharNumber();
                    if (n > 65535) {
                        n = this.surrogatesToCharTmp(n);
                        this.strTmp.append(this.charTmp[0]);
                        if (n != 2) continue;
                        this.strTmp.append(this.charTmp[1]);
                        continue;
                    }
                    this.strTmp.append((char)n);
                    continue;
                }
                this.fatal("P-009");
                continue;
            }
            if (c2 == '%' && bl) {
                string = this.maybeGetName();
                if (string != null) {
                    this.nextChar(';', "F-021", string);
                    if (this.inExternalPE) {
                        this.expandEntityInLiteral(string, this.params, bl);
                        continue;
                    }
                    this.fatal("P-010", new Object[]{string});
                    continue;
                }
                this.fatal("P-011");
            }
            if (!bl) {
                if (c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r') {
                    this.strTmp.append(' ');
                    continue;
                }
                if (c2 == '<') {
                    this.fatal("P-012");
                }
            }
            this.strTmp.append(c2);
        }
        this.isInAttribute = false;
    }

    private void readEncoding(boolean bl) throws IOException, SAXException {
        String string = this.maybeReadAttribute("encoding", bl);
        if (string == null) {
            return;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || i != 0 && (c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.')) continue;
            this.fatal("P-060", new Object[]{new Character(c)});
        }
        String string2 = this.in.getEncoding();
        if (string2 != null && !string.equalsIgnoreCase(string2)) {
            this.warning("P-061", new Object[]{string, string2});
        }
    }

    public void setFastStandalone(boolean bl) {
        this.fastStandalone = bl && !this.isValidating;
    }

    void setIsValidating(boolean bl) {
        this.isValidating = bl;
        if (bl) {
            this.fastStandalone = false;
        }
    }

    private boolean maybeComment(boolean bl) throws IOException, SAXException {
        int n;
        boolean bl2;
        if (!this.in.peek(bl ? "!--" : "<!--", null)) {
            return false;
        }
        boolean bl3 = this.doLexicalPE;
        this.doLexicalPE = false;
        boolean bl4 = bl2 = this.lexicalHandler != nullHandler;
        if (bl2) {
            this.strTmp = new StringBuffer();
        }
        block2: while (true) {
            try {
                while (true) {
                    if ((n = this.getc()) == 45) {
                        n = this.getc();
                        if (n != 45) {
                            if (bl2) {
                                this.strTmp.append('-');
                            }
                            this.ungetc();
                            continue;
                        }
                        this.nextChar('>', "F-022", null);
                        break block2;
                    }
                    if (!bl2) continue;
                    this.strTmp.append((char)n);
                }
            }
            catch (EndOfInputException endOfInputException) {
                if (this.inExternalPE || !this.donePrologue && this.in.isInternal()) {
                    if (this.isValidating) {
                        this.error("V-021", null);
                    }
                    this.in = this.in.pop();
                    continue;
                }
                this.fatal("P-017");
                continue;
            }
            break;
        }
        this.doLexicalPE = bl3;
        if (bl2) {
            n = this.strTmp.length();
            char[] cArray = new char[n];
            if (n != 0) {
                this.strTmp.getChars(0, n, cArray, 0);
            }
            this.lexicalHandler.comment(cArray, 0, n);
        }
        return true;
    }

    private boolean maybePI(boolean bl) throws IOException, SAXException {
        boolean bl2 = this.doLexicalPE;
        if (!this.in.peek(bl ? "?" : "<?", null)) {
            return false;
        }
        this.doLexicalPE = false;
        String string = this.maybeGetName();
        if (string == null) {
            this.fatal("P-018");
        }
        if ("xml".equals(string)) {
            this.fatal("P-019");
        }
        if ("xml".equalsIgnoreCase(string)) {
            this.fatal("P-020", new Object[]{string});
        }
        if (this.maybeWhitespace()) {
            this.strTmp = new StringBuffer();
            try {
                char c;
                while ((c = this.in.getc()) != '?' || !this.in.peekc('>')) {
                    this.strTmp.append(c);
                }
            }
            catch (EndOfInputException endOfInputException) {
                this.fatal("P-021");
            }
            this.contentHandler.processingInstruction(string, this.strTmp.toString());
        } else {
            if (!this.in.peek("?>", null)) {
                this.fatal("P-022");
            }
            this.contentHandler.processingInstruction(string, "");
        }
        this.doLexicalPE = bl2;
        return true;
    }

    void setNamespaceFeatures(boolean bl, boolean bl2) {
        this.namespaces = bl;
        this.prefixes = bl2;
    }

    public void pushInputBuffer(char[] cArray, int n, int n2) throws SAXException {
        if (n2 <= 0) {
            return;
        }
        if (n != 0 || n2 != cArray.length) {
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, n, cArray2, 0, n2);
            cArray = cArray2;
        }
        this.pushReader(cArray, null, false);
    }

    private String getNmtoken() throws SAXException, IOException {
        char c = this.getc();
        if (!XmlChars.isNameChar(c)) {
            this.fatal("P-006", new Object[]{new Character(c)});
        }
        return this.nameCharString((char)c).name;
    }

    private String maybeGetName() throws IOException, SAXException {
        NameCacheEntry nameCacheEntry = this.maybeGetNameCacheEntry();
        return nameCacheEntry == null ? null : nameCacheEntry.name;
    }

    private String parsePublicId() throws IOException, SAXException {
        String string = this.getQuotedString("F-033", null);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (" \r\n-'()+,./:=?;!*#@$_%0123456789".indexOf(c) != -1 || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
            this.fatal("P-016", new Object[]{new Character(c)});
        }
        this.strTmp = new StringBuffer();
        this.strTmp.append(string);
        return this.normalize(false);
    }

    private String parseSystemId() throws IOException, SAXException {
        String string = this.getQuotedString("F-034", null);
        return this.resolveURI(string);
    }

    private void fatal(String string) throws SAXException {
        this.fatal(string, null, null);
    }

    private void whitespace(String string) throws IOException, SAXException {
        if (!this.maybeWhitespace()) {
            this.fatal("P-004", new Object[]{messages.getMessage(this.locale, string)});
        }
    }

    private boolean isXmlLang(String string) {
        int n;
        if (string.length() < 2) {
            return false;
        }
        char c = string.charAt(1);
        if (c == '-') {
            c = string.charAt(0);
            if (c != 'i' && c != 'I' && c != 'x' && c != 'X') {
                return false;
            }
            n = 1;
        } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            c = string.charAt(0);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                return false;
            }
            n = 2;
        } else {
            return false;
        }
        while (n < string.length() && (c = string.charAt(n)) == '-') {
            while (++n < string.length() && ((c = string.charAt(n)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            }
        }
        return string.length() == n && c != '-';
    }

    private boolean peek(String string) throws IOException, SAXException {
        return this.in.peek(string, null);
    }

    private String normalize(boolean bl) throws SAXException {
        String string = this.strTmp.toString();
        String string2 = string.trim();
        boolean bl2 = false;
        if (string != string2) {
            string = string2;
            string2 = null;
            bl2 = true;
        }
        this.strTmp = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!XmlChars.isSpace(c)) {
                this.strTmp.append(c);
                continue;
            }
            this.strTmp.append(' ');
            while (++i < string.length() && XmlChars.isSpace(string.charAt(i))) {
                bl2 = true;
            }
            --i;
        }
        if (this.isValidating && this.isStandalone && bl && (string2 == null || bl2)) {
            this.error("V-019", null);
        }
        if (bl2) {
            return this.strTmp.toString();
        }
        return string;
    }

    private void readVersion(boolean bl, String string) throws IOException, SAXException {
        String string2 = this.maybeReadAttribute("version", bl);
        if (bl && string2 == null) {
            this.fatal("P-025", new Object[]{string});
        }
        if (string2 != null) {
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (c >= '0' && c <= '9' || c == '_' || c == '.' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ':' || c == '-') continue;
                this.fatal("P-026", new Object[]{string2});
            }
        }
        if (string2 != null && !string2.equals(string)) {
            this.error("P-027", new Object[]{string, string2});
        }
    }

    private void pushReader(char[] cArray, String string, boolean bl) throws SAXException {
        if (bl && !this.isInAttribute) {
            this.lexicalHandler.startEntity(string);
        }
        InputEntity inputEntity = InputEntity.getInputEntity(this.errHandler, this.locale);
        inputEntity.init(cArray, string, this.in, !bl);
        this.in = inputEntity;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) throws SAXException {
        if (locale != null && !messages.isLocaleSupported(locale.toString())) {
            throw new SAXException(messages.getMessage(this.locale, "P-078", new Object[]{locale}));
        }
        this.locale = locale;
    }

    private boolean defaultAttributes(ElementDecl elementDecl) throws SAXException {
        boolean bl = false;
        Enumeration enumeration = elementDecl.attributes.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (this.attTmp.getValue(string2) != null) continue;
            AttributeDecl attributeDecl = (AttributeDecl)elementDecl.attributes.get(string2);
            if (this.isValidating && attributeDecl.isRequired) {
                if (this.namespaces && !this.prefixes && this.nsAttTmp.contains(string2)) continue;
                this.error("V-009", new Object[]{string2});
            }
            if ((string = attributeDecl.defaultValue) == null) continue;
            if (this.isValidating && this.isStandalone && !attributeDecl.isFromInternalSubset) {
                this.error("V-010", new Object[]{string2});
            }
            if (this.namespaces) {
                this.processAttributeNS(string2, attributeDecl.type, string, string, false, true, null);
            } else {
                this.attTmp.addAttribute("", "", string2, attributeDecl.type, string, string, false);
            }
            bl = true;
        }
        return bl;
    }

    private boolean maybeElement(ElementValidator elementValidator) throws IOException, SAXException {
        Object object;
        String string;
        boolean bl = false;
        boolean bl2 = true;
        NameCacheEntry nameCacheEntry = this.maybeGetNameCacheEntry();
        if (nameCacheEntry == null) {
            return false;
        }
        if (elementValidator != null) {
            elementValidator.consume(nameCacheEntry.name);
        }
        ElementDecl elementDecl = (ElementDecl)this.elements.get(nameCacheEntry.name);
        if (this.isValidating) {
            if (elementDecl == null || elementDecl.contentType == null) {
                this.error("V-005", new Object[]{nameCacheEntry.name});
                elementDecl = new ElementDecl(nameCacheEntry.name);
                elementDecl.contentType = strANY;
                this.elements.put(nameCacheEntry.name, elementDecl);
            }
            if (elementValidator == null && this.rootElementName != null && !this.rootElementName.equals(nameCacheEntry.name)) {
                this.error("V-006", new Object[]{nameCacheEntry.name, this.rootElementName});
            }
        }
        int n = this.in.getLineNumber();
        boolean bl3 = this.in.maybeWhitespace();
        Vector vector = null;
        if (this.namespaces) {
            this.nsSupport.pushContext();
            this.seenNSDecl = false;
        }
        int n2 = 0;
        while (true) {
            String string2;
            String string3;
            if (n2 > this.elementAttributeLimit) {
                this.fatal("P-087", new Object[]{new Integer(this.elementAttributeLimit)});
            }
            if (this.in.peekc('>')) break;
            if (this.in.peekc('/')) {
                bl2 = false;
                break;
            }
            if (!bl3) {
                this.fatal("P-030");
            }
            if ((string3 = this.maybeGetName()) == null) {
                this.fatal("P-031", new Object[]{new Character(this.getc())});
            }
            if (this.attTmp.getValue(string3) != null) {
                this.fatal("P-032", new Object[]{string3});
            }
            this.in.maybeWhitespace();
            this.nextChar('=', "F-026", string3);
            this.in.maybeWhitespace();
            this.doLexicalPE = false;
            this.parseLiteral(false);
            bl3 = this.in.maybeWhitespace();
            String string4 = string = elementDecl == null ? null : (AttributeDecl)elementDecl.attributes.get(string3);
            if (string == null) {
                if (this.isValidating) {
                    this.error("V-007", new Object[]{string3, nameCacheEntry.name});
                }
                object = this.strTmp.toString();
            } else {
                if (!"CDATA".equals(((AttributeDecl)((Object)string)).type)) {
                    object = this.normalize(!((AttributeDecl)((Object)string)).isFromInternalSubset);
                    if (this.isValidating) {
                        this.validateAttributeSyntax((AttributeDecl)((Object)string), (String)object);
                    }
                } else {
                    object = this.strTmp.toString();
                }
                if (this.isValidating && ((AttributeDecl)((Object)string)).isFixed && !((String)object).equals(((AttributeDecl)((Object)string)).defaultValue)) {
                    this.error("V-008", new Object[]{string3, nameCacheEntry.name, ((AttributeDecl)((Object)string)).defaultValue});
                }
            }
            if (XmlLang.equals(string3) && !this.isXmlLang((String)object)) {
                this.error("P-033", new Object[]{object});
            }
            String string5 = string == null ? "CDATA" : ((AttributeDecl)((Object)string)).type;
            String string6 = string2 = string == null ? null : ((AttributeDecl)((Object)string)).defaultValue;
            if (this.namespaces) {
                vector = this.processAttributeNS(string3, string5, (String)object, string2, true, false, vector);
            } else {
                this.attTmp.addAttribute("", "", string3, string5, (String)object, string2, true);
            }
            bl = true;
            ++n2;
        }
        if (elementDecl != null) {
            this.attTmp.setIdAttributeName(elementDecl.id);
        }
        if (elementDecl != null && elementDecl.attributes.size() != 0) {
            boolean bl4 = bl = this.defaultAttributes(elementDecl) || bl;
        }
        if (this.seenNSDecl) {
            n2 = this.attTmp.getLength();
            for (int i = 0; i < n2; ++i) {
                string = this.attTmp.getQName(i);
                if (string.startsWith("xmlns") && (string.length() == 5 || string.charAt(5) == ':')) continue;
                object = this.processName(string, true, false);
                this.attTmp.setURI(i, object[0]);
                this.attTmp.setLocalName(i, object[1]);
            }
        } else if (vector != null && this.errHandler != null) {
            for (n2 = 0; n2 < vector.size(); ++n2) {
                this.errHandler.error((SAXParseException)vector.elementAt(n2));
            }
        }
        if (this.namespaces) {
            String[] stringArray = this.processName(nameCacheEntry.name, false, false);
            this.contentHandler.startElement(stringArray[0], stringArray[1], stringArray[2], this.attTmp);
        } else {
            this.contentHandler.startElement("", "", nameCacheEntry.name, this.attTmp);
        }
        if (bl) {
            this.attTmp.clear();
            if (this.isValidating && this.namespaces && !this.prefixes) {
                this.nsAttTmp.removeAllElements();
            }
        }
        elementValidator = this.newValidator(elementDecl);
        if (bl2) {
            this.content(elementDecl, false, elementValidator);
            if (!this.in.peek(nameCacheEntry.name, nameCacheEntry.chars)) {
                this.fatal("P-034", new Object[]{nameCacheEntry.name, new Integer(n)});
            }
            this.in.maybeWhitespace();
        }
        this.nextChar('>', "F-027", nameCacheEntry.name);
        elementValidator.done();
        if (this.namespaces) {
            String[] stringArray = this.processName(nameCacheEntry.name, false, false);
            this.contentHandler.endElement(stringArray[0], stringArray[1], stringArray[2]);
            Enumeration enumeration = this.nsSupport.getDeclaredPrefixes();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                this.contentHandler.endPrefixMapping(string);
            }
            this.nsSupport.popContext();
        } else {
            this.contentHandler.endElement("", "", nameCacheEntry.name);
        }
        return true;
    }

    private ExternalEntity maybeExternalID() throws IOException, SAXException {
        String string = null;
        if (this.peek("PUBLIC")) {
            this.whitespace("F-009");
            string = this.parsePublicId();
        } else if (!this.peek("SYSTEM")) {
            return null;
        }
        ExternalEntity externalEntity = new ExternalEntity(this.in);
        externalEntity.publicId = string;
        this.whitespace("F-008");
        externalEntity.verbatimSystemId = this.getQuotedString("F-034", null);
        externalEntity.systemId = this.resolveURI(externalEntity.verbatimSystemId);
        return externalEntity;
    }

    private void externalParameterEntity(ExternalEntity externalEntity) throws IOException, SAXException {
        if (this.isStandalone && this.fastStandalone) {
            return;
        }
        this.inExternalPE = true;
        try {
            this.pushReader(externalEntity);
        }
        catch (IOException iOException) {
            this.fatal("P-082", new Object[]{externalEntity.systemId}, iOException);
        }
        InputEntity inputEntity = this.in;
        try {
            this.maybeTextDecl();
        }
        catch (IOException iOException) {
            this.in = this.in.pop();
            this.fatal("P-082", new Object[]{externalEntity.systemId}, iOException);
        }
        while (!inputEntity.isEOF()) {
            if (this.in.isEOF()) {
                this.in = this.in.pop();
                continue;
            }
            this.doLexicalPE = false;
            if (this.maybeWhitespace() || this.maybePEReference()) continue;
            this.doLexicalPE = true;
            if (this.maybeMarkupDecl() || this.maybeConditionalSect()) continue;
        }
        if (!inputEntity.isEOF()) {
            this.fatal("P-059", new Object[]{this.in.getName()});
        }
        this.in = this.in.pop();
        this.inExternalPE = !this.in.isDocument();
        this.doLexicalPE = false;
    }

    private boolean pushReader(ExternalEntity externalEntity) throws SAXException, IOException {
        if (!externalEntity.isPE && !this.isInAttribute) {
            this.lexicalHandler.startEntity(externalEntity.name);
        }
        InputEntity inputEntity = InputEntity.getInputEntity(this.errHandler, this.locale);
        InputSource inputSource = externalEntity.getInputSource(this.resolver);
        inputEntity.init(inputSource, externalEntity.name, this.in, externalEntity.isPE);
        this.in = inputEntity;
        return true;
    }

    private NameCacheEntry maybeGetNameCacheEntry() throws IOException, SAXException {
        char c = this.getc();
        if (!XmlChars.isLetter(c) && c != ':' && c != '_') {
            this.ungetc();
            return null;
        }
        return this.nameCharString(c);
    }

    private NameCacheEntry nameCharString(char c) throws IOException, SAXException {
        int n = 1;
        this.nameTmp[0] = c;
        while ((c = this.in.getNameChar()) != '\u0000') {
            if (n >= this.nameTmp.length) {
                char[] cArray = new char[this.nameTmp.length + 10];
                System.arraycopy(this.nameTmp, 0, cArray, 0, this.nameTmp.length);
                this.nameTmp = cArray;
            }
            this.nameTmp[n++] = c;
        }
        return this.nameCache.lookupEntry(this.nameTmp, n);
    }

    void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    void setEntityResolver(EntityResolver entityResolver) {
        this.resolver = entityResolver;
    }

    void setErrorHandler(ErrorHandler errorHandler) {
        this.errHandler = errorHandler;
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.init();
        this.parseInternal(inputSource);
    }

    private void parseInternal(InputSource inputSource) throws SAXException, IOException {
        block15: {
            if (inputSource == null) {
                this.fatal("P-000");
            }
            try {
                try {
                    this.in = InputEntity.getInputEntity(this.errHandler, this.locale);
                    this.in.init(inputSource, null, null, false);
                    this.contentHandler.setDocumentLocator(this.locator);
                    this.contentHandler.startDocument();
                    this.maybeXmlDecl();
                    this.maybeMisc(false);
                    if (!this.maybeDoctypeDecl() && this.isValidating) {
                        this.warning("V-001", null);
                    }
                    this.maybeMisc(false);
                    this.donePrologue = true;
                    if (!this.in.peekc('<') || !this.maybeElement(null)) {
                        this.fatal("P-067");
                    }
                    this.afterRoot();
                    this.maybeMisc(true);
                    if (!this.in.isEOF()) {
                        this.fatal("P-001", new Object[]{Integer.toHexString(this.getc())});
                    }
                    this.contentHandler.endDocument();
                }
                catch (EndOfInputException endOfInputException) {
                    if (!this.in.isDocument()) {
                        String string = this.in.getName();
                        do {
                            this.in = this.in.pop();
                        } while (this.in.isInternal());
                        this.fatal("P-002", new Object[]{string}, endOfInputException);
                    } else {
                        this.fatal("P-003", null, endOfInputException);
                    }
                    Object var5_3 = null;
                    this.strTmp = null;
                    this.attTmp = null;
                    this.nameTmp = null;
                    this.nameCache = null;
                    this.nsAttTmp = null;
                    if (this.in != null) {
                        this.in.close();
                        this.in = null;
                    }
                    this.params.clear();
                    this.entities.clear();
                    this.notations.clear();
                    this.elements.clear();
                    this.afterDocument();
                    break block15;
                }
                catch (RuntimeException runtimeException) {
                    throw new SAXParseException(runtimeException.getMessage() != null ? runtimeException.getMessage() : runtimeException.getClass().getName(), this.locator.getPublicId(), this.locator.getSystemId(), this.locator.getLineNumber(), this.locator.getColumnNumber(), runtimeException);
                }
                Object var5_2 = null;
                this.strTmp = null;
                this.attTmp = null;
                this.nameTmp = null;
                this.nameCache = null;
                this.nsAttTmp = null;
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                this.params.clear();
                this.entities.clear();
                this.notations.clear();
                this.elements.clear();
                this.afterDocument();
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.strTmp = null;
                this.attTmp = null;
                this.nameTmp = null;
                this.nameCache = null;
                this.nsAttTmp = null;
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                this.params.clear();
                this.entities.clear();
                this.notations.clear();
                this.elements.clear();
                this.afterDocument();
                throw throwable;
            }
        }
    }

    void setDeclHandler(DeclHandler declHandler) {
        this.declHandler = declHandler;
    }

    void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    void error(String string, Object[] objectArray) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(messages.getMessage(this.locale, string, objectArray), this.locator);
        this.errHandler.error(sAXParseException);
    }

    private void fatal(String string, Object[] objectArray) throws SAXException {
        this.fatal(string, objectArray, null);
    }

    private void warning(String string, Object[] objectArray) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(messages.getMessage(this.locale, string, objectArray), this.locator);
        this.errHandler.warning(sAXParseException);
    }

    private void nextChar(char c, String string, String string2) throws IOException, SAXException {
        while (this.in.isEOF() && !this.in.isDocument()) {
            this.in = this.in.pop();
        }
        if (!this.in.peekc(c)) {
            this.fatal("P-008", new Object[]{new Character(c), messages.getMessage(this.locale, string), string2 == null ? "" : '\"' + string2 + '\"'});
        }
    }

    private String resolveURI(String string) throws SAXException {
        int n = string.indexOf(58);
        if (n == -1 || string.indexOf(47) < n) {
            String string2 = this.in.getSystemId();
            if (string2 == null) {
                this.fatal("P-055", new Object[]{string});
            }
            if (string.length() == 0) {
                string = ".";
            }
            string2 = string2.substring(0, string2.lastIndexOf(47) + 1);
            if (string.charAt(0) != '/') {
                string = string2 + string;
            } else {
                int n2 = string2.indexOf(58);
                String string3 = n2 == -1 ? "file:" : string2.substring(0, n2 + 1);
                string = string3 + string;
            }
        }
        if (string.indexOf(35) != -1) {
            this.error("P-056", new Object[]{string});
        }
        return string;
    }

    private void builtin(String string, String string2) {
        InternalEntity internalEntity = new InternalEntity(string, string2.toCharArray());
        this.entities.put(string, internalEntity);
    }

    private String getMarkupDeclname(String string, boolean bl) throws IOException, SAXException {
        this.whitespace(string);
        String string2 = this.maybeGetName();
        if (string2 == null) {
            this.fatal("P-005", new Object[]{messages.getMessage(this.locale, string)});
        }
        return string2;
    }

    private String maybeReadAttribute(String string, boolean bl) throws IOException, SAXException {
        if (!this.maybeWhitespace()) {
            if (!bl) {
                return null;
            }
            this.fatal("P-024", new Object[]{string});
        }
        if (!this.peek(string)) {
            if (bl) {
                this.fatal("P-024", new Object[]{string});
            } else {
                this.ungetc();
                return null;
            }
        }
        this.maybeWhitespace();
        this.nextChar('=', "F-023", null);
        this.maybeWhitespace();
        return this.getQuotedString("F-035", string);
    }

    private String[] processName(String string, boolean bl, boolean bl2) throws SAXException {
        String[] stringArray = this.nsSupport.processName(string, this.namePartsTmp, bl);
        if (stringArray == null) {
            String string2 = XmlNames.getLocalPart(string);
            stringArray = new String[]{"", string2 != null ? string2.intern() : "", string.intern()};
            String string3 = "P-084";
            Object[] objectArray = new Object[]{string};
            if (bl2) {
                throw new SAXParseException(messages.getMessage(this.locale, string3, objectArray), this.locator);
            }
            this.error(string3, objectArray);
        }
        return stringArray;
    }

    void validateAttributeSyntax(AttributeDecl attributeDecl, String string) throws SAXException {
    }

    private String getMixedOrChildren(ElementDecl elementDecl) throws IOException, SAXException {
        this.strTmp = new StringBuffer();
        this.nextChar('(', "F-028", elementDecl.name);
        InputEntity inputEntity = this.in;
        this.maybeWhitespace();
        this.strTmp.append('(');
        if (this.peek("#PCDATA")) {
            this.strTmp.append("#PCDATA");
            this.getMixed(elementDecl.name, inputEntity);
            elementDecl.ignoreWhitespace = false;
        } else {
            elementDecl.model = this.getcps(elementDecl.name, inputEntity);
            elementDecl.ignoreWhitespace = true;
        }
        return this.strTmp.toString();
    }

    public Locale chooseLocale(String[] stringArray) throws SAXException {
        Locale locale = messages.chooseLocale(stringArray);
        if (locale != null) {
            this.setLocale(locale);
        }
        return locale;
    }

    ContentModel newContentModel(String string) {
        return null;
    }

    ContentModel newContentModel(char c, ContentModel contentModel) {
        return null;
    }

    private ContentModel getFrequency(ContentModel contentModel) throws IOException, SAXException {
        char c = this.getc();
        if (c == '?' || c == '+' || c == '*') {
            this.strTmp.append(c);
            if (contentModel == null) {
                return null;
            }
            if (contentModel.type == '\u0000') {
                contentModel.type = c;
                return contentModel;
            }
            return this.newContentModel(c, contentModel);
        }
        this.ungetc();
        return contentModel;
    }

    ElementValidator newValidator(ElementDecl elementDecl) {
        return ElementValidator.ANY;
    }

    private boolean maybeReferenceInContent(ElementDecl elementDecl, ElementValidator elementValidator) throws IOException, SAXException {
        if (!this.in.peekc('&')) {
            return false;
        }
        if (!this.in.peekc('#')) {
            String string = this.maybeGetName();
            if (string == null) {
                this.fatal("P-009");
            }
            this.nextChar(';', "F-020", string);
            this.expandEntityInContent(elementDecl, string, elementValidator);
            return true;
        }
        elementValidator.text();
        this.contentHandler.characters(this.charTmp, 0, this.surrogatesToCharTmp(this.parseCharNumber()));
        return true;
    }

    private void content(ElementDecl elementDecl, boolean bl, ElementValidator elementValidator) throws IOException, SAXException {
        block6: {
            while (true) {
                if (this.in.peekc('<')) {
                    if (this.maybeElement(elementValidator)) continue;
                    if (this.in.peekc('/')) {
                        return;
                    }
                    if (this.maybeComment(true) || this.maybePI(true)) continue;
                    if (this.in.peek("![CDATA[", null)) {
                        this.lexicalHandler.startCDATA();
                        this.in.unparsedContent(this.contentHandler, elementValidator, elementDecl != null && elementDecl.ignoreWhitespace, this.isStandalone && this.isValidating && !elementDecl.isFromInternalSubset ? "V-023" : null);
                        this.lexicalHandler.endCDATA();
                        continue;
                    }
                    char c = this.getc();
                    this.fatal("P-079", new Object[]{Integer.toHexString(c), new Character(c)});
                }
                if (elementDecl != null && elementDecl.ignoreWhitespace && this.in.ignorableWhitespace(this.contentHandler)) {
                    if (!this.isValidating || !this.isStandalone || elementDecl.isFromInternalSubset) continue;
                    this.error("V-011", new Object[]{elementDecl.name});
                    continue;
                }
                if (this.in.parsedContent(this.contentHandler, elementValidator)) continue;
                if (this.in.isEOF()) break block6;
                if (!this.maybeReferenceInContent(elementDecl, elementValidator)) break;
            }
            throw new InternalError();
        }
        if (!bl) {
            this.fatal("P-035");
        }
    }

    private InputEntity peekDeclaration(String string) throws IOException, SAXException {
        if (!this.in.peekc('<')) {
            return null;
        }
        InputEntity inputEntity = this.in;
        if (this.in.peek(string, null)) {
            return inputEntity;
        }
        this.in.ungetc();
        return null;
    }

    private void getMixed(String string, InputEntity inputEntity) throws IOException, SAXException {
        this.maybeWhitespace();
        if (this.peek(")*") || this.peek(")")) {
            if (this.isValidating && this.in != inputEntity) {
                this.error("V-014", new Object[]{string});
            }
            this.strTmp.append(')');
            return;
        }
        Vector vector = null;
        if (this.isValidating) {
            vector = new Vector();
        }
        while (this.peek("|")) {
            this.strTmp.append('|');
            this.maybeWhitespace();
            String string2 = this.maybeGetName();
            if (string2 == null) {
                this.fatal("P-042", new Object[]{string, Integer.toHexString(this.getc())});
            }
            if (this.isValidating) {
                if (vector.contains(string2)) {
                    this.error("V-015", new Object[]{string2});
                } else {
                    vector.addElement(string2);
                }
            }
            this.strTmp.append(string2);
            this.maybeWhitespace();
        }
        if (!this.peek(")*")) {
            this.fatal("P-043", new Object[]{string, new Character(this.getc())});
        }
        if (this.isValidating && this.in != inputEntity) {
            this.error("V-014", new Object[]{string});
        }
        this.strTmp.append(')');
    }

    private void expandEntityInLiteral(String string, SimpleHashtable simpleHashtable, boolean bl) throws SAXException, IOException {
        Object object = simpleHashtable.get(string);
        if (this.entityExpansionLimit != -1 && this.entityExpansionCount++ >= this.entityExpansionLimit) {
            this.fatal("P-086", new Object[]{new Integer(this.entityExpansionLimit)});
        }
        if (object instanceof InternalEntity) {
            InternalEntity internalEntity = (InternalEntity)object;
            if (this.isValidating && this.isStandalone && !internalEntity.isFromInternalSubset) {
                this.error("V-002", new Object[]{string});
            }
            this.pushReader(internalEntity.buf, string, !internalEntity.isPE);
        } else if (object instanceof ExternalEntity) {
            if (!bl) {
                this.fatal("P-013", new Object[]{string});
            }
            this.pushReader((ExternalEntity)object);
        } else if (object == null) {
            this.fatal(simpleHashtable == this.params ? "V-022" : "P-014", new Object[]{string});
        }
    }

    private void fatal(String string, Object[] objectArray, Exception exception) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(messages.getMessage(this.locale, string, objectArray), this.locator, exception);
        this.errHandler.fatalError(sAXParseException);
        throw sAXParseException;
    }

    private String getQuotedString(String string, String string2) throws IOException, SAXException {
        char c;
        char c2 = this.in.getc();
        if (c2 != '\'' && c2 != '\"') {
            this.fatal("P-015", new Object[]{messages.getMessage(this.locale, string, new Object[]{string2})});
        }
        this.strTmp = new StringBuffer();
        while ((c = this.in.getc()) != c2) {
            this.strTmp.append(c);
        }
        return this.strTmp.toString();
    }

    private ContentModel getcps(String string, InputEntity inputEntity) throws IOException, SAXException {
        boolean bl = false;
        char c = '\u0000';
        ContentModel contentModel = null;
        ContentModel contentModel2 = null;
        ContentModel contentModel3 = null;
        do {
            String string2;
            if ((string2 = this.maybeGetName()) != null) {
                this.strTmp.append(string2);
                contentModel = this.getFrequency(this.newContentModel(string2));
            } else if (this.peek("(")) {
                InputEntity inputEntity2 = this.in;
                this.strTmp.append('(');
                this.maybeWhitespace();
                contentModel = this.getFrequency(this.getcps(string, inputEntity2));
            } else {
                this.fatal(c == '\u0000' ? "P-039" : (c == ',' ? "P-037" : "P-038"), new Object[]{new Character(this.getc())});
            }
            this.maybeWhitespace();
            if (bl) {
                char c2 = this.getc();
                if (contentModel2 != null) {
                    contentModel2 = contentModel2.next = this.newContentModel(c, contentModel);
                }
                if (c2 == c) {
                    this.strTmp.append(c);
                    this.maybeWhitespace();
                    continue;
                }
                if (c2 == ')') {
                    this.ungetc();
                    continue;
                }
                this.fatal(c == '\u0000' ? "P-041" : "P-040", new Object[]{new Character(c2), new Character(c)});
            } else {
                c = this.getc();
                if (c != '|' && c != ',') {
                    contentModel3 = contentModel2 = contentModel;
                    this.ungetc();
                    continue;
                }
                bl = true;
                contentModel3 = contentModel2 = this.newContentModel(c, contentModel);
                this.strTmp.append(c);
            }
            this.maybeWhitespace();
        } while (!this.peek(")"));
        if (this.isValidating && this.in != inputEntity) {
            this.error("V-014", new Object[]{string});
        }
        this.strTmp.append(')');
        return this.getFrequency(contentModel3);
    }

    private void expandEntityInContent(ElementDecl elementDecl, String string, ElementValidator elementValidator) throws SAXException, IOException {
        Object object = this.entities.get(string);
        InputEntity inputEntity = this.in;
        if (object == null) {
            this.fatal("P-014", new Object[]{string});
        }
        if (this.entityExpansionLimit != -1 && this.entityExpansionCount++ >= this.entityExpansionLimit) {
            this.fatal("P-086", new Object[]{new Integer(this.entityExpansionLimit)});
        }
        if (object instanceof InternalEntity) {
            InternalEntity internalEntity = (InternalEntity)object;
            if (this.isValidating && this.isStandalone && !internalEntity.isFromInternalSubset) {
                this.error("V-002", new Object[]{string});
            }
            this.pushReader(internalEntity.buf, string, true);
            this.content(elementDecl, true, elementValidator);
            if (this.in != inputEntity && !this.in.isEOF()) {
                while (this.in.isInternal()) {
                    this.in = this.in.pop();
                }
                this.fatal("P-052", new Object[]{string});
            }
            this.lexicalHandler.endEntity(string);
            this.in = this.in.pop();
        } else if (object instanceof ExternalEntity) {
            ExternalEntity externalEntity = (ExternalEntity)object;
            if (externalEntity.notation != null) {
                this.fatal("P-053", new Object[]{string});
            }
            if (this.isValidating && this.isStandalone && !externalEntity.isFromInternalSubset) {
                this.error("V-002", new Object[]{string});
            }
            this.externalParsedEntity(elementDecl, externalEntity, elementValidator);
        } else {
            throw new InternalError(string);
        }
    }

    private boolean externalParsedEntity(ElementDecl elementDecl, ExternalEntity externalEntity, ElementValidator elementValidator) throws IOException, SAXException {
        if (!this.pushReader(externalEntity)) {
            if (!this.isInAttribute) {
                this.lexicalHandler.endEntity(externalEntity.name);
            }
            return false;
        }
        this.maybeTextDecl();
        this.content(elementDecl, true, elementValidator);
        if (!this.in.isEOF()) {
            this.fatal("P-058", new Object[]{externalEntity.name});
        }
        this.in = this.in.pop();
        if (!this.isInAttribute) {
            this.lexicalHandler.endEntity(externalEntity.name);
        }
        return true;
    }

    private Vector processAttributeNS(String string, String string2, String string3, String string4, boolean bl, boolean bl2, Vector vector) throws SAXException {
        if (string.startsWith("xmlns")) {
            boolean bl3;
            boolean bl4 = bl3 = string.length() == 5;
            if (bl3 || string.charAt(5) == ':') {
                String string5 = bl3 ? "" : string.substring(6);
                if (!this.nsSupport.declarePrefix(string5, string3)) {
                    this.error("P-083", new Object[]{string5});
                }
                this.contentHandler.startPrefixMapping(string5, string3);
                if (this.prefixes) {
                    this.attTmp.addAttribute("", string5, string.intern(), string2, string3, string4, bl);
                } else if (this.isValidating && !bl2) {
                    this.nsAttTmp.addElement(string);
                }
                this.seenNSDecl = true;
                return vector;
            }
        }
        try {
            String[] stringArray = this.processName(string, true, true);
            this.attTmp.addAttribute(stringArray[0], stringArray[1], stringArray[2], string2, string3, string4, bl);
        }
        catch (SAXException sAXException) {
            if (vector == null) {
                vector = new Vector();
            }
            vector.addElement(sAXException);
            this.attTmp.addAttribute("", string, string, string2, string3, string4, bl);
        }
        return vector;
    }

    static final class Catalog
    extends MessageCatalog {
        Catalog() {
            super(class$org$apache$crimson$parser$Parser2 == null ? (class$org$apache$crimson$parser$Parser2 = Parser2.class$("org.apache.crimson.parser.Parser2")) : class$org$apache$crimson$parser$Parser2);
        }
    }

    class DocLocator
    implements Locator {
        public int getColumnNumber() {
            return Parser2.this.in == null ? -1 : Parser2.this.in.getColumnNumber();
        }

        public int getLineNumber() {
            return Parser2.this.in == null ? -1 : Parser2.this.in.getLineNumber();
        }

        public String getPublicId() {
            return Parser2.this.in == null ? null : Parser2.this.in.getPublicId();
        }

        public String getSystemId() {
            return Parser2.this.in == null ? null : Parser2.this.in.getSystemId();
        }

        DocLocator() {
        }
    }

    static class NameCache {
        NameCacheEntry[] hashtable = new NameCacheEntry[541];

        NameCache() {
        }

        String lookup(char[] cArray, int n) {
            return this.lookupEntry((char[])cArray, (int)n).name;
        }

        NameCacheEntry lookupEntry(char[] cArray, int n) {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 = n2 * 31 + cArray[i];
            }
            n2 &= Integer.MAX_VALUE;
            NameCacheEntry nameCacheEntry = this.hashtable[n2 %= this.hashtable.length];
            while (nameCacheEntry != null) {
                if (nameCacheEntry.matches(cArray, n)) {
                    return nameCacheEntry;
                }
                nameCacheEntry = nameCacheEntry.next;
            }
            nameCacheEntry = new NameCacheEntry();
            nameCacheEntry.chars = new char[n];
            System.arraycopy(cArray, 0, nameCacheEntry.chars, 0, n);
            nameCacheEntry.name = new String(nameCacheEntry.chars);
            nameCacheEntry.name = nameCacheEntry.name.intern();
            nameCacheEntry.next = this.hashtable[n2];
            this.hashtable[n2] = nameCacheEntry;
            return nameCacheEntry;
        }
    }

    static class NameCacheEntry {
        String name;
        char[] chars;
        NameCacheEntry next;

        NameCacheEntry() {
        }

        boolean matches(char[] cArray, int n) {
            if (this.chars.length != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (cArray[i] == this.chars[i]) continue;
                return false;
            }
            return true;
        }
    }

    private static class NullHandler
    extends DefaultHandler
    implements LexicalHandler,
    DeclHandler {
        private NullHandler() {
        }

        public void endCDATA() {
        }

        public void endDTD() {
        }

        public void startCDATA() {
        }

        public void comment(char[] cArray, int n, int n2) {
        }

        public void endEntity(String string) {
        }

        public void startEntity(String string) {
        }

        public void elementDecl(String string, String string2) {
        }

        public void internalEntityDecl(String string, String string2) {
        }

        public void externalEntityDecl(String string, String string2, String string3) {
        }

        public void startDTD(String string, String string2, String string3) {
        }

        public void attributeDecl(String string, String string2, String string3, String string4, String string5) {
        }
    }
}

