/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.parser;

import java.util.Enumeration;

final class SimpleHashtable
implements Enumeration {
    private Entry[] table;
    private Entry current = null;
    private int currentBucket = 0;
    private int count;
    private int threshold;
    private static final float loadFactor = 0.75f;

    public int size() {
        return this.count;
    }

    public SimpleHashtable() {
        this(11);
    }

    public void clear() {
        this.count = 0;
        this.currentBucket = 0;
        this.current = null;
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
    }

    private void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * 0.75f);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public boolean hasMoreElements() {
        if (this.current != null) {
            return true;
        }
        while (this.currentBucket < this.table.length) {
            this.current = this.table[this.currentBucket++];
            if (this.current == null) continue;
            return true;
        }
        return false;
    }

    public SimpleHashtable(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (n == 0) {
            n = 1;
        }
        this.table = new Entry[n];
        this.threshold = (int)((float)n * 0.75f);
    }

    public Object nextElement() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        Object object = this.current.key;
        this.current = this.current.next;
        return object;
    }

    public Enumeration keys() {
        this.currentBucket = 0;
        this.current = null;
        return this;
    }

    public Object get(String string) {
        Entry[] entryArray = this.table;
        int n = string.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key == string) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Object getNonInterned(String string) {
        Entry[] entryArray = this.table;
        int n = string.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(string)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key == object) {
                Object object3 = entry.value;
                entry.value = object2;
                return object3;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = entry = new Entry(n, object, object2, entryArray[n2]);
        ++this.count;
        return null;
    }

    private static class Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        protected Entry(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.value = object2;
            this.next = entry;
        }
    }
}

