/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.parser;

import java.util.Enumeration;
import java.util.StringTokenizer;
import org.apache.crimson.parser.AttributeDecl;
import org.apache.crimson.parser.ContentModel;
import org.apache.crimson.parser.ContentModelState;
import org.apache.crimson.parser.ElementDecl;
import org.apache.crimson.parser.ElementValidator;
import org.apache.crimson.parser.EndOfInputException;
import org.apache.crimson.parser.ExternalEntity;
import org.apache.crimson.parser.Parser2;
import org.apache.crimson.parser.SimpleHashtable;
import org.apache.crimson.util.XmlNames;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidatingParser
extends Parser2 {
    private SimpleHashtable ids = new SimpleHashtable();
    private final EmptyValidator EMPTY = new EmptyValidator();

    public ValidatingParser() {
        this.setIsValidating(true);
    }

    void afterDocument() {
        this.ids.clear();
    }

    void afterRoot() throws SAXException {
        Enumeration enumeration = this.ids.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Boolean bl = (Boolean)this.ids.get(string);
            if (Boolean.FALSE != bl) continue;
            this.error("V-024", new Object[]{string});
        }
    }

    public ValidatingParser(boolean bl) {
        this();
        if (bl) {
            this.setErrorHandler(new HandlerBase(){

                public void error(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }
            });
        }
    }

    private boolean isUnparsedEntity(String string) {
        Object object = this.entities.getNonInterned(string);
        if (object == null || !(object instanceof ExternalEntity)) {
            return false;
        }
        return ((ExternalEntity)object).notation != null;
    }

    void validateAttributeSyntax(AttributeDecl attributeDecl, String string) throws SAXException {
        if ("ID" == attributeDecl.type) {
            Boolean bl;
            if (!XmlNames.isName(string)) {
                this.error("V-025", new Object[]{string});
            }
            if ((bl = (Boolean)this.ids.getNonInterned(string)) == null || bl.equals(Boolean.FALSE)) {
                this.ids.put(string.intern(), Boolean.TRUE);
            } else {
                this.error("V-026", new Object[]{string});
            }
        } else if ("IDREF" == attributeDecl.type) {
            Boolean bl;
            if (!XmlNames.isName(string)) {
                this.error("V-027", new Object[]{string});
            }
            if ((bl = (Boolean)this.ids.getNonInterned(string)) == null) {
                this.ids.put(string.intern(), Boolean.FALSE);
            }
        } else if ("IDREFS" == attributeDecl.type) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                Boolean bl2;
                string = stringTokenizer.nextToken();
                if (!XmlNames.isName(string)) {
                    this.error("V-027", new Object[]{string});
                }
                if ((bl2 = (Boolean)this.ids.getNonInterned(string)) == null) {
                    this.ids.put(string.intern(), Boolean.FALSE);
                }
                bl = true;
            }
            if (!bl) {
                this.error("V-039", null);
            }
        } else if ("NMTOKEN" == attributeDecl.type) {
            if (!XmlNames.isNmtoken(string)) {
                this.error("V-028", new Object[]{string});
            }
        } else if ("NMTOKENS" == attributeDecl.type) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (!XmlNames.isNmtoken(string)) {
                    this.error("V-028", new Object[]{string});
                }
                bl = true;
            }
            if (!bl) {
                this.error("V-032", null);
            }
        } else if ("ENUMERATION" == attributeDecl.type) {
            for (int i = 0; i < attributeDecl.values.length; ++i) {
                if (!string.equals(attributeDecl.values[i])) continue;
                return;
            }
            this.error("V-029", new Object[]{string});
        } else if ("NOTATION" == attributeDecl.type) {
            for (int i = 0; i < attributeDecl.values.length; ++i) {
                if (!string.equals(attributeDecl.values[i])) continue;
                return;
            }
            this.error("V-030", new Object[]{string});
        } else if ("ENTITY" == attributeDecl.type) {
            if (!this.isUnparsedEntity(string)) {
                this.error("V-031", new Object[]{string});
            }
        } else if ("ENTITIES" == attributeDecl.type) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (!this.isUnparsedEntity(string)) {
                    this.error("V-031", new Object[]{string});
                }
                bl = true;
            }
            if (!bl) {
                this.error("V-040", null);
            }
        } else if ("CDATA" != attributeDecl.type) {
            throw new InternalError(attributeDecl.type);
        }
    }

    ContentModel newContentModel(String string) {
        return new ContentModel(string);
    }

    ContentModel newContentModel(char c, ContentModel contentModel) {
        return new ContentModel(c, contentModel);
    }

    ElementValidator newValidator(ElementDecl elementDecl) {
        if (elementDecl.validator != null) {
            return elementDecl.validator;
        }
        if (elementDecl.model != null) {
            return new ChildrenValidator(elementDecl);
        }
        elementDecl.validator = elementDecl.contentType == null || "ANY" == elementDecl.contentType ? ElementValidator.ANY : ("EMPTY" == elementDecl.contentType ? this.EMPTY : new MixedValidator(elementDecl));
        return elementDecl.validator;
    }

    class ChildrenValidator
    extends ElementValidator {
        private ContentModelState state;
        private String name;

        public void done() throws SAXException {
            if (this.state != null && !this.state.terminate()) {
                ValidatingParser.this.error("V-038", new Object[]{this.name});
            }
        }

        public void text() throws SAXException {
            ValidatingParser.this.error("V-037", new Object[]{this.name});
        }

        public void consume(String string) throws SAXException {
            if (this.state == null) {
                ValidatingParser.this.error("V-035", new Object[]{this.name, string});
            } else {
                try {
                    this.state = this.state.advance(string);
                }
                catch (EndOfInputException endOfInputException) {
                    ValidatingParser.this.error("V-036", new Object[]{this.name, string});
                }
            }
        }

        ChildrenValidator(ElementDecl elementDecl) {
            this.state = new ContentModelState(elementDecl.model);
            this.name = elementDecl.name;
        }
    }

    class EmptyValidator
    extends ElementValidator {
        public void text() throws SAXException {
            ValidatingParser.this.error("V-033", null);
        }

        public void consume(String string) throws SAXException {
            ValidatingParser.this.error("V-033", null);
        }

        EmptyValidator() {
        }
    }

    class MixedValidator
    extends ElementValidator {
        private ElementDecl element;

        public void consume(String string) throws SAXException {
            String string2 = this.element.contentType;
            int n = 8;
            while ((n = string2.indexOf(string, n + 1)) >= 9) {
                char c;
                if (string2.charAt(n - 1) != '|' || (c = string2.charAt(n + string.length())) != '|' && c != ')') continue;
                return;
            }
            ValidatingParser.this.error("V-034", new Object[]{this.element.name, string, string2});
        }

        MixedValidator(ElementDecl elementDecl) {
            this.element = elementDecl;
        }
    }
}

