/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.parser;

import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.util.Hashtable;

final class XmlReader
extends Reader {
    private static final int MAXPUSHBACK = 512;
    private Reader in;
    private String assignedEncoding;
    private boolean closed;
    private static final Hashtable charsets = new Hashtable(31);

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        int n = this.in.read();
        if (n == -1) {
            this.close();
        }
        return n;
    }

    static {
        charsets.put("UTF-16", "Unicode");
        charsets.put("ISO-10646-UCS-2", "Unicode");
        charsets.put("EBCDIC-CP-US", "cp037");
        charsets.put("EBCDIC-CP-CA", "cp037");
        charsets.put("EBCDIC-CP-NL", "cp037");
        charsets.put("EBCDIC-CP-WT", "cp037");
        charsets.put("EBCDIC-CP-DK", "cp277");
        charsets.put("EBCDIC-CP-NO", "cp277");
        charsets.put("EBCDIC-CP-FI", "cp278");
        charsets.put("EBCDIC-CP-SE", "cp278");
        charsets.put("EBCDIC-CP-IT", "cp280");
        charsets.put("EBCDIC-CP-ES", "cp284");
        charsets.put("EBCDIC-CP-GB", "cp285");
        charsets.put("EBCDIC-CP-FR", "cp297");
        charsets.put("EBCDIC-CP-AR1", "cp420");
        charsets.put("EBCDIC-CP-HE", "cp424");
        charsets.put("EBCDIC-CP-BE", "cp500");
        charsets.put("EBCDIC-CP-CH", "cp500");
        charsets.put("EBCDIC-CP-ROECE", "cp870");
        charsets.put("EBCDIC-CP-YU", "cp870");
        charsets.put("EBCDIC-CP-IS", "cp871");
        charsets.put("EBCDIC-CP-AR2", "cp918");
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.in.close();
        this.in = null;
        this.closed = true;
    }

    public void reset() throws IOException {
        if (this.in != null) {
            this.in.reset();
        }
    }

    public boolean markSupported() {
        return this.in == null ? false : this.in.markSupported();
    }

    public boolean ready() throws IOException {
        return this.in == null ? false : this.in.ready();
    }

    public void mark(int n) throws IOException {
        if (this.in != null) {
            this.in.mark(n);
        }
    }

    public long skip(long l) throws IOException {
        return this.in == null ? 0L : this.in.skip(l);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.closed) {
            return -1;
        }
        int n3 = this.in.read(cArray, n, n2);
        if (n3 == -1) {
            this.close();
        }
        return n3;
    }

    private XmlReader(InputStream inputStream) throws IOException {
        super(inputStream);
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 512);
        byte[] byArray = new byte[4];
        int n = pushbackInputStream.read(byArray);
        if (n > 0) {
            pushbackInputStream.unread(byArray, 0, n);
        }
        if (n == 4) {
            block0 : switch (byArray[0] & 0xFF) {
                case 0: {
                    if (byArray[1] != 60 || byArray[2] != 0 || byArray[3] != 63) break;
                    this.setEncoding(pushbackInputStream, "UnicodeBig");
                    return;
                }
                case 60: {
                    switch (byArray[1] & 0xFF) {
                        default: {
                            break block0;
                        }
                        case 0: {
                            if (byArray[2] != 63 || byArray[3] != 0) break block0;
                            this.setEncoding(pushbackInputStream, "UnicodeLittle");
                            return;
                        }
                        case 63: 
                    }
                    if (byArray[2] != 120 || byArray[3] != 109) break;
                    this.useEncodingDecl(pushbackInputStream, "UTF8");
                    return;
                }
                case 76: {
                    if (byArray[1] != 111 || (0xFF & byArray[2]) != 167 || (0xFF & byArray[3]) != 148) break;
                    this.useEncodingDecl(pushbackInputStream, "CP037");
                    return;
                }
                case 254: {
                    if ((byArray[1] & 0xFF) != 255) break;
                    this.setEncoding(pushbackInputStream, "UTF-16");
                    return;
                }
                case 255: {
                    if ((byArray[1] & 0xFF) != 254) break;
                    this.setEncoding(pushbackInputStream, "UTF-16");
                    return;
                }
            }
        }
        this.setEncoding(pushbackInputStream, "UTF-8");
    }

    public String getEncoding() {
        return this.assignedEncoding;
    }

    public static Reader createReader(InputStream inputStream) throws IOException {
        return new XmlReader(inputStream);
    }

    private void setEncoding(InputStream inputStream, String string) throws IOException {
        this.assignedEncoding = string;
        this.in = XmlReader.createReader(inputStream, string);
    }

    private void useEncodingDecl(PushbackInputStream pushbackInputStream, String string) throws IOException {
        byte[] byArray = new byte[512];
        int n = pushbackInputStream.read(byArray, 0, byArray.length);
        pushbackInputStream.unread(byArray, 0, n);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray, 4, n), string);
        int n2 = ((Reader)inputStreamReader).read();
        if (n2 != 108) {
            this.setEncoding(pushbackInputStream, "UTF-8");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = null;
        String string2 = null;
        boolean bl = false;
        char c = '\u0000';
        boolean bl2 = false;
        block0: for (int i = 0; i < 507 && (n2 = ((Reader)inputStreamReader).read()) != -1; ++i) {
            if (n2 == 32 || n2 == 9 || n2 == 10 || n2 == 13) continue;
            if (i == 0) break;
            if (n2 == 63) {
                bl2 = true;
            } else if (bl2) {
                if (n2 == 62) break;
                bl2 = false;
            }
            if (string2 == null || !bl) {
                if (stringBuffer2 == null) {
                    if (Character.isWhitespace((char)n2)) continue;
                    stringBuffer2 = stringBuffer;
                    stringBuffer.setLength(0);
                    stringBuffer.append((char)n2);
                    bl = false;
                    continue;
                }
                if (Character.isWhitespace((char)n2)) {
                    string2 = stringBuffer2.toString();
                    continue;
                }
                if (n2 == 61) {
                    if (string2 == null) {
                        string2 = stringBuffer2.toString();
                    }
                    bl = true;
                    stringBuffer2 = null;
                    c = '\u0000';
                    continue;
                }
                stringBuffer2.append((char)n2);
                continue;
            }
            if (Character.isWhitespace((char)n2)) continue;
            if (n2 == 34 || n2 == 39) {
                if (c == '\u0000') {
                    c = (char)n2;
                    stringBuffer.setLength(0);
                    continue;
                }
                if (n2 == c) {
                    if ("encoding".equals(string2)) {
                        this.assignedEncoding = stringBuffer.toString();
                        for (i = 0; i < this.assignedEncoding.length(); ++i) {
                            n2 = this.assignedEncoding.charAt(i);
                            if (!(n2 >= 65 && n2 <= 90 || n2 >= 97 && n2 <= 122) && (i == 0 || i <= 0 || n2 != 45 && (n2 < 48 || n2 > 57) && n2 != 46 && n2 != 95)) break block0;
                        }
                        this.setEncoding(pushbackInputStream, this.assignedEncoding);
                        return;
                    }
                    string2 = null;
                    continue;
                }
            }
            stringBuffer.append((char)n2);
        }
        this.setEncoding(pushbackInputStream, "UTF-8");
    }

    private static String std2java(String string) {
        String string2 = string.toUpperCase();
        return (string2 = (String)charsets.get(string2)) != null ? string2 : string;
    }

    public static Reader createReader(InputStream inputStream, String string) throws IOException {
        if (string == null) {
            return new XmlReader(inputStream);
        }
        if ("UTF-8".equalsIgnoreCase(string) || "UTF8".equalsIgnoreCase(string)) {
            return new Utf8Reader(inputStream);
        }
        if ("US-ASCII".equalsIgnoreCase(string) || "ASCII".equalsIgnoreCase(string)) {
            return new AsciiReader(inputStream);
        }
        if ("ISO-8859-1".equalsIgnoreCase(string)) {
            return new Iso8859_1Reader(inputStream);
        }
        return new InputStreamReader(inputStream, XmlReader.std2java(string));
    }

    static final class AsciiReader
    extends BaseReader {
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3;
            if (this.instream == null) {
                return -1;
            }
            if (n + n2 > cArray.length || n < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            for (n3 = 0; n3 < n2; ++n3) {
                byte by;
                if (this.start >= this.finish) {
                    this.start = 0;
                    this.finish = this.instream.read(this.buffer, 0, this.buffer.length);
                    if (this.finish <= 0) {
                        if (this.finish > 0) break;
                        this.close();
                        break;
                    }
                }
                if (((by = this.buffer[this.start++]) & 0x80) != 0) {
                    throw new CharConversionException("Illegal ASCII character, 0x" + Integer.toHexString(by & 0xFF));
                }
                cArray[n + n3] = (char)by;
            }
            if (n3 == 0 && this.finish <= 0) {
                return -1;
            }
            return n3;
        }

        AsciiReader(InputStream inputStream) {
            super(inputStream);
        }
    }

    static abstract class BaseReader
    extends Reader {
        protected InputStream instream;
        protected byte[] buffer;
        protected int start;
        protected int finish;

        public void close() throws IOException {
            if (this.instream != null) {
                this.instream.close();
                this.finish = 0;
                this.start = 0;
                this.buffer = null;
                this.instream = null;
            }
        }

        public boolean ready() throws IOException {
            return this.instream == null || this.finish - this.start > 0 || this.instream.available() != 0;
        }

        BaseReader(InputStream inputStream) {
            super(inputStream);
            this.instream = inputStream;
            this.buffer = new byte[8192];
        }
    }

    static final class Iso8859_1Reader
    extends BaseReader {
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3;
            if (this.instream == null) {
                return -1;
            }
            if (n + n2 > cArray.length || n < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (this.start >= this.finish) {
                    this.start = 0;
                    this.finish = this.instream.read(this.buffer, 0, this.buffer.length);
                    if (this.finish <= 0) {
                        if (this.finish > 0) break;
                        this.close();
                        break;
                    }
                }
                cArray[n + n3] = (char)(0xFF & this.buffer[this.start++]);
            }
            if (n3 == 0 && this.finish <= 0) {
                return -1;
            }
            return n3;
        }

        Iso8859_1Reader(InputStream inputStream) {
            super(inputStream);
        }
    }

    static final class Utf8Reader
    extends BaseReader {
        private char nextChar;

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            int n4 = 0;
            if (n2 <= 0) {
                return 0;
            }
            if (n + n2 > cArray.length || n < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (this.nextChar != '\u0000') {
                cArray[n + n3++] = this.nextChar;
                this.nextChar = '\u0000';
            }
            while (n3 < n2) {
                int n5;
                block20: {
                    if (this.finish <= this.start) {
                        if (this.instream == null) {
                            n4 = -1;
                            break;
                        }
                        this.start = 0;
                        this.finish = this.instream.read(this.buffer, 0, this.buffer.length);
                        if (this.finish <= 0) {
                            this.close();
                            n4 = -1;
                            break;
                        }
                    }
                    if (((n4 = this.buffer[this.start] & 0xFF) & 0x80) == 0) {
                        ++this.start;
                        cArray[n + n3++] = (char)n4;
                        continue;
                    }
                    n5 = this.start;
                    try {
                        if ((this.buffer[n5] & 0xE0) == 192) {
                            n4 = (this.buffer[n5++] & 0x1F) << 6;
                            n4 += this.buffer[n5++] & 0x3F;
                            break block20;
                        }
                        if ((this.buffer[n5] & 0xF0) == 224) {
                            n4 = (this.buffer[n5++] & 0xF) << 12;
                            n4 += (this.buffer[n5++] & 0x3F) << 6;
                            n4 += this.buffer[n5++] & 0x3F;
                            break block20;
                        }
                        if ((this.buffer[n5] & 0xF8) == 240) {
                            n4 = (this.buffer[n5++] & 7) << 18;
                            n4 += (this.buffer[n5++] & 0x3F) << 12;
                            n4 += (this.buffer[n5++] & 0x3F) << 6;
                            if ((n4 += this.buffer[n5++] & 0x3F) > 0x10FFFF) {
                                throw new CharConversionException("UTF-8 encoding of character 0x00" + Integer.toHexString(n4) + " can't be converted to Unicode.");
                            }
                            if (n4 > 65535) {
                                this.nextChar = (char)(56320 + ((n4 -= 65536) & 0x3FF));
                                n4 = 55296 + (n4 >> 10);
                            }
                            break block20;
                        }
                        throw new CharConversionException("Unconvertible UTF-8 character beginning with 0x" + Integer.toHexString(this.buffer[this.start] & 0xFF));
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        n4 = 0;
                    }
                }
                if (n5 > this.finish) {
                    System.arraycopy(this.buffer, this.start, this.buffer, 0, this.finish - this.start);
                    this.finish -= this.start;
                    this.start = 0;
                    n5 = this.instream.read(this.buffer, this.finish, this.buffer.length - this.finish);
                    if (n5 < 0) {
                        this.close();
                        throw new CharConversionException("Partial UTF-8 char");
                    }
                    this.finish += n5;
                    continue;
                }
                ++this.start;
                while (this.start < n5) {
                    if ((this.buffer[this.start] & 0xC0) != 128) {
                        this.close();
                        throw new CharConversionException("Malformed UTF-8 char -- is an XML encoding declaration missing?");
                    }
                    ++this.start;
                }
                cArray[n + n3++] = (char)n4;
                if (this.nextChar == '\u0000' || n3 >= n2) continue;
                cArray[n + n3++] = this.nextChar;
                this.nextChar = '\u0000';
            }
            if (n3 > 0) {
                return n3;
            }
            return n4 == -1 ? -1 : 0;
        }

        Utf8Reader(InputStream inputStream) {
            super(inputStream);
        }
    }
}

