/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.IOException;
import java.io.Writer;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.NamespacedNode;
import org.apache.crimson.tree.XmlWriteContext;
import org.apache.crimson.util.XmlNames;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeNode
extends NamespacedNode
implements Attr {
    private String value;
    private boolean specified;
    private String defaultValue;
    private Element ownerElement;

    public short getNodeType() {
        return 2;
    }

    public boolean getSpecified() {
        return this.specified;
    }

    void checkChildType(int n) throws DOMException {
        switch (n) {
            case 3: 
            case 5: {
                return;
            }
        }
        throw new DomEx(3);
    }

    void setSpecified(boolean bl) {
        this.specified = bl;
    }

    String getDefaultValue() {
        return this.defaultValue;
    }

    public String getName() {
        return this.qName;
    }

    public String getNodeValue() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public void setNodeValue(String string) {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        this.value = string;
        this.specified = true;
    }

    public void setValue(String string) {
        this.setNodeValue(string);
    }

    AttributeNode makeClone() {
        AttributeNode attributeNode = new AttributeNode(this.namespaceURI, this.qName, this.value, this.specified, this.defaultValue);
        attributeNode.ownerDocument = this.ownerDocument;
        return attributeNode;
    }

    AttributeNode cloneAttributeNode(boolean bl) {
        try {
            AttributeNode attributeNode = this.makeClone();
            if (bl) {
                Node node;
                int n = 0;
                while ((node = this.item(n)) != null) {
                    node = node.cloneNode(true);
                    attributeNode.appendChild(node);
                    ++n;
                }
            }
            return attributeNode;
        }
        catch (DOMException dOMException) {
            throw new RuntimeException(this.getMessage("A-002"));
        }
    }

    public void writeChildrenXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        block7: for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            switch (c) {
                case '<': {
                    writer.write("&lt;");
                    continue block7;
                }
                case '>': {
                    writer.write("&gt;");
                    continue block7;
                }
                case '&': {
                    writer.write("&amp;");
                    continue block7;
                }
                case '\'': {
                    writer.write("&apos;");
                    continue block7;
                }
                case '\"': {
                    writer.write("&quot;");
                    continue block7;
                }
                default: {
                    writer.write(c);
                }
            }
        }
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        writer.write(this.qName);
        writer.write("=\"");
        this.writeChildrenXml(xmlWriteContext);
        writer.write(34);
    }

    public Element getOwnerElement() {
        return this.ownerElement;
    }

    void setOwnerElement(Element element) {
        if (element != null && this.ownerElement != null) {
            throw new IllegalStateException(this.getMessage("A-000", new Object[]{element.getTagName()}));
        }
        this.ownerElement = element;
    }

    public Node getNextSibling() {
        return null;
    }

    public Node getParentNode() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node cloneNode(boolean bl) {
        AttributeNode attributeNode = this.cloneAttributeNode(bl);
        attributeNode.specified = true;
        return attributeNode;
    }

    static void checkArguments(String string, String string2) throws DomEx {
        if (string2 == null) {
            throw new DomEx(14);
        }
        int n = string2.indexOf(58);
        if (n <= 0) {
            if (!XmlNames.isUnqualifiedName(string2)) {
                throw new DomEx(5);
            }
            if ("xmlns".equals(string2) && !"http://www.w3.org/2000/xmlns/".equals(string)) {
                throw new DomEx(14);
            }
            return;
        }
        int n2 = string2.lastIndexOf(58);
        if (n2 != n) {
            throw new DomEx(14);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        if (!XmlNames.isUnqualifiedName(string3) || !XmlNames.isUnqualifiedName(string4)) {
            throw new DomEx(5);
        }
        if (string == null || "xml".equals(string3) && !"http://www.w3.org/XML/1998/namespace".equals(string)) {
            throw new DomEx(14);
        }
    }

    public AttributeNode(String string, String string2, String string3, boolean bl, String string4) throws DOMException {
        super(string, string2);
        this.value = string3;
        this.specified = bl;
        this.defaultValue = string4;
    }
}

