/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.apache.crimson.parser.AttributesEx;
import org.apache.crimson.tree.AttributeNode;
import org.apache.crimson.tree.AttributeNode1;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.XmlWritable;
import org.apache.crimson.tree.XmlWriteContext;
import org.apache.crimson.util.XmlNames;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

final class AttributeSet
implements NamedNodeMap,
XmlWritable {
    private boolean readonly;
    private Vector list;
    private Element ownerElement;

    public int getLength() {
        return this.list.size();
    }

    private AttributeSet() {
    }

    public void setReadonly() {
        this.readonly = true;
        for (int i = 0; i < this.list.size(); ++i) {
            ((AttributeNode)this.list.elementAt(i)).setReadonly(true);
        }
    }

    void trimToSize() {
        this.list.trimToSize();
    }

    public boolean isReadonly() {
        if (this.readonly) {
            return true;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            if (!((AttributeNode)this.list.elementAt(i)).isReadonly()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            XmlWriteContext xmlWriteContext = new XmlWriteContext(charArrayWriter);
            this.writeXml(xmlWriteContext);
            return charArrayWriter.toString();
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }

    AttributeSet(AttributeSet attributeSet) {
        int n = attributeSet.getLength();
        this.list = new Vector(n);
        for (int i = 0; i < n; ++i) {
            Node node = attributeSet.item(i);
            if (!(node instanceof AttributeNode)) {
                throw new IllegalArgumentException(((NodeBase)node).getMessage("A-003"));
            }
            AttributeNode attributeNode = (AttributeNode)node;
            if (!attributeNode.getSpecified()) continue;
            node = attributeNode.cloneAttributeNode(true);
            this.list.addElement(node);
        }
        this.list.trimToSize();
    }

    AttributeSet(AttributeSet attributeSet, boolean bl) {
        int n = attributeSet.getLength();
        this.list = new Vector(n);
        for (int i = 0; i < n; ++i) {
            Node node = attributeSet.item(i);
            if (!(node instanceof AttributeNode)) {
                throw new IllegalArgumentException(((NodeBase)node).getMessage("A-003"));
            }
            AttributeNode attributeNode = (AttributeNode)node;
            node = attributeNode.cloneAttributeNode(bl);
            this.list.addElement(node);
        }
    }

    public void writeChildrenXml(XmlWriteContext xmlWriteContext) throws IOException {
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            AttributeNode attributeNode = (AttributeNode)this.list.elementAt(i);
            if (!attributeNode.getSpecified()) continue;
            writer.write(32);
            attributeNode.writeXml(xmlWriteContext);
        }
    }

    AttributeSet(Element element) {
        this.list = new Vector(5);
        this.ownerElement = element;
    }

    void setOwnerElement(Element element) {
        if (element != null && this.ownerElement != null) {
            throw new IllegalStateException(((NodeBase)((Object)element)).getMessage("A-004"));
        }
        this.ownerElement = element;
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            AttributeNode attributeNode = (AttributeNode)this.list.elementAt(i);
            attributeNode.setOwnerElement(null);
            attributeNode.setOwnerElement(element);
        }
    }

    public Node item(int n) {
        if (n < 0 || n >= this.list.size()) {
            return null;
        }
        return (Node)this.list.elementAt(n);
    }

    String getValue(String string) {
        Attr attr = (Attr)this.getNamedItem(string);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    static AttributeSet createAttributeSet1(Attributes attributes) throws DOMException {
        AttributeSet attributeSet = new AttributeSet();
        int n = attributes.getLength();
        AttributesEx attributesEx = null;
        attributeSet.list = new Vector(n);
        if (attributes instanceof AttributesEx) {
            attributesEx = (AttributesEx)attributes;
        }
        for (int i = 0; i < n; ++i) {
            AttributeNode1 attributeNode1 = new AttributeNode1(attributes.getQName(i), attributes.getValue(i), attributesEx == null ? true : attributesEx.isSpecified(i), attributesEx == null ? null : attributesEx.getDefault(i));
            attributeSet.list.addElement(attributeNode1);
        }
        return attributeSet;
    }

    static AttributeSet createAttributeSet2(Attributes attributes) throws DOMException {
        AttributeSet attributeSet = new AttributeSet();
        int n = attributes.getLength();
        AttributesEx attributesEx = null;
        attributeSet.list = new Vector(n);
        if (attributes instanceof AttributesEx) {
            attributesEx = (AttributesEx)attributes;
        }
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = attributes.getQName(i);
            if ("xmlns".equals(string2) || "xmlns".equals(XmlNames.getPrefix(string2))) {
                string = "http://www.w3.org/2000/xmlns/";
            } else {
                string = attributes.getURI(i);
                if ("".equals(string)) {
                    string = null;
                }
            }
            AttributeNode attributeNode = new AttributeNode(string, string2, attributes.getValue(i), attributesEx == null ? true : attributesEx.isSpecified(i), attributesEx == null ? null : attributesEx.getDefault(i));
            attributeSet.list.addElement(attributeNode);
        }
        return attributeSet;
    }

    public Node getNamedItem(String string) {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Node node = this.item(i);
            if (!node.getNodeName().equals(string)) continue;
            return node;
        }
        return null;
    }

    public Node removeNamedItem(String string) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        for (int i = 0; i < this.list.size(); ++i) {
            Node node = (Node)this.list.elementAt(i);
            if (!node.getNodeName().equals(string)) continue;
            this.list.removeElementAt(i);
            AttributeNode attributeNode = (AttributeNode)node;
            String string2 = attributeNode.getDefaultValue();
            if (string2 != null) {
                AttributeNode attributeNode2 = attributeNode.cloneAttributeNode(true);
                attributeNode2.setOwnerElement(attributeNode.getOwnerElement());
                attributeNode2.setValue(string2);
                attributeNode2.setSpecified(false);
                this.list.addElement(attributeNode2);
            }
            attributeNode.setOwnerElement(null);
            return attributeNode;
        }
        throw new DomEx(8);
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(node instanceof AttributeNode) || node.getOwnerDocument() != this.ownerElement.getOwnerDocument()) {
            throw new DomEx(4);
        }
        AttributeNode attributeNode = (AttributeNode)node;
        if (attributeNode.getOwnerElement() != null) {
            throw new DomEx(10);
        }
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            AttributeNode attributeNode2 = (AttributeNode)this.item(i);
            if (!attributeNode2.getNodeName().equals(node.getNodeName())) continue;
            if (attributeNode2.isReadonly()) {
                throw new DomEx(7);
            }
            attributeNode.setOwnerElement(this.ownerElement);
            this.list.setElementAt(attributeNode, i);
            attributeNode2.setOwnerElement(null);
            return attributeNode2;
        }
        attributeNode.setOwnerElement(this.ownerElement);
        this.list.addElement(node);
        return null;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(node instanceof AttributeNode) || node.getOwnerDocument() != this.ownerElement.getOwnerDocument()) {
            throw new DomEx(4);
        }
        AttributeNode attributeNode = (AttributeNode)node;
        if (attributeNode.getOwnerElement() != null) {
            throw new DomEx(10);
        }
        String string = attributeNode.getLocalName();
        String string2 = attributeNode.getNamespaceURI();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            AttributeNode attributeNode2 = (AttributeNode)this.item(i);
            String string3 = attributeNode2.getLocalName();
            String string4 = attributeNode2.getNamespaceURI();
            if (string != string3 && (string == null || !string.equals(string3)) || string2 != string4 && (string2 == null || !string2.equals(string4))) continue;
            if (attributeNode2.isReadonly()) {
                throw new DomEx(7);
            }
            attributeNode.setOwnerElement(this.ownerElement);
            this.list.setElementAt(attributeNode, i);
            attributeNode2.setOwnerElement(null);
            return attributeNode2;
        }
        attributeNode.setOwnerElement(this.ownerElement);
        this.list.addElement(attributeNode);
        return null;
    }

    public Node getNamedItemNS(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            String string3;
            Node node = this.item(i);
            String string4 = node.getLocalName();
            if (!string2.equals(string4) || string != (string3 = node.getNamespaceURI()) && (string == null || !string.equals(string3))) continue;
            return node;
        }
        return null;
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (string2 == null) {
            throw new DomEx(8);
        }
        for (int i = 0; i < this.list.size(); ++i) {
            String string3;
            Node node = (Node)this.list.elementAt(i);
            String string4 = node.getLocalName();
            if (!string2.equals(string4) || string != (string3 = node.getNamespaceURI()) && (string == null || !string.equals(string3))) continue;
            this.list.removeElementAt(i);
            AttributeNode attributeNode = (AttributeNode)node;
            String string5 = attributeNode.getDefaultValue();
            if (string5 != null) {
                AttributeNode attributeNode2 = attributeNode.cloneAttributeNode(true);
                attributeNode2.setOwnerElement(attributeNode.getOwnerElement());
                attributeNode2.setValue(string5);
                attributeNode2.setSpecified(false);
                this.list.addElement(attributeNode2);
            }
            attributeNode.setOwnerElement(null);
            return attributeNode;
        }
        throw new DomEx(8);
    }
}

