/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.IOException;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.TextNode;
import org.apache.crimson.tree.TreeWalker;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlWriteContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class ParentNode
extends NodeBase {
    private NodeBase[] children;
    private int length;

    public final int getLength() {
        return this.length;
    }

    ParentNode() {
    }

    private void mutated() {
        XmlDocument xmlDocument = this.ownerDocument;
        if (xmlDocument == null && this instanceof XmlDocument) {
            xmlDocument = (XmlDocument)this;
        }
        if (xmlDocument != null) {
            ++xmlDocument.mutationCount;
        }
    }

    public void normalize() {
        Node node;
        boolean bl = false;
        boolean bl2 = false;
        if (this.readonly) {
            throw new DomEx(7);
        }
        int n = 0;
        while ((node = this.item(n)) != null) {
            switch (node.getNodeType()) {
                case 1: {
                    ((Element)node).normalize();
                    break;
                }
                case 3: {
                    Node node2 = this.item(n + 1);
                    if (node2 == null || node2.getNodeType() != 3) break;
                    ((TextNode)node).joinNextText();
                    --n;
                    break;
                }
            }
            ++n;
        }
    }

    void reduceWaste() {
        if (this.children == null) {
            return;
        }
        if (this.children.length - this.length > 6) {
            this.trimToSize();
        }
    }

    public void trimToSize() {
        if (this.length == 0) {
            this.children = null;
        } else if (this.children.length != this.length) {
            NodeBase[] nodeBaseArray = new NodeBase[this.length];
            System.arraycopy(this.children, 0, nodeBaseArray, 0, this.length);
            this.children = nodeBaseArray;
        }
    }

    public final boolean hasChildNodes() {
        return this.length > 0;
    }

    abstract void checkChildType(int var1) throws DOMException;

    public int removeWhiteSpaces(char[] cArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            int n3;
            boolean bl = false;
            if ((n3 = cArray[n2++]) == 32 || n3 == 9 || n3 == 10 || n3 == 13) {
                n3 = 32;
                bl = true;
            }
            cArray[n++] = n3;
            if (!bl) continue;
            while (n2 < cArray.length && ((n3 = cArray[n2]) == 32 || n3 == 9 || n3 == 10 || n3 == 13)) {
                ++n2;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeChildrenXml(XmlWriteContext xmlWriteContext) throws IOException {
        if (this.children == null) {
            return;
        }
        int n = 0;
        boolean bl = true;
        boolean bl2 = true;
        if (this.getNodeType() == 1) {
            bl = "preserve".equals(this.getInheritedAttribute("xml:space"));
            n = xmlWriteContext.getIndentLevel();
        }
        try {
            if (!bl) {
                xmlWriteContext.setIndentLevel(n + 2);
            }
            for (int i = 0; i < this.length; ++i) {
                if (!bl && this.children[i].getNodeType() != 3) {
                    xmlWriteContext.printIndent();
                    bl2 = false;
                }
                this.children[i].writeXml(xmlWriteContext);
            }
            Object var7_6 = null;
            if (bl) return;
            xmlWriteContext.setIndentLevel(n);
            if (bl2) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (bl) throw throwable;
            xmlWriteContext.setIndentLevel(n);
            if (bl2) throw throwable;
            xmlWriteContext.printIndent();
            throw throwable;
        }
        xmlWriteContext.printIndent();
    }

    public final Node getFirstChild() {
        if (this.length == 0) {
            return null;
        }
        return this.children[0];
    }

    public final Node getLastChild() {
        if (this.length == 0) {
            return null;
        }
        return this.children[this.length - 1];
    }

    public final Node item(int n) {
        if (this.length == 0 || n >= this.length) {
            return null;
        }
        try {
            return this.children[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public final int getIndexOf(Node node) {
        for (int i = 0; i < this.length; ++i) {
            if (this.children[i] != node) continue;
            return i;
        }
        return -1;
    }

    private void checkNotAncestor(Node node) throws DOMException {
        if (!node.hasChildNodes()) {
            return;
        }
        for (Node node2 = this; node2 != null; node2 = node2.getParentNode()) {
            if (node != node2) continue;
            throw new DomEx(3);
        }
    }

    private NodeBase checkDocument(Node node) throws DOMException {
        if (node == null) {
            throw new DomEx(3);
        }
        if (!(node instanceof NodeBase)) {
            throw new DomEx(4);
        }
        Document document = node.getOwnerDocument();
        XmlDocument xmlDocument = this.ownerDocument;
        NodeBase nodeBase = (NodeBase)node;
        if (xmlDocument == null && this instanceof XmlDocument) {
            xmlDocument = (XmlDocument)this;
        }
        if (document != null && document != xmlDocument) {
            throw new DomEx(4);
        }
        if (document == null) {
            nodeBase.setOwnerDocument(xmlDocument);
        }
        if (nodeBase.hasChildNodes()) {
            Node node2;
            int n = 0;
            while ((node2 = nodeBase.item(n)) != null) {
                if (node2.getOwnerDocument() == null) {
                    ((NodeBase)node2).setOwnerDocument(xmlDocument);
                } else if (node2.getOwnerDocument() != xmlDocument) {
                    throw new DomEx(4);
                }
                ++n;
            }
        }
        return nodeBase;
    }

    public Node appendChild(Node node) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        NodeBase nodeBase = this.checkDocument(node);
        if (node.getNodeType() == 11) {
            this.consumeFragment(node, null);
            return node;
        }
        this.checkNotAncestor(node);
        this.checkChildType(nodeBase.getNodeType());
        if (this.children == null) {
            this.children = new NodeBase[3];
        } else if (this.children.length == this.length) {
            NodeBase[] nodeBaseArray = new NodeBase[this.length * 2];
            System.arraycopy(this.children, 0, nodeBaseArray, 0, this.length);
            this.children = nodeBaseArray;
        }
        nodeBase.setParentNode(this, this.length);
        this.children[this.length++] = nodeBase;
        this.mutated();
        return nodeBase;
    }

    public Node removeChild(Node node) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(node instanceof NodeBase)) {
            throw new DomEx(8);
        }
        NodeBase nodeBase = (NodeBase)node;
        for (int i = 0; i < this.length; ++i) {
            if (this.children[i] != nodeBase) continue;
            if (i + 1 != this.length) {
                System.arraycopy(this.children, i + 1, this.children, i, this.length - 1 - i);
            }
            --this.length;
            this.children[this.length] = null;
            nodeBase.setParentNode(null, -1);
            this.mutated();
            return node;
        }
        throw new DomEx(8);
    }

    private void consumeFragment(Node node, Node node2) throws DOMException {
        Node node3;
        ParentNode parentNode = (ParentNode)node;
        int n = 0;
        while ((node3 = parentNode.item(n)) != null) {
            this.checkNotAncestor(node3);
            this.checkChildType(node3.getNodeType());
            ++n;
        }
        while ((node3 = parentNode.item(0)) != null) {
            this.insertBefore(node3, node2);
        }
    }

    public NodeList getElementsByTagName(String string) {
        if ("*".equals(string)) {
            string = null;
        }
        return new TagList(string);
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        int n;
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (node2 == null) {
            return this.appendChild(node);
        }
        if (this.length == 0) {
            throw new DomEx(8);
        }
        NodeBase nodeBase = this.checkDocument(node);
        if (node.getNodeType() == 11) {
            this.consumeFragment(node, node2);
            return node;
        }
        this.checkNotAncestor(node);
        this.checkChildType(node.getNodeType());
        for (n = 0; n < this.length; ++n) {
            if (this.children[n] != node) continue;
            this.removeChild(node);
            break;
        }
        if (this.children.length == this.length) {
            NodeBase[] nodeBaseArray = new NodeBase[this.length * 2];
            System.arraycopy(this.children, 0, nodeBaseArray, 0, this.length);
            this.children = nodeBaseArray;
        }
        for (n = 0; n < this.length; ++n) {
            if (this.children[n] != node2) continue;
            nodeBase.setParentNode(this, n);
            System.arraycopy(this.children, n, this.children, n + 1, this.length - n);
            this.children[n] = nodeBase;
            ++this.length;
            this.mutated();
            return node;
        }
        throw new DomEx(8);
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        int n;
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (node == null || node2 == null) {
            throw new DomEx(3);
        }
        if (this.children == null) {
            throw new DomEx(8);
        }
        NodeBase nodeBase = this.checkDocument(node);
        if (node.getNodeType() == 11) {
            this.consumeFragment(node, node2);
            return this.removeChild(node2);
        }
        this.checkNotAncestor(node);
        this.checkChildType(node.getNodeType());
        for (n = 0; n < this.length; ++n) {
            if (this.children[n] != node) continue;
            this.removeChild(node);
            break;
        }
        for (n = 0; n < this.length; ++n) {
            if (this.children[n] != node2) continue;
            nodeBase.setParentNode(this, n);
            this.children[n] = nodeBase;
            ((NodeBase)node2).setParentNode(null, -1);
            this.mutated();
            return node2;
        }
        throw new DomEx(8);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        if ("*".equals(string)) {
            string = null;
        }
        if ("*".equals(string2)) {
            string2 = null;
        }
        return new TagListNS(string, string2);
    }

    class TagList
    implements NodeList {
        protected String tag;
        protected int lastMutationCount;
        protected int lastIndex;
        protected TreeWalker lastWalker;

        protected int getLastMutationCount() {
            XmlDocument xmlDocument = (XmlDocument)ParentNode.this.getOwnerDocument();
            return xmlDocument == null ? 0 : xmlDocument.mutationCount;
        }

        public int getLength() {
            TreeWalker treeWalker = new TreeWalker(ParentNode.this);
            Element element = null;
            int n = 0;
            while ((element = treeWalker.getNextElement(this.tag)) != null) {
                ++n;
            }
            return n;
        }

        public Node item(int n) {
            if (n < 0) {
                return null;
            }
            int n2 = this.getLastMutationCount();
            if (this.lastWalker != null && (n < this.lastIndex || n2 != this.lastMutationCount)) {
                this.lastWalker = null;
            }
            if (this.lastWalker == null) {
                this.lastWalker = new TreeWalker(ParentNode.this);
                this.lastIndex = -1;
                this.lastMutationCount = n2;
            }
            if (n == this.lastIndex) {
                return this.lastWalker.getCurrent();
            }
            Element element = null;
            while (n > this.lastIndex && (element = this.lastWalker.getNextElement(this.tag)) != null) {
                ++this.lastIndex;
            }
            if (element == null) {
                this.lastWalker = null;
            }
            return element;
        }

        TagList(String string) {
            this.tag = string;
        }
    }

    class TagListNS
    extends TagList {
        private String namespaceURI;

        public int getLength() {
            TreeWalker treeWalker = new TreeWalker(ParentNode.this);
            int n = 0;
            while (treeWalker.getNextElement(this.namespaceURI, this.tag) != null) {
                ++n;
            }
            return n;
        }

        public Node item(int n) {
            if (n < 0) {
                return null;
            }
            int n2 = this.getLastMutationCount();
            if (this.lastWalker != null && (n < this.lastIndex || n2 != this.lastMutationCount)) {
                this.lastWalker = null;
            }
            if (this.lastWalker == null) {
                this.lastWalker = new TreeWalker(ParentNode.this);
                this.lastIndex = -1;
                this.lastMutationCount = n2;
            }
            if (n == this.lastIndex) {
                return this.lastWalker.getCurrent();
            }
            Element element = null;
            while (n > this.lastIndex && (element = this.lastWalker.getNextElement(this.namespaceURI, this.tag)) != null) {
                ++this.lastIndex;
            }
            if (element == null) {
                this.lastWalker = null;
            }
            return element;
        }

        TagListNS(String string, String string2) {
            super(string2);
            this.namespaceURI = string;
        }
    }
}

