/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.IOException;
import java.io.Writer;
import org.apache.crimson.tree.DataNode;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlWriteContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextNode
extends DataNode
implements Text {
    public short getNodeType() {
        return 3;
    }

    public TextNode() {
    }

    public void joinNextText() {
        Node node = this.getNextSibling();
        if (node == null || node.getNodeType() != 3) {
            return;
        }
        this.getParentNode().removeChild(node);
        char[] cArray = ((TextNode)node).getText();
        char[] cArray2 = new char[this.data.length + cArray.length];
        System.arraycopy(this.data, 0, cArray2, 0, this.data.length);
        System.arraycopy(cArray, 0, cArray2, this.data.length, cArray.length);
        this.data = cArray2;
    }

    public TextNode(char[] cArray, int n, int n2) {
        super(cArray, n, n2);
    }

    public String getNodeName() {
        return "#text";
    }

    public TextNode(String string) {
        super(string);
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        int n;
        Writer writer = xmlWriteContext.getWriter();
        int n2 = 0;
        if (this.data == null) {
            System.err.println("Null text data??");
            return;
        }
        for (n = 0; n < this.data.length; ++n) {
            char c = this.data[n];
            if (c == '<') {
                writer.write(this.data, n2, n - n2);
                n2 = n + 1;
                writer.write("&lt;");
                continue;
            }
            if (c == '>') {
                writer.write(this.data, n2, n - n2);
                n2 = n + 1;
                writer.write("&gt;");
                continue;
            }
            if (c != '&') continue;
            writer.write(this.data, n2, n - n2);
            n2 = n + 1;
            writer.write("&amp;");
        }
        writer.write(this.data, n2, n - n2);
    }

    public Node cloneNode(boolean bl) {
        TextNode textNode = new TextNode(this.data, 0, this.data.length);
        textNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
        return textNode;
    }

    public Text splitText(int n) throws DOMException {
        TextNode textNode;
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        try {
            textNode = new TextNode(this.data, n, this.data.length - n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new DomEx(1);
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new DomEx(1);
        }
        this.getParentNode().insertBefore(textNode, this.getNextSibling());
        char[] cArray = new char[n];
        System.arraycopy(this.data, 0, cArray, 0, n);
        this.data = cArray;
        return textNode;
    }
}

