/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import org.apache.crimson.tree.AttributeNode;
import org.apache.crimson.tree.AttributeNode1;
import org.apache.crimson.tree.CDataNode;
import org.apache.crimson.tree.CommentNode;
import org.apache.crimson.tree.DOMImplementationImpl;
import org.apache.crimson.tree.Doctype;
import org.apache.crimson.tree.DocumentEx;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.ElementEx;
import org.apache.crimson.tree.ElementFactory;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.ElementNode2;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.PINode;
import org.apache.crimson.tree.ParentNode;
import org.apache.crimson.tree.TextNode;
import org.apache.crimson.tree.TreeWalker;
import org.apache.crimson.tree.XmlDocumentBuilder;
import org.apache.crimson.tree.XmlWriteContext;
import org.apache.crimson.util.MessageCatalog;
import org.apache.crimson.util.XmlNames;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlDocument
extends ParentNode
implements DocumentEx {
    static String eol;
    static final MessageCatalog catalog;
    private Locale locale = Locale.getDefault();
    private String systemId;
    private ElementFactory factory;
    int mutationCount;
    boolean replaceRootElement;
    static /* synthetic */ Class class$org$apache$crimson$tree$XmlDocument$Catalog;

    public final short getNodeType() {
        return 9;
    }

    static {
        String string;
        try {
            string = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException securityException) {
            string = "\n";
        }
        eol = string;
        catalog = new Catalog();
    }

    void checkChildType(int n) throws DOMException {
        switch (n) {
            case 1: 
            case 7: 
            case 8: 
            case 10: {
                return;
            }
        }
        throw new DomEx(3);
    }

    public void write(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
        this.write(outputStreamWriter, "UTF-8");
    }

    public void write(Writer writer) throws IOException {
        String string = null;
        if (writer instanceof OutputStreamWriter) {
            string = XmlDocument.java2std(((OutputStreamWriter)writer).getEncoding());
        }
        this.write(writer, string);
    }

    public final String getNodeName() {
        return "#document";
    }

    public final String getSystemId() {
        return this.systemId;
    }

    public final void setSystemId(String string) {
        this.systemId = string;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
    }

    public final ElementFactory getElementFactory() {
        return this.factory;
    }

    public final void setElementFactory(ElementFactory elementFactory) {
        this.factory = elementFactory;
    }

    TextNode newText(char[] cArray, int n, int n2) throws SAXException {
        TextNode textNode = (TextNode)this.createTextNode(null);
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        textNode.setText(cArray2);
        return textNode;
    }

    public void writeChildrenXml(XmlWriteContext xmlWriteContext) throws IOException {
        int n = this.getLength();
        Writer writer = xmlWriteContext.getWriter();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            ((NodeBase)this.item(i)).writeXml(xmlWriteContext);
            writer.write(eol);
        }
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        String string = null;
        if (writer instanceof OutputStreamWriter) {
            string = XmlDocument.java2std(((OutputStreamWriter)writer).getEncoding());
        }
        writer.write("<?xml version=\"1.0\"");
        if (string != null) {
            writer.write(" encoding=\"");
            writer.write(string);
            writer.write(34);
        }
        writer.write("?>");
        writer.write(eol);
        writer.write(eol);
        this.writeChildrenXml(xmlWriteContext);
    }

    public DOMImplementation getImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public Document getOwnerDoc() {
        return null;
    }

    public DocumentFragment createDocumentFragment() {
        DocFragNode docFragNode = new DocFragNode();
        docFragNode.setOwnerDocument(this);
        return docFragNode;
    }

    public final DocumentType getDoctype() {
        int n = 0;
        Node node;
        while ((node = this.item(n)) != null) {
            if (node instanceof DocumentType) {
                return (DocumentType)node;
            }
            ++n;
        }
        return null;
    }

    public Element getDocumentElement() {
        int n = 0;
        Node node;
        while ((node = this.item(n)) != null) {
            if (node instanceof Element) {
                return (Element)node;
            }
            ++n;
        }
        return null;
    }

    public final void changeNodeOwner(Node node) throws DOMException {
        Object object;
        Element element;
        if (node.getOwnerDocument() == this) {
            return;
        }
        if (!(node instanceof NodeBase)) {
            throw new DomEx(4);
        }
        switch (node.getNodeType()) {
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                throw new DomEx(3);
            }
        }
        if (node instanceof AttributeNode && (element = ((AttributeNode)(object = (AttributeNode)node)).getOwnerElement()) != null && element.getOwnerDocument() != this) {
            throw new DomEx(3);
        }
        NodeBase nodeBase = (NodeBase)node.getParentNode();
        if (nodeBase != null) {
            nodeBase.removeChild(node);
        }
        TreeWalker treeWalker = new TreeWalker(node);
        nodeBase = (NodeBase)treeWalker.getCurrent();
        while (nodeBase != null) {
            nodeBase.setOwnerDocument(this);
            if (nodeBase instanceof Element) {
                object = nodeBase.getAttributes();
                int n = object.getLength();
                for (int i = 0; i < n; ++i) {
                    this.changeNodeOwner(object.item(i));
                }
            }
            nodeBase = (NodeBase)treeWalker.getNext();
        }
    }

    public Node cloneNode(boolean bl) {
        XmlDocument xmlDocument = new XmlDocument();
        xmlDocument.systemId = this.systemId;
        if (bl) {
            Node node;
            int n = 0;
            while ((node = this.item(n)) != null) {
                if (!(node instanceof DocumentType)) {
                    node = node.cloneNode(true);
                    xmlDocument.changeNodeOwner(node);
                    xmlDocument.appendChild(node);
                }
                ++n;
            }
        }
        return xmlDocument;
    }

    public void write(Writer writer, String string) throws IOException {
        writer.write("<?xml version=\"1.0\"");
        if (string != null) {
            writer.write(" encoding=\"");
            writer.write(string);
            writer.write(34);
        }
        writer.write("?>");
        writer.write(eol);
        writer.write(eol);
        this.writeChildrenXml(this.createWriteContext(writer, 0));
        writer.write(eol);
        writer.flush();
    }

    static String java2std(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("ISO8859_")) {
            return "ISO-8859-" + string.substring(8);
        }
        if (string.startsWith("8859_")) {
            return "ISO-8859-" + string.substring(5);
        }
        if ("ASCII7".equalsIgnoreCase(string) || "ASCII".equalsIgnoreCase(string)) {
            return "US-ASCII";
        }
        if ("UTF8".equalsIgnoreCase(string)) {
            return "UTF-8";
        }
        if (string.startsWith("Unicode")) {
            return "UTF-16";
        }
        if ("SJIS".equalsIgnoreCase(string)) {
            return "Shift_JIS";
        }
        if ("JIS".equalsIgnoreCase(string)) {
            return "ISO-2022-JP";
        }
        if ("EUCJIS".equalsIgnoreCase(string)) {
            return "EUC-JP";
        }
        return string;
    }

    public Locale chooseLocale(String[] stringArray) {
        Locale locale = catalog.chooseLocale(stringArray);
        if (locale != null) {
            this.setLocale(locale);
        }
        return locale;
    }

    public final ElementEx createElementEx(String string) throws DOMException {
        ElementNode elementNode;
        if (!XmlNames.isName(string)) {
            throw new DomEx(5);
        }
        if (this.factory != null) {
            elementNode = (ElementNode)this.factory.createElementEx(string);
            elementNode.setTag(string);
        } else {
            elementNode = new ElementNode(string);
        }
        elementNode.setOwnerDocument(this);
        return elementNode;
    }

    public ElementEx getElementExById(String string) {
        ElementEx elementEx;
        if (string == null) {
            throw new IllegalArgumentException(this.getMessage("XD-000"));
        }
        TreeWalker treeWalker = new TreeWalker(this);
        while ((elementEx = (ElementEx)treeWalker.getNextElement(null)) != null) {
            String string2;
            String string3 = elementEx.getIdAttributeName();
            if (string3 == null || !(string2 = elementEx.getAttribute(string3)).equals(string)) continue;
            return elementEx;
        }
        return null;
    }

    public static XmlDocument createXmlDocument(InputStream inputStream, boolean bl) throws IOException, SAXException {
        return XmlDocument.createXmlDocument(new InputSource(inputStream), bl);
    }

    public static XmlDocument createXmlDocument(String string) throws IOException, SAXException {
        return XmlDocument.createXmlDocument(new InputSource(string), false);
    }

    public static XmlDocument createXmlDocument(String string, boolean bl) throws IOException, SAXException {
        return XmlDocument.createXmlDocument(new InputSource(string), bl);
    }

    public static XmlDocument createXmlDocument(InputSource inputSource, boolean bl) throws IOException, SAXException {
        String string;
        String string2 = "org.apache.crimson.parser.XMLReaderImpl";
        try {
            string = System.getProperty("org.xml.sax.driver", string2);
        }
        catch (SecurityException securityException) {
            string = string2;
        }
        XMLReader xMLReader = XMLReaderFactory.createXMLReader(string);
        String string3 = "http://xml.org/sax/features/namespaces";
        xMLReader.setFeature(string3, true);
        String string4 = "http://xml.org/sax/features/namespace-prefixes";
        xMLReader.setFeature(string4, true);
        XmlDocumentBuilder xmlDocumentBuilder = new XmlDocumentBuilder();
        xMLReader.setContentHandler(xmlDocumentBuilder);
        String string5 = "http://xml.org/sax/properties/lexical-handler";
        xMLReader.setProperty(string5, xmlDocumentBuilder);
        String string6 = "http://xml.org/sax/properties/declaration-handler";
        xMLReader.setProperty(string6, xmlDocumentBuilder);
        xMLReader.setDTDHandler(xmlDocumentBuilder);
        String string7 = "http://xml.org/sax/features/validation";
        xMLReader.setFeature(string7, bl);
        if (bl) {
            xMLReader.setErrorHandler(new DefaultHandler(){

                public void error(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }
            });
        }
        xmlDocumentBuilder.setDisableNamespaces(true);
        xMLReader.parse(inputSource);
        return xmlDocumentBuilder.getDocument();
    }

    public XmlWriteContext createWriteContext(Writer writer) {
        return new ExtWriteContext(writer);
    }

    public XmlWriteContext createWriteContext(Writer writer, int n) {
        return new ExtWriteContext(writer, n);
    }

    public Attr createAttribute(String string) throws DOMException {
        if (!XmlNames.isName(string)) {
            throw new DomEx(5);
        }
        AttributeNode1 attributeNode1 = new AttributeNode1(string, "", true, null);
        attributeNode1.setOwnerDocument(this);
        return attributeNode1;
    }

    public CDATASection createCDATASection(String string) {
        CDataNode cDataNode = new CDataNode();
        if (string != null) {
            cDataNode.setText(string.toCharArray());
        }
        cDataNode.setOwnerDocument(this);
        return cDataNode;
    }

    public Comment createComment(String string) {
        CommentNode commentNode = new CommentNode(string);
        commentNode.setOwnerDocument(this);
        return commentNode;
    }

    public Element createElement(String string) throws DOMException {
        return this.createElementEx(string);
    }

    public Element getElementById(String string) {
        return this.getElementExById(string);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        if (!XmlNames.isName(string)) {
            throw new DomEx(5);
        }
        EntityRefNode entityRefNode = new EntityRefNode(string);
        entityRefNode.setOwnerDocument(this);
        return entityRefNode;
    }

    public Node appendChild(Node node) throws DOMException {
        if (node instanceof Element && this.getDocumentElement() != null) {
            throw new DomEx(3);
        }
        if (node instanceof DocumentType && this.getDoctype() != null) {
            throw new DomEx(3);
        }
        return super.appendChild(node);
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        Node node2 = null;
        switch (node.getNodeType()) {
            case 2: {
                node2 = node.cloneNode(true);
                break;
            }
            case 11: {
                if (bl) {
                    node2 = node.cloneNode(true);
                    break;
                }
                node2 = new DocFragNode();
                break;
            }
            case 9: 
            case 10: {
                throw new DomEx(9);
            }
            case 1: {
                node2 = ((ElementNode2)node).createCopyForImportNode(bl);
                break;
            }
            case 6: {
                node2 = node.cloneNode(bl);
                break;
            }
            case 5: {
                node2 = node.cloneNode(false);
                break;
            }
            default: {
                node2 = node.cloneNode(false);
            }
        }
        TreeWalker treeWalker = new TreeWalker(node2);
        NodeBase nodeBase = (NodeBase)treeWalker.getCurrent();
        while (nodeBase != null) {
            nodeBase.setOwnerDocument(this);
            if (nodeBase instanceof Element) {
                NamedNodeMap namedNodeMap = nodeBase.getAttributes();
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    this.changeNodeOwner(namedNodeMap.item(i));
                }
            }
            nodeBase = (NodeBase)treeWalker.getNext();
        }
        return node2;
    }

    public Text createTextNode(String string) {
        TextNode textNode = new TextNode();
        textNode.setOwnerDocument(this);
        if (string != null) {
            textNode.setText(string.toCharArray());
        }
        return textNode;
    }

    public final ElementEx createElementEx(String string, String string2) throws DOMException {
        ElementNode elementNode;
        if (!XmlNames.isName(string2)) {
            throw new DomEx(5);
        }
        if (this.factory != null) {
            elementNode = (ElementNode)this.factory.createElementEx(string, string2);
            elementNode.setTag(string2);
        } else {
            elementNode = new ElementNode(string2);
        }
        elementNode.setOwnerDocument(this);
        return elementNode;
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        AttributeNode.checkArguments(string, string2);
        AttributeNode attributeNode = new AttributeNode(string, string2, "", true, null);
        attributeNode.setOwnerDocument(this);
        return attributeNode;
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        ElementNode2.checkArguments(string, string2);
        ElementNode2 elementNode2 = new ElementNode2(string, string2);
        elementNode2.setOwnerDocument(this);
        return elementNode2;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        if (!this.replaceRootElement && node instanceof Element && this.getDocumentElement() != null) {
            throw new DomEx(3);
        }
        if (!this.replaceRootElement && node instanceof DocumentType && this.getDoctype() != null) {
            throw new DomEx(3);
        }
        return super.insertBefore(node, node2);
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (node instanceof DocumentFragment) {
            Node node3;
            int n = 0;
            int n2 = 0;
            this.replaceRootElement = false;
            ParentNode parentNode = (ParentNode)node;
            int n3 = 0;
            while ((node3 = parentNode.item(n3)) != null) {
                if (node3 instanceof Element) {
                    ++n;
                } else if (node3 instanceof DocumentType) {
                    ++n2;
                }
                ++n3;
            }
            if (n > 1 || n2 > 1) {
                throw new DomEx(3);
            }
            this.replaceRootElement = true;
        }
        return super.replaceChild(node, node2);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if (!XmlNames.isName(string)) {
            throw new DomEx(5);
        }
        PINode pINode = new PINode(string, string2);
        pINode.setOwnerDocument(this);
        return pINode;
    }

    public DocumentType setDoctype(String string, String string2, String string3) {
        Doctype doctype = (Doctype)this.getDoctype();
        if (doctype != null) {
            doctype.setPrintInfo(string, string2, string3);
        } else {
            doctype = new Doctype(string, string2, string3);
            doctype.setOwnerDocument(this);
            this.insertBefore(doctype, this.getFirstChild());
        }
        return doctype;
    }

    static class Catalog
    extends MessageCatalog {
        Catalog() {
            super(class$org$apache$crimson$tree$XmlDocument$Catalog == null ? (class$org$apache$crimson$tree$XmlDocument$Catalog = XmlDocument.class$("org.apache.crimson.tree.XmlDocument$Catalog")) : class$org$apache$crimson$tree$XmlDocument$Catalog);
        }
    }

    static final class DocFragNode
    extends ParentNode
    implements DocumentFragment {
        public short getNodeType() {
            return 11;
        }

        DocFragNode() {
        }

        void checkChildType(int n) throws DOMException {
            switch (n) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    return;
                }
            }
            throw new DomEx(3);
        }

        public String getNodeName() {
            return "#document-fragment";
        }

        public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
            this.writeChildrenXml(xmlWriteContext);
        }

        public Node getParentNode() {
            return null;
        }

        public void setParentNode(Node node) {
            if (node != null) {
                throw new IllegalArgumentException();
            }
        }

        public Node cloneNode(boolean bl) {
            DocFragNode docFragNode = new DocFragNode();
            docFragNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            if (bl) {
                Node node;
                int n = 0;
                while ((node = this.item(n)) != null) {
                    node = node.cloneNode(true);
                    docFragNode.appendChild(node);
                    ++n;
                }
            }
            return docFragNode;
        }
    }

    static final class EntityRefNode
    extends ParentNode
    implements EntityReference {
        private String entity;

        public short getNodeType() {
            return 5;
        }

        void checkChildType(int n) throws DOMException {
            switch (n) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    return;
                }
            }
            throw new DomEx(3);
        }

        public String getNodeName() {
            return this.entity;
        }

        EntityRefNode(String string) {
            if (string == null) {
                throw new IllegalArgumentException(this.getMessage("XD-002"));
            }
            this.entity = string;
        }

        public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
            if (!xmlWriteContext.isEntityDeclared(this.entity)) {
                throw new IOException(this.getMessage("XD-003", new Object[]{this.entity}));
            }
            Writer writer = xmlWriteContext.getWriter();
            writer.write(38);
            writer.write(this.entity);
            writer.write(59);
        }

        public Node cloneNode(boolean bl) {
            EntityRefNode entityRefNode = new EntityRefNode(this.entity);
            entityRefNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            if (bl) {
                Node node;
                int n = 0;
                while ((node = this.item(n)) != null) {
                    node = node.cloneNode(true);
                    entityRefNode.appendChild(node);
                    ++n;
                }
            }
            return entityRefNode;
        }
    }

    class ExtWriteContext
    extends XmlWriteContext {
        public boolean isEntityDeclared(String string) {
            if (super.isEntityDeclared(string)) {
                return true;
            }
            DocumentType documentType = XmlDocument.this.getDoctype();
            if (documentType == null) {
                return false;
            }
            return documentType.getEntities().getNamedItem(string) != null;
        }

        ExtWriteContext(Writer writer) {
            super(writer);
        }

        ExtWriteContext(Writer writer, int n) {
            super(writer, n);
        }
    }
}

