/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.util;

import org.apache.crimson.util.XmlChars;

public class XmlNames {
    public static final String SPEC_XML_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String SPEC_XMLNS_URI = "http://www.w3.org/2000/xmlns/";

    private XmlNames() {
    }

    public static boolean isNCNmtoken(String string) {
        return XmlNames.isNmtoken(string) && string.indexOf(58) < 0;
    }

    public static boolean isName(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        char c = string.charAt(0);
        if (!XmlChars.isLetter(c) && c != '_' && c != ':') {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (XmlChars.isNameChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNmtoken(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (XmlChars.isNameChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isQualifiedName(String string) {
        if (string == null) {
            return false;
        }
        int n = string.indexOf(58);
        if (n <= 0) {
            return XmlNames.isUnqualifiedName(string);
        }
        int n2 = string.lastIndexOf(58);
        if (n2 != n) {
            return false;
        }
        return XmlNames.isUnqualifiedName(string.substring(0, n)) && XmlNames.isUnqualifiedName(string.substring(n + 1));
    }

    public static boolean isUnqualifiedName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!XmlChars.isLetter(c) && c != '_') {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (XmlChars.isNCNameChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getLocalPart(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return string;
        }
        if (n == string.length() - 1) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static String getPrefix(String string) {
        int n = string.indexOf(58);
        return n <= 0 ? null : string.substring(0, n);
    }
}

