/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import sun.misc.ServiceConfigurationError;

public final class Service {
    private static final String prefix = "META-INF/services/";

    private Service() {
    }

    private static void fail(Class clazz, String string) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(clazz.getName() + ": " + string);
    }

    public static Iterator installedProviders(Class clazz) throws ServiceConfigurationError {
        ClassLoader classLoader = null;
        for (ClassLoader classLoader2 = ClassLoader.getSystemClassLoader(); classLoader2 != null; classLoader2 = classLoader2.getParent()) {
            classLoader = classLoader2;
        }
        return Service.providers(clazz, classLoader);
    }

    public static Iterator providers(Class clazz) throws ServiceConfigurationError {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Service.providers(clazz, classLoader);
    }

    private static void fail(Class clazz, URL uRL, int n, String string) throws ServiceConfigurationError {
        Service.fail(clazz, uRL + ":" + n + ": " + string);
    }

    private static void fail(Class clazz, String string, Throwable throwable) throws ServiceConfigurationError {
        ServiceConfigurationError serviceConfigurationError = new ServiceConfigurationError(clazz.getName() + ": " + string);
        serviceConfigurationError.initCause(throwable);
        throw serviceConfigurationError;
    }

    public static Iterator providers(Class clazz, ClassLoader classLoader) throws ServiceConfigurationError {
        return new LazyIterator(clazz, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Iterator parse(Class clazz, URL uRL, Set set) throws ServiceConfigurationError {
        ArrayList arrayList;
        block15: {
            InputStream inputStream = null;
            BufferedReader bufferedReader = null;
            arrayList = new ArrayList();
            inputStream = uRL.openStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            int n = 1;
            while ((n = Service.parseLine(clazz, uRL, bufferedReader, n, arrayList, set)) >= 0) {
            }
            Object var8_8 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                break block15;
            }
            catch (IOException iOException) {
                Service.fail(clazz, ": " + iOException);
            }
            break block15;
            {
                catch (IOException iOException) {
                    Service.fail(clazz, ": " + iOException);
                    Object var8_9 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException2) {
                        Service.fail(clazz, ": " + iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Service.fail(clazz, ": " + iOException);
                }
                throw throwable;
            }
        }
        return arrayList.iterator();
    }

    private static int parseLine(Class clazz, URL uRL, BufferedReader bufferedReader, int n, List list, Set set) throws IOException, ServiceConfigurationError {
        int n2;
        String string = bufferedReader.readLine();
        if (string == null) {
            return -1;
        }
        int n3 = string.indexOf(35);
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        if ((n2 = (string = string.trim()).length()) != 0) {
            if (string.indexOf(32) >= 0 || string.indexOf(9) >= 0) {
                Service.fail(clazz, uRL, n, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                Service.fail(clazz, uRL, n, "Illegal provider-class name: " + string);
            }
            for (int i = 1; i < n2; ++i) {
                char c = string.charAt(i);
                if (Character.isJavaIdentifierPart(c) || c == '.') continue;
                Service.fail(clazz, uRL, n, "Illegal provider-class name: " + string);
            }
            if (!set.contains(string)) {
                list.add(string);
                set.add(string);
            }
        }
        return n + 1;
    }

    private static class LazyIterator
    implements Iterator {
        Class service;
        ClassLoader loader;
        Enumeration configs = null;
        Iterator pending = null;
        Set returned = new TreeSet();
        String nextName = null;

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() throws ServiceConfigurationError {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                try {
                    String string = Service.prefix + this.service.getName();
                    this.configs = this.loader == null ? ClassLoader.getSystemResources(string) : this.loader.getResources(string);
                }
                catch (IOException iOException) {
                    Service.fail(this.service, ": " + iOException);
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.pending = Service.parse(this.service, (URL)this.configs.nextElement(), this.returned);
            }
            this.nextName = (String)this.pending.next();
            return true;
        }

        public Object next() throws ServiceConfigurationError {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String string = this.nextName;
            this.nextName = null;
            try {
                return Class.forName(string, true, this.loader).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                Service.fail(this.service, "Provider " + string + " not found");
            }
            catch (Exception exception) {
                Service.fail(this.service, "Provider " + string + " could not be instantiated: " + exception, exception);
            }
            return null;
        }

        private LazyIterator(Class clazz, ClassLoader classLoader) {
            this.service = clazz;
            this.loader = classLoader;
        }
    }
}

