/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

class Reflect {
    private Reflect() {
    }

    private static void setAccessible(final AccessibleObject accessibleObject) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                accessibleObject.setAccessible(true);
                return null;
            }
        });
    }

    static Object get(Field field) {
        return Reflect.get(null, field);
    }

    static void setInt(Object object, Field field, int n) {
        try {
            field.setInt(object, n);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionError(illegalAccessException);
        }
    }

    static void setBoolean(Object object, Field field, boolean bl) {
        try {
            field.setBoolean(object, bl);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionError(illegalAccessException);
        }
    }

    static Object invoke(Constructor constructor, Object[] objectArray) {
        try {
            return constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectionError(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionError(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectionError(invocationTargetException);
        }
    }

    static Object get(Object object, Field field) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionError(illegalAccessException);
        }
    }

    static void set(Object object, Field field, Object object2) {
        try {
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionError(illegalAccessException);
        }
    }

    static Constructor lookupConstructor(String string, Class[] classArray) {
        try {
            Class clazz = Class.forName(string);
            Constructor constructor = clazz.getDeclaredConstructor(classArray);
            Reflect.setAccessible(constructor);
            return constructor;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionError(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionError(noSuchMethodException);
        }
    }

    static Field lookupField(String string, String string2) {
        try {
            Class clazz = Class.forName(string);
            Field field = clazz.getDeclaredField(string2);
            Reflect.setAccessible(field);
            return field;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionError(classNotFoundException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectionError(noSuchFieldException);
        }
    }

    static Object invoke(Method method, Object object, Object[] objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionError(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectionError(invocationTargetException);
        }
    }

    static Object invokeIO(Method method, Object object, Object[] objectArray) throws IOException {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionError(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (IOException.class.isInstance(invocationTargetException.getCause())) {
                throw (IOException)invocationTargetException.getCause();
            }
            throw new ReflectionError(invocationTargetException);
        }
    }

    static Method lookupMethod(String string, String string2, Class[] classArray) {
        try {
            Class clazz = Class.forName(string);
            Method method = clazz.getDeclaredMethod(string2, classArray);
            Reflect.setAccessible(method);
            return method;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionError(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionError(noSuchMethodException);
        }
    }

    private static class ReflectionError
    extends Error {
        ReflectionError(Throwable throwable) {
            super(throwable);
        }
    }
}

