/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;

abstract class SelectorImpl
extends AbstractSelector {
    protected Set selectedKeys;
    protected HashSet keys;
    private SelectGate selectGate = new SelectGate();

    public int select() throws IOException {
        return this.select(0L);
    }

    public int selectNow() throws IOException {
        return this.lockAndDoSelect(0L);
    }

    protected abstract void implClose() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void implCloseSelector() throws IOException {
        SelectGate selectGate = this.selectGate;
        synchronized (selectGate) {
            this.wakeup();
            HashSet hashSet = this.keys;
            synchronized (hashSet) {
                Set set = this.selectedKeys;
                synchronized (set) {
                    this.implClose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDeregisterQueue() throws IOException {
        Set set;
        Set set2 = set = this.cancelledKeys();
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                SelectionKeyImpl selectionKeyImpl = (SelectionKeyImpl)iterator.next();
                this.implDereg(selectionKeyImpl);
                iterator.remove();
            }
        }
    }

    protected abstract int doSelect(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private int lockAndDoSelect(long l) throws IOException {
        SelectorImpl selectorImpl = this;
        // MONITORENTER : selectorImpl
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        Object object = this.selectGate;
        // MONITORENTER : object
        // MONITOREXIT : object
        object = this.keys;
        // MONITORENTER : object
        Set set = this.selectedKeys;
        // MONITORENTER : set
        // MONITOREXIT : set
        // MONITOREXIT : object
        // MONITOREXIT : selectorImpl
        return this.doSelect(l);
    }

    public int select(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        return this.lockAndDoSelect(l == 0L ? -1L : l);
    }

    public abstract Selector wakeup();

    protected SelectorImpl(SelectorProvider selectorProvider) {
        super(selectorProvider);
        this.selectedKeys = new HashSet();
        this.keys = new HashSet();
    }

    public Set keys() {
        return this.keys;
    }

    public Set selectedKeys() {
        return this.selectedKeys;
    }

    protected abstract void implDereg(SelectionKeyImpl var1) throws IOException;

    protected abstract void implRegister(SelectionKeyImpl var1);

    void putEventOps(SelectionKeyImpl selectionKeyImpl, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SelectionKey register(AbstractSelectableChannel abstractSelectableChannel, int n, Object object) {
        if (!(abstractSelectableChannel instanceof SelChImpl)) {
            throw new IllegalSelectorException();
        }
        SelectionKeyImpl selectionKeyImpl = new SelectionKeyImpl((SelChImpl)((Object)abstractSelectableChannel), this);
        selectionKeyImpl.attach(object);
        HashSet hashSet = this.keys;
        synchronized (hashSet) {
            this.implRegister(selectionKeyImpl);
        }
        selectionKeyImpl.interestOps(n);
        return selectionKeyImpl;
    }

    private static class SelectGate {
        private SelectGate() {
        }
    }
}

