/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public abstract class SingleByteDecoder
extends CharsetDecoder {
    private final String byteToCharTable;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = !SingleByteDecoder.class.desiredAssertionStatus();
    }

    public char decode(int n) {
        int n2 = n + 128;
        if (n2 >= this.byteToCharTable.length() || n2 < 0) {
            return '\ufffd';
        }
        return this.byteToCharTable.charAt(n2);
    }

    protected SingleByteDecoder(Charset charset, String string) {
        super(charset, 1.0f, 1.0f);
        this.byteToCharTable = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        int n;
        int n2;
        block11: {
            CoderResult coderResult2;
            block10: {
                CoderResult coderResult3;
                block9: {
                    CoderResult coderResult4;
                    block8: {
                        byte[] byArray = byteBuffer.array();
                        n2 = byteBuffer.arrayOffset() + byteBuffer.position();
                        int n3 = byteBuffer.arrayOffset() + byteBuffer.limit();
                        if (!$assertionsDisabled && n2 > n3) {
                            throw new AssertionError();
                        }
                        char[] cArray = charBuffer.array();
                        n = charBuffer.arrayOffset() + charBuffer.position();
                        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
                        if (!$assertionsDisabled && n > n4) {
                            throw new AssertionError();
                        }
                        n = n <= n4 ? n : n4;
                        try {
                            for (n2 = n2 <= n3 ? n2 : n3; n2 < n3; ++n2) {
                                byte by = byArray[n2];
                                int n5 = by + 128;
                                if (n5 >= this.byteToCharTable.length() || n5 < 0) {
                                    coderResult4 = CoderResult.malformedForLength(1);
                                    Object var14_14 = null;
                                    break block8;
                                }
                                char c = this.byteToCharTable.charAt(n5);
                                if (c == '\ufffd') {
                                    coderResult3 = CoderResult.malformedForLength(1);
                                    break block9;
                                }
                                if (n4 - n < 1) {
                                    coderResult2 = CoderResult.OVERFLOW;
                                    break block10;
                                }
                                cArray[n++] = c;
                            }
                            coderResult = CoderResult.UNDERFLOW;
                            break block11;
                        }
                        catch (Throwable throwable) {
                            Object var14_18 = null;
                            byteBuffer.position(n2 - byteBuffer.arrayOffset());
                            charBuffer.position(n - charBuffer.arrayOffset());
                            throw throwable;
                        }
                    }
                    byteBuffer.position(n2 - byteBuffer.arrayOffset());
                    charBuffer.position(n - charBuffer.arrayOffset());
                    return coderResult4;
                }
                Object var14_15 = null;
                byteBuffer.position(n2 - byteBuffer.arrayOffset());
                charBuffer.position(n - charBuffer.arrayOffset());
                return coderResult3;
            }
            Object var14_16 = null;
            byteBuffer.position(n2 - byteBuffer.arrayOffset());
            charBuffer.position(n - charBuffer.arrayOffset());
            return coderResult2;
        }
        Object var14_17 = null;
        byteBuffer.position(n2 - byteBuffer.arrayOffset());
        charBuffer.position(n - charBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        try {
            while (byteBuffer.hasRemaining()) {
                byte by = byteBuffer.get();
                int n2 = by + 128;
                if (n2 >= this.byteToCharTable.length() || n2 < 0) {
                    CoderResult coderResult = CoderResult.malformedForLength(1);
                    return coderResult;
                }
                char c = this.byteToCharTable.charAt(n2);
                if (c == '\ufffd') {
                    CoderResult coderResult = CoderResult.malformedForLength(1);
                    return coderResult;
                }
                if (!charBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                ++n;
                charBuffer.put(c);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

