/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.math.BigInteger;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class Debug {
    private String prefix;
    private static String args = (String)AccessController.doPrivileged(new GetPropertyAction("java.security.debug"));

    static {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.security.auth.debug"));
        if (args == null) {
            args = string;
        } else if (string != null) {
            args = args + "," + string;
        }
        if (args != null && (args = args.toLowerCase()).equals("help")) {
            Debug.Help();
        }
    }

    public static void Help() {
        System.err.println();
        System.err.println("all           turn on all debugging");
        System.err.println("access        print all checkPermission results");
        System.err.println("combiner      SubjectDomainCombiner debugging");
        System.err.println("jar           jar verification");
        System.err.println("logincontext  login context results");
        System.err.println("policy        loading and granting");
        System.err.println("provider      security provider debugging");
        System.err.println("scl           permissions SecureClassLoader assigns");
        System.err.println();
        System.err.println("The following can be used with access:");
        System.err.println();
        System.err.println("stack     include stack trace");
        System.err.println("domain    dumps all domains in context");
        System.err.println("failure   before throwing exception, dump stack");
        System.err.println("          and domain that didn't have permission");
        System.err.println();
        System.err.println("Note: Separate multiple options with a comma");
        System.exit(0);
    }

    public void println() {
        System.err.println(this.prefix + ":");
    }

    public void println(String string) {
        System.err.println(this.prefix + ": " + string);
    }

    public static boolean isOn(String string) {
        if (args == null) {
            return false;
        }
        if (args.indexOf("all") != -1) {
            return true;
        }
        return args.indexOf(string) != -1;
    }

    public static void println(String string, String string2) {
        System.err.println(string + ": " + string2);
    }

    public static String toHexString(BigInteger bigInteger) {
        String string = bigInteger.toString(16);
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        if (string.startsWith("-")) {
            stringBuffer.append("   -");
            string = string.substring(1);
        } else {
            stringBuffer.append("    ");
        }
        if (string.length() % 2 != 0) {
            string = "0" + string;
        }
        int n = 0;
        while (n < string.length()) {
            stringBuffer.append(string.substring(n, n + 2));
            if ((n += 2) == string.length()) continue;
            if (n % 64 == 0) {
                stringBuffer.append("\n    ");
                continue;
            }
            if (n % 8 != 0) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static Debug getInstance(String string) {
        return Debug.getInstance(string, string);
    }

    public static Debug getInstance(String string, String string2) {
        if (Debug.isOn(string)) {
            Debug debug = new Debug();
            debug.prefix = string2;
            return debug;
        }
        return null;
    }
}

