/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Locale;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.util.Debug;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AVAKeyword;
import sun.security.x509.X500Name;
import sun.text.Normalizer;

public class AVA
implements DerEncoder {
    private static final Debug debug = Debug.getInstance("x509", "\t[AVA]");
    static final int DEFAULT = 1;
    static final int RFC1779 = 2;
    static final int RFC2253 = 3;
    final ObjectIdentifier oid;
    final DerValue value;
    private static final String specialChars = ",+=\n<>#;";
    private static final String specialChars2253 = ",+\"\\<>;";
    private static final String specialCharsAll = ",=\n+<>#;\\\" ";
    private static final String hexDigits = "0123456789ABCDEF";

    public int hashCode() {
        return this.toRFC2253CanonicalString().hashCode();
    }

    boolean hasRFC2253Keyword() {
        return AVAKeyword.hasKeyword(this.oid, 3);
    }

    private static boolean isTerminator(int n, int n2) {
        switch (n) {
            case -1: 
            case 43: 
            case 44: {
                return true;
            }
            case 59: 
            case 62: {
                return n2 != 3;
            }
        }
        return false;
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.oid);
        this.value.encode(derOutputStream);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    AVA(Reader reader) throws IOException {
        this(reader, 1);
    }

    private static boolean trailingSpace(Reader reader) throws IOException {
        boolean bl;
        block3: {
            block4: {
                bl = false;
                if (!reader.markSupported()) {
                    return true;
                }
                reader.mark(9999);
                while (true) {
                    int n;
                    if ((n = reader.read()) == -1) {
                        bl = true;
                        break block3;
                    }
                    if (n == 32) continue;
                    if (n != 92) break block4;
                    int n2 = reader.read();
                    if (n2 != 32) break;
                }
                bl = false;
                break block3;
            }
            bl = false;
        }
        reader.reset();
        return bl;
    }

    AVA(Reader reader, int n) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = AVA.readChar(reader, "Incorrect AVA format")) != 61) {
            stringBuffer.append((char)n2);
        }
        this.oid = AVAKeyword.getOID(stringBuffer.toString(), n);
        stringBuffer.setLength(0);
        if (n == 3) {
            n2 = reader.read();
            if (n2 == 32) {
                throw new IOException("Incorrect AVA RFC2253 format - leading space must be escaped");
            }
        } else {
            while ((n2 = reader.read()) == 32 || n2 == 10) {
            }
        }
        if (n2 == -1) {
            this.value = new DerValue("");
            return;
        }
        this.value = n2 == 35 ? AVA.parseHexString(reader, n) : (n2 == 34 && n != 3 ? this.parseQuotedString(reader, stringBuffer) : this.parseString(reader, n2, n, stringBuffer));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AVA)) {
            return false;
        }
        AVA aVA = (AVA)object;
        return this.toRFC2253CanonicalString().equals(aVA.toRFC2253CanonicalString());
    }

    public String getValueString() {
        try {
            String string = this.value.getAsString();
            if (string == null) {
                throw new RuntimeException("AVA string is null");
            }
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeException("AVA error: " + iOException, iOException);
        }
    }

    public String toRFC1779String() {
        return this.toKeywordValueString(this.toKeyword(2));
    }

    public String toRFC2253CanonicalString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(this.toKeyword(3));
        stringBuffer.append('=');
        if (stringBuffer.charAt(0) >= '0' && stringBuffer.charAt(0) <= '9' || !AVA.isDerString(this.value, true)) {
            object = null;
            try {
                object = this.value.toByteArray();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            stringBuffer.append('#');
            for (int i = 0; i < ((byte[])object).length; ++i) {
                byte by = object[i];
                stringBuffer.append(Character.forDigit(0xF & by >>> 4, 16));
                stringBuffer.append(Character.forDigit(0xF & by, 16));
            }
        } else {
            object = null;
            try {
                object = new String(this.value.getDataBytes(), "UTF8");
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            boolean bl = false;
            for (int i = 0; i < ((String)object).length(); ++i) {
                char c = ((String)object).charAt(i);
                if (DerValue.isPrintableStringChar(c) || ",+<>;\"\\".indexOf(c) >= 0 || i == 0 && c == '#') {
                    if (i == 0 && c == '#' || ",+<>;\"\\".indexOf(c) >= 0) {
                        stringBuffer2.append('\\');
                    }
                    if (!Character.isWhitespace(c)) {
                        bl = false;
                        stringBuffer2.append(c);
                        continue;
                    }
                    if (bl) continue;
                    bl = true;
                    stringBuffer2.append(c);
                    continue;
                }
                if (debug != null && Debug.isOn("ava")) {
                    bl = false;
                    byte[] byArray = null;
                    try {
                        byArray = Character.toString(c).getBytes("UTF8");
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException("DER Value conversion");
                    }
                    for (int j = 0; j < byArray.length; ++j) {
                        stringBuffer2.append('\\');
                        stringBuffer2.append(Character.forDigit(0xF & byArray[j] >>> 4, 16));
                        stringBuffer2.append(Character.forDigit(0xF & byArray[j], 16));
                    }
                    continue;
                }
                bl = false;
                stringBuffer2.append(c);
            }
            stringBuffer.append(stringBuffer2.toString().trim());
        }
        object = new String(stringBuffer);
        object = ((String)object).toUpperCase(Locale.US).toLowerCase(Locale.US);
        return Normalizer.normalize((String)object, Normalizer.DECOMP_COMPAT, 0);
    }

    public String toRFC2253String() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.toKeyword(3));
        stringBuffer.append('=');
        if (stringBuffer.charAt(0) >= '0' && stringBuffer.charAt(0) <= '9' || !AVA.isDerString(this.value, false)) {
            byte[] byArray = null;
            try {
                byArray = this.value.toByteArray();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            stringBuffer.append('#');
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                stringBuffer.append(Character.forDigit(0xF & by >>> 4, 16));
                stringBuffer.append(Character.forDigit(0xF & by, 16));
            }
        } else {
            int n;
            char c;
            int n2;
            int n3;
            String string = null;
            try {
                string = new String(this.value.getDataBytes(), "UTF8");
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                n3 = string.charAt(i);
                if (DerValue.isPrintableStringChar((char)n3) || ",=+<>#;\"\\".indexOf(n3) >= 0) {
                    if (",=+<>#;\"\\".indexOf(n3) >= 0) {
                        stringBuffer2.append('\\');
                    }
                    stringBuffer2.append((char)n3);
                    continue;
                }
                if (debug != null && Debug.isOn("ava")) {
                    byte[] byArray = null;
                    try {
                        byArray = Character.toString((char)n3).getBytes("UTF8");
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException("DER Value conversion");
                    }
                    for (n2 = 0; n2 < byArray.length; ++n2) {
                        stringBuffer2.append('\\');
                        c = Character.forDigit(0xF & byArray[n2] >>> 4, 16);
                        stringBuffer2.append(Character.toUpperCase(c));
                        c = Character.forDigit(0xF & byArray[n2], 16);
                        stringBuffer2.append(Character.toUpperCase(c));
                    }
                    continue;
                }
                stringBuffer2.append((char)n3);
            }
            char[] cArray = stringBuffer2.toString().toCharArray();
            stringBuffer2 = new StringBuffer();
            for (n3 = '\u0000'; n3 < cArray.length && (cArray[n3] == ' ' || cArray[n3] == '\r'); ++n3) {
            }
            for (n = cArray.length - 1; n >= 0 && (cArray[n] == ' ' || cArray[n] == '\r'); --n) {
            }
            for (n2 = 0; n2 < cArray.length; ++n2) {
                c = cArray[n2];
                if (n2 < n3 || n2 > n) {
                    stringBuffer2.append('\\');
                }
                stringBuffer2.append(c);
            }
            stringBuffer.append(stringBuffer2.toString());
        }
        return new String(stringBuffer);
    }

    public String toString() {
        return this.toKeywordValueString(this.toKeyword(1));
    }

    private String toKeyword(int n) {
        return AVAKeyword.getKeyword(this.oid, n);
    }

    AVA(DerInputStream derInputStream) throws IOException {
        this(derInputStream.getDerValue());
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        this.derEncode(derOutputStream);
    }

    public DerValue getDerValue() {
        return this.value;
    }

    AVA(DerValue derValue) throws IOException {
        if (derValue.tag != 48) {
            throw new IOException("AVA not a sequence");
        }
        this.oid = X500Name.intern(derValue.data.getOID());
        this.value = derValue.data.getDerValue();
        if (derValue.data.available() != 0) {
            throw new IOException("AVA, extra bytes = " + derValue.data.available());
        }
    }

    private static boolean isDerString(DerValue derValue, boolean bl) {
        if (bl) {
            switch (derValue.tag) {
                case 12: 
                case 19: {
                    return true;
                }
            }
            return false;
        }
        switch (derValue.tag) {
            case 12: 
            case 19: 
            case 20: 
            case 22: 
            case 27: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    public ObjectIdentifier getObjectIdentifier() {
        return this.oid;
    }

    private static Byte getEmbeddedHexPair(int n, Reader reader) throws IOException {
        if (hexDigits.indexOf(Character.toUpperCase((char)n)) >= 0) {
            int n2 = AVA.readChar(reader, "unexpected EOF - escaped hex value must include two valid digits");
            if (hexDigits.indexOf(Character.toUpperCase((char)n2)) >= 0) {
                int n3 = Character.digit((char)n, 16);
                int n4 = Character.digit((char)n2, 16);
                return new Byte((byte)((n3 << 4) + n4));
            }
            throw new IOException("escaped hex value must include two valid digits");
        }
        return null;
    }

    private static int readChar(Reader reader, String string) throws IOException {
        int n = reader.read();
        if (n == -1) {
            throw new IOException(string);
        }
        return n;
    }

    private String toKeywordValueString(String string) {
        StringBuffer stringBuffer;
        block16: {
            stringBuffer = new StringBuffer(40);
            stringBuffer.append(string);
            stringBuffer.append("=");
            try {
                int n;
                String string2 = this.value.getAsString();
                if (string2 == null) {
                    byte[] byArray = this.value.toByteArray();
                    stringBuffer.append('#');
                    for (int i = 0; i < byArray.length; ++i) {
                        stringBuffer.append(hexDigits.charAt(byArray[i] >> 4 & 0xF));
                        stringBuffer.append(hexDigits.charAt(byArray[i] & 0xF));
                    }
                    break block16;
                }
                boolean bl = false;
                StringBuffer stringBuffer2 = new StringBuffer();
                boolean bl2 = false;
                for (n = 0; n < string2.length(); ++n) {
                    char c = string2.charAt(n);
                    if (DerValue.isPrintableStringChar(c) || specialChars.indexOf(c) >= 0) {
                        if (!(bl || (n != 0 || c != ' ' && c != '\n') && specialChars.indexOf(c) < 0)) {
                            bl = true;
                        }
                        if (c != ' ' && c != '\n') {
                            if (c == '\"' || c == '\\') {
                                stringBuffer2.append('\\');
                            }
                            bl2 = false;
                        } else {
                            if (!bl && bl2) {
                                bl = true;
                            }
                            bl2 = true;
                        }
                        stringBuffer2.append(c);
                        continue;
                    }
                    if (debug != null && Debug.isOn("ava")) {
                        bl2 = false;
                        byte[] byArray = Character.toString(c).getBytes("UTF8");
                        for (int i = 0; i < byArray.length; ++i) {
                            stringBuffer2.append('\\');
                            char c2 = Character.forDigit(0xF & byArray[i] >>> 4, 16);
                            stringBuffer2.append(Character.toUpperCase(c2));
                            c2 = Character.forDigit(0xF & byArray[i], 16);
                            stringBuffer2.append(Character.toUpperCase(c2));
                        }
                        continue;
                    }
                    bl2 = false;
                    stringBuffer2.append(c);
                }
                if (stringBuffer2.length() > 0 && ((n = (int)stringBuffer2.charAt(stringBuffer2.length() - 1)) == 32 || n == 10)) {
                    bl = true;
                }
                if (bl) {
                    stringBuffer.append("\"" + stringBuffer2.toString() + "\"");
                } else {
                    stringBuffer.append(stringBuffer2.toString());
                }
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
        }
        return stringBuffer.toString();
    }

    private static String getEmbeddedHexString(ArrayList arrayList) throws IOException {
        byte[] byArray = new byte[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            byArray[i] = (Byte)arrayList.get(i);
        }
        return new String(byArray, "UTF8");
    }

    private static DerValue parseHexString(Reader reader, int n) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        int n4 = 0;
        while (!AVA.isTerminator(n2 = reader.read(), n)) {
            int n5 = hexDigits.indexOf(Character.toUpperCase((char)n2));
            if (n5 == -1) {
                throw new IOException("AVA parse, invalid hex digit: " + (char)n2);
            }
            if (n4 % 2 == 1) {
                n3 = (byte)(n3 * 16 + (byte)n5);
                byteArrayOutputStream.write(n3);
            } else {
                n3 = (byte)n5;
            }
            ++n4;
        }
        if (n4 == 0) {
            throw new IOException("AVA parse, zero hex digits");
        }
        if (n4 % 2 == 1) {
            throw new IOException("AVA parse, odd number of hex digits");
        }
        return new DerValue(byteArrayOutputStream.toByteArray());
    }

    public AVA(ObjectIdentifier objectIdentifier, DerValue derValue) {
        if (objectIdentifier == null || derValue == null) {
            throw new NullPointerException();
        }
        this.oid = objectIdentifier;
        this.value = derValue;
    }

    private DerValue parseString(Reader reader, int n, int n2, StringBuffer stringBuffer) throws IOException {
        ArrayList arrayList = new ArrayList();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        int n3 = 0;
        do {
            bl2 = false;
            if (n == 92) {
                bl2 = true;
                n = AVA.readChar(reader, "Invalid trailing backslash");
                Byte by = null;
                by = AVA.getEmbeddedHexPair(n, reader);
                if (by != null) {
                    bl = false;
                    arrayList.add(by);
                    n = reader.read();
                    bl3 = false;
                    continue;
                }
                if (n2 == 1 && specialCharsAll.indexOf((char)n) == -1 || n2 == 2 && specialChars.indexOf((char)n) == -1 && n != 92 && n != 34) {
                    throw new IOException("Invalid escaped character in AVA: '" + (char)n + "'");
                }
                if (n2 == 3) {
                    if (n == 32) {
                        if (!bl3 && !AVA.trailingSpace(reader)) {
                            throw new IOException("Invalid escaped space character in AVA.  Only a leading or trailing space character can be escaped.");
                        }
                    } else if (n == 35) {
                        if (!bl3) {
                            throw new IOException("Invalid escaped '#' character in AVA.  Only a leading '#' can be escaped.");
                        }
                    } else if (specialChars2253.indexOf((char)n) == -1) {
                        throw new IOException("Invalid escaped character in AVA: '" + (char)n + "'");
                    }
                }
            } else if (n2 == 3 && specialChars2253.indexOf((char)n) != -1) {
                throw new IOException("Character '" + (char)n + "' in AVA appears without escape");
            }
            if (arrayList.size() > 0) {
                for (int i = 0; i < n3; ++i) {
                    stringBuffer.append(" ");
                }
                n3 = 0;
                String string = AVA.getEmbeddedHexString(arrayList);
                stringBuffer.append(string);
                arrayList.clear();
            }
            bl &= DerValue.isPrintableStringChar((char)n);
            if (n == 32 && !bl2) {
                ++n3;
            } else {
                for (int i = 0; i < n3; ++i) {
                    stringBuffer.append(" ");
                }
                n3 = 0;
                stringBuffer.append((char)n);
            }
            n = reader.read();
            bl3 = false;
        } while (!AVA.isTerminator(n, n2));
        if (n2 == 3 && n3 > 0) {
            throw new IOException("Incorrect AVA RFC2253 format - trailing space must be escaped");
        }
        if (arrayList.size() > 0) {
            String string = AVA.getEmbeddedHexString(arrayList);
            stringBuffer.append(string);
            arrayList.clear();
        }
        if (this.oid.equals(PKCS9Attribute.EMAIL_ADDRESS_OID)) {
            return new DerValue(22, stringBuffer.toString());
        }
        if (bl) {
            return new DerValue(stringBuffer.toString());
        }
        return new DerValue(12, stringBuffer.toString());
    }

    private DerValue parseQuotedString(Reader reader, StringBuffer stringBuffer) throws IOException {
        Object object;
        int n = AVA.readChar(reader, "Quoted string did not end in quote");
        ArrayList arrayList = new ArrayList();
        boolean bl = true;
        while (n != 34) {
            if (n == 92) {
                n = AVA.readChar(reader, "Quoted string did not end in quote");
                object = null;
                object = AVA.getEmbeddedHexPair(n, reader);
                if (object != null) {
                    bl = false;
                    arrayList.add(object);
                    n = reader.read();
                    continue;
                }
                if (n != 92 && n != 34 && specialChars.indexOf((char)n) < 0) {
                    throw new IOException("Invalid escaped character in AVA: " + (char)n);
                }
            }
            if (arrayList.size() > 0) {
                object = AVA.getEmbeddedHexString(arrayList);
                stringBuffer.append((String)object);
                arrayList.clear();
            }
            bl &= DerValue.isPrintableStringChar((char)n);
            stringBuffer.append((char)n);
            n = AVA.readChar(reader, "Quoted string did not end in quote");
        }
        if (arrayList.size() > 0) {
            object = AVA.getEmbeddedHexString(arrayList);
            stringBuffer.append((String)object);
            arrayList.clear();
        }
        while ((n = reader.read()) == 10 || n == 32) {
        }
        if (n != -1) {
            throw new IOException("AVA had characters other than whitespace after terminating quote");
        }
        if (this.oid.equals(PKCS9Attribute.EMAIL_ADDRESS_OID)) {
            return new DerValue(22, stringBuffer.toString().trim());
        }
        if (bl) {
            return new DerValue(stringBuffer.toString().trim());
        }
        return new DerValue(12, stringBuffer.toString().trim());
    }
}

