/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.DistributionPoint;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public class CRLDistributionPointsExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.CRLDistributionPoints";
    public static final String NAME = "CRLDistributionPoints";
    public static final String POINTS = "points";
    private List distributionPoints;

    private void encodeThis() throws IOException {
        if (this.distributionPoints.isEmpty()) {
            this.extensionValue = null;
        } else {
            DerOutputStream derOutputStream = new DerOutputStream();
            Object object = this.distributionPoints.iterator();
            while (object.hasNext()) {
                DistributionPoint distributionPoint = (DistributionPoint)object.next();
                distributionPoint.encode(derOutputStream);
            }
            object = new DerOutputStream();
            ((DerOutputStream)object).write((byte)48, derOutputStream);
            this.extensionValue = ((ByteArrayOutputStream)object).toByteArray();
        }
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        return super.toString() + "CRLDistributionPoints [\n  " + this.distributionPoints + "]\n";
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(POINTS)) {
            throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:CRLDistributionPointsExtension.");
        }
        this.distributionPoints = new ArrayList();
        this.encodeThis();
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(POINTS);
        return attributeNameEnumeration.elements();
    }

    public CRLDistributionPointsExtension(List list) throws IOException {
        this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
        this.critical = false;
        this.distributionPoints = list;
        this.encodeThis();
    }

    public CRLDistributionPointsExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
        this.critical = bl;
        if (!(object instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        this.extensionValue = (byte[])object;
        DerValue derValue = new DerValue(this.extensionValue);
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding for CRLDistributionPointsExtension.");
        }
        this.distributionPoints = new ArrayList();
        while (derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            DistributionPoint distributionPoint = new DistributionPoint(derValue2);
            this.distributionPoints.add(distributionPoint);
        }
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(POINTS)) {
            return this.distributionPoints;
        }
        throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:CRLDistributionPointsExtension.");
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(POINTS)) {
            if (!(object instanceof List)) {
                throw new IOException("Attribute value should be of type List.");
            }
        } else {
            throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:CRLDistributionPointsExtension.");
        }
        this.distributionPoints = (List)object;
        this.encodeThis();
    }
}

