/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.X500Name;

public class CertificateIssuerName
implements CertAttrSet {
    public static final String IDENT = "x509.info.issuer";
    public static final String NAME = "issuer";
    public static final String DN_NAME = "dname";
    public static final String DN_PRINCIPAL = "x500principal";
    private X500Name dnName;
    private X500Principal dnPrincipal;

    public CertificateIssuerName(InputStream inputStream) throws IOException {
        DerValue derValue = new DerValue(inputStream);
        this.dnName = new X500Name(derValue);
    }

    public void decode(InputStream inputStream) throws IOException {
        DerValue derValue = new DerValue(inputStream);
        this.dnName = new X500Name(derValue);
        this.dnPrincipal = null;
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.dnName.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        if (this.dnName == null) {
            return "";
        }
        return this.dnName.toString();
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(DN_NAME)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateIssuerName.");
        }
        this.dnName = null;
        this.dnPrincipal = null;
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(DN_NAME);
        return attributeNameEnumeration.elements();
    }

    public CertificateIssuerName(DerInputStream derInputStream) throws IOException {
        this.dnName = new X500Name(derInputStream);
    }

    public CertificateIssuerName(X500Name x500Name) {
        this.dnName = x500Name;
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(DN_NAME)) {
            return this.dnName;
        }
        if (string.equalsIgnoreCase(DN_PRINCIPAL)) {
            if (this.dnPrincipal == null && this.dnName != null) {
                this.dnPrincipal = this.dnName.asX500Principal();
            }
            return this.dnPrincipal;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificateIssuerName.");
    }

    public void set(String string, Object object) throws IOException {
        if (!(object instanceof X500Name)) {
            throw new IOException("Attribute must be of type X500Name.");
        }
        if (!string.equalsIgnoreCase(DN_NAME)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateIssuerName.");
        }
        this.dnName = (X500Name)object;
        this.dnPrincipal = null;
    }
}

