/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNameInterface;

public class DNSName
implements GeneralNameInterface {
    private String name;
    private static final String alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String digitsAndHyphen = "0123456789-";
    private static final String alphaDigitsAndHyphen = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-";

    public int getType() {
        return 2;
    }

    public int hashCode() {
        return this.name.toUpperCase().hashCode();
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        String string = this.name;
        int n = 1;
        while (string.lastIndexOf(46) >= 0) {
            string = string.substring(0, string.lastIndexOf(46));
            ++n;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DNSName)) {
            return false;
        }
        DNSName dNSName = (DNSName)object;
        return this.name.equalsIgnoreCase(dNSName.name);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "DNSName: " + this.name;
    }

    public DNSName(String string) throws IOException {
        if (string == null || string.length() == 0) {
            throw new IOException("DNS name must not be null");
        }
        if (string.indexOf(32) != -1) {
            throw new IOException("DNS names or NameConstraints with blank components are not permitted");
        }
        if (string.charAt(0) == '.' || string.charAt(string.length() - 1) == '.') {
            throw new IOException("DNS names or NameConstraints may not begin or end with a .");
        }
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(46, n);
            if (n2 < 0) {
                n2 = string.length();
            }
            if (n2 - n < 1) {
                throw new IOException("DNSName SubjectAltNames with empty components are not permitted");
            }
            if (alpha.indexOf(string.charAt(n)) < 0) {
                throw new IOException("DNSName components must begin with a letter");
            }
            for (int i = n + 1; i < n2; ++i) {
                char c = string.charAt(i);
                if (alphaDigitsAndHyphen.indexOf(c) >= 0) continue;
                throw new IOException("DNSName components must consist of letters, digits, and hyphens");
            }
            n = n2 + 1;
        }
        this.name = string;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putIA5String(this.name);
    }

    public DNSName(DerValue derValue) throws IOException {
        this.name = derValue.getIA5String();
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n;
        int n2;
        String string;
        String string2;
        int n3 = generalNameInterface == null ? -1 : (generalNameInterface.getType() != 2 ? -1 : ((string2 = ((DNSName)generalNameInterface).getName().toLowerCase()).equals(string = this.name.toLowerCase()) ? 0 : (string.endsWith(string2) ? (string.charAt((n2 = string.lastIndexOf(string2)) - 1) == '.' ? 2 : 3) : (string2.endsWith(string) ? (string2.charAt((n = string2.lastIndexOf(string)) - 1) == '.' ? 1 : 3) : 3))));
        return n3;
    }
}

