/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.Arrays;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class Extension {
    protected ObjectIdentifier extensionId = null;
    protected boolean critical = false;
    protected byte[] extensionValue = null;
    private static final int hashMagic = 31;

    public int hashCode() {
        int n = 0;
        if (this.extensionValue != null) {
            byte[] byArray = this.extensionValue;
            int n2 = byArray.length;
            while (n2 > 0) {
                n += n2-- * byArray[n2];
            }
        }
        n = n * 31 + this.extensionId.hashCode();
        n = n * 31 + (this.critical ? 1231 : 1237);
        return n;
    }

    public Extension() {
    }

    public boolean isCritical() {
        return this.critical;
    }

    public byte[] getExtensionValue() {
        if (this.extensionValue == null) {
            return null;
        }
        byte[] byArray = new byte[this.extensionValue.length];
        System.arraycopy(this.extensionValue, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Extension)) {
            return false;
        }
        Extension extension = (Extension)object;
        if (this.critical != extension.critical) {
            return false;
        }
        if (!this.extensionId.equals(extension.extensionId)) {
            return false;
        }
        return Arrays.equals(this.extensionValue, extension.extensionValue);
    }

    public String toString() {
        String string = "ObjectId: " + this.extensionId.toString();
        string = this.critical ? string + " Criticality=true\n" : string + " Criticality=false\n";
        return string;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (this.extensionId == null) {
            throw new IOException("Null OID to encode for the extension!");
        }
        if (this.extensionValue == null) {
            throw new IOException("No value to encode for the extension!");
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.extensionId);
        if (this.critical) {
            derOutputStream2.putBoolean(this.critical);
        }
        derOutputStream2.putOctetString(this.extensionValue);
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public Extension(DerValue derValue) throws IOException {
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.extensionId = derInputStream.getOID();
        DerValue derValue2 = derInputStream.getDerValue();
        if (derValue2.tag == 1) {
            this.critical = derValue2.getBoolean();
            derValue2 = derInputStream.getDerValue();
            this.extensionValue = derValue2.getOctetString();
        } else {
            this.critical = false;
            this.extensionValue = derValue2.getOctetString();
        }
    }

    public ObjectIdentifier getExtensionId() {
        return this.extensionId;
    }

    public Extension(ObjectIdentifier objectIdentifier, boolean bl, byte[] byArray) throws IOException {
        this.extensionId = objectIdentifier;
        this.critical = bl;
        DerValue derValue = new DerValue(byArray);
        this.extensionValue = derValue.getOctetString();
    }

    public Extension(Extension extension) {
        this.extensionId = extension.extensionId;
        this.critical = extension.critical;
        this.extensionValue = extension.extensionValue;
    }
}

