/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class SerialNumber {
    private BigInteger serialNum;

    public SerialNumber(int n) {
        this.serialNum = BigInteger.valueOf(n);
    }

    public SerialNumber(InputStream inputStream) throws IOException {
        DerValue derValue = new DerValue(inputStream);
        this.construct(derValue);
    }

    public String toString() {
        return "SerialNumber: [" + Debug.toHexString(this.serialNum) + "]";
    }

    public BigInteger getNumber() {
        return this.serialNum;
    }

    public SerialNumber(BigInteger bigInteger) {
        this.serialNum = bigInteger;
    }

    public SerialNumber(DerInputStream derInputStream) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        this.construct(derValue);
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putInteger(this.serialNum);
    }

    public SerialNumber(DerValue derValue) throws IOException {
        this.construct(derValue);
    }

    private void construct(DerValue derValue) throws IOException {
        this.serialNum = derValue.getBigInteger();
        if (derValue.data.available() != 0) {
            throw new IOException("Excess SerialNumber data");
        }
    }
}

