/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import sun.misc.HexDumpEncoder;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public class X509Key
implements PublicKey {
    private static final long serialVersionUID = -5359250853002055002L;
    protected AlgorithmId algid;
    protected byte[] key = null;
    private int unusedBits = 0;
    private BitArray bitStringKey = null;
    protected byte[] encodedKey;

    public int hashCode() {
        try {
            byte[] byArray = this.getEncodedInternal();
            int n = byArray.length;
            for (int i = 0; i < byArray.length; ++i) {
                n += (byArray[i] & 0xFF) * 37;
            }
            return n;
        }
        catch (InvalidKeyException invalidKeyException) {
            return 0;
        }
    }

    public X509Key() {
    }

    protected void parseKeyBits() throws IOException, InvalidKeyException {
        this.encode();
    }

    public byte[] encode() throws InvalidKeyException {
        return (byte[])this.getEncodedInternal().clone();
    }

    public byte[] getEncoded() {
        try {
            return (byte[])this.getEncodedInternal().clone();
        }
        catch (InvalidKeyException invalidKeyException) {
            return null;
        }
    }

    public byte[] getEncodedInternal() throws InvalidKeyException {
        byte[] byArray = this.encodedKey;
        if (byArray == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                byArray = derOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("IOException : " + iOException.getMessage());
            }
            this.encodedKey = byArray;
        }
        return byArray;
    }

    public void decode(byte[] byArray) throws InvalidKeyException {
        this.decode(new ByteArrayInputStream(byArray));
    }

    public void decode(InputStream inputStream) throws InvalidKeyException {
        try {
            DerValue derValue = new DerValue(inputStream);
            if (derValue.tag != 48) {
                throw new InvalidKeyException("invalid key format");
            }
            this.algid = AlgorithmId.parse(derValue.data.getDerValue());
            this.setKey(derValue.data.getUnalignedBitString());
            this.parseKeyBits();
            if (derValue.data.available() != 0) {
                throw new InvalidKeyException("excess key data");
            }
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("IOException: " + iOException.getMessage());
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.decode(objectInputStream);
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
            throw new IOException("deserialized key is invalid: " + invalidKeyException.getMessage());
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.getEncoded());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Key)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncodedInternal();
            byte[] byArray2 = object instanceof X509Key ? ((X509Key)object).getEncodedInternal() : ((Key)object).getEncoded();
            return Arrays.equals(byArray, byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
    }

    public String getAlgorithm() {
        return this.algid.getName();
    }

    public String getFormat() {
        return "X.509";
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        return "algorithm = " + this.algid.toString() + ", unparsed keybits = \n" + hexDumpEncoder.encodeBuffer(this.key);
    }

    protected BitArray getKey() {
        this.bitStringKey = new BitArray(this.key.length * 8 - this.unusedBits, this.key);
        return (BitArray)this.bitStringKey.clone();
    }

    protected void setKey(BitArray bitArray) {
        this.bitStringKey = (BitArray)bitArray.clone();
        this.key = bitArray.toByteArray();
        int n = bitArray.length() % 8;
        this.unusedBits = n == 0 ? 0 : 8 - n;
    }

    public final void encode(DerOutputStream derOutputStream) throws IOException {
        X509Key.encode(derOutputStream, this.algid, this.getKey());
    }

    public AlgorithmId getAlgorithmId() {
        return this.algid;
    }

    public static PublicKey parse(DerValue derValue) throws IOException {
        PublicKey publicKey;
        if (derValue.tag != 48) {
            throw new IOException("corrupt subject key");
        }
        AlgorithmId algorithmId = AlgorithmId.parse(derValue.data.getDerValue());
        try {
            publicKey = X509Key.buildX509Key(algorithmId, derValue.data.getUnalignedBitString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("subject key, " + invalidKeyException.getMessage());
        }
        if (derValue.data.available() != 0) {
            throw new IOException("excess subject key");
        }
        return publicKey;
    }

    private X509Key(AlgorithmId algorithmId, BitArray bitArray) throws InvalidKeyException {
        this.algid = algorithmId;
        this.setKey(bitArray);
        this.encode();
    }

    static PublicKey buildX509Key(AlgorithmId algorithmId, BitArray bitArray) throws IOException, InvalidKeyException {
        DerOutputStream derOutputStream = new DerOutputStream();
        X509Key.encode(derOutputStream, algorithmId, bitArray);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(derOutputStream.toByteArray());
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithmId.getName());
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(invalidKeySpecException.getMessage());
        }
        String string = "";
        try {
            Object object;
            Class clazz;
            block13: {
                Provider provider = Security.getProvider("SUN");
                if (provider == null) {
                    throw new InstantiationException();
                }
                string = provider.getProperty("PublicKey.X.509." + algorithmId.getName());
                if (string == null) {
                    throw new InstantiationException();
                }
                clazz = null;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object = ClassLoader.getSystemClassLoader();
                    if (object == null) break block13;
                    clazz = ((ClassLoader)object).loadClass(string);
                }
            }
            Object object2 = null;
            if (clazz != null) {
                object2 = clazz.newInstance();
            }
            if (object2 instanceof X509Key) {
                object = (X509Key)object2;
                ((X509Key)object).algid = algorithmId;
                ((X509Key)object).setKey(bitArray);
                ((X509Key)object).parseKeyBits();
                return object;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException(string + " [internal error]");
        }
        X509Key x509Key = new X509Key(algorithmId, bitArray);
        return x509Key;
    }

    static void encode(DerOutputStream derOutputStream, AlgorithmId algorithmId, BitArray bitArray) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        algorithmId.encode(derOutputStream2);
        derOutputStream2.putUnalignedBitString(bitArray);
        derOutputStream.write((byte)48, derOutputStream2);
    }
}

