/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

public final class Utility {
    static final char ESCAPE = '\ua5a5';
    static final byte ESCAPE_BYTE = -91;
    static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final boolean arrayRegionMatches(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        int n4 = n + n3;
        int n5 = n2 - n;
        for (int i = n; i < n4; ++i) {
            if (dArray[i] == dArray2[i + n5]) continue;
            return false;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        int n4 = n + n3;
        int n5 = n2 - n;
        for (int i = n; i < n4; ++i) {
            if (nArray[i] == nArray2[i + n5]) continue;
            return false;
        }
        return true;
    }

    public static final boolean arrayEquals(double[] dArray, Object object) {
        if (dArray == null) {
            return object == null;
        }
        if (!(object instanceof double[])) {
            return false;
        }
        double[] dArray2 = (double[])object;
        return dArray.length == dArray2.length && Utility.arrayRegionMatches(dArray, 0, dArray2, 0, dArray.length);
    }

    public static final boolean arrayEquals(int[] nArray, Object object) {
        if (nArray == null) {
            return object == null;
        }
        if (!(object instanceof int[])) {
            return false;
        }
        int[] nArray2 = (int[])object;
        return nArray.length == nArray2.length && Utility.arrayRegionMatches(nArray, 0, nArray2, 0, nArray.length);
    }

    public static final String hex(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        return Utility.hex(c, stringBuffer).toString();
    }

    public static final byte[] RLEStringToByteArray(String string) {
        int n = string.charAt(0) << 16 | string.charAt(1);
        byte[] byArray = new byte[n];
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 2;
        int n6 = 0;
        while (n6 < n) {
            int n7;
            if (bl) {
                n2 = string.charAt(n5++);
                n7 = (byte)(n2 >> 8);
                bl = false;
            } else {
                n7 = n2 & 0xFF;
                bl = true;
            }
            switch (n3) {
                case 0: {
                    if (n7 == -91) {
                        n3 = 1;
                        break;
                    }
                    byArray[n6++] = n7;
                    break;
                }
                case 1: {
                    if (n7 == -91) {
                        byArray[n6++] = -91;
                        n3 = 0;
                        break;
                    }
                    n4 = n7;
                    if (n4 < 0) {
                        n4 += 256;
                    }
                    n3 = 2;
                    break;
                }
                case 2: {
                    for (int i = 0; i < n4; ++i) {
                        byArray[n6++] = n7;
                    }
                    n3 = 0;
                }
            }
        }
        if (n3 != 0) {
            throw new InternalError("Bad run-length encoded byte array");
        }
        if (n5 != string.length()) {
            throw new InternalError("Excess data in RLE byte array string");
        }
        return byArray;
    }

    public static final char[] RLEStringToCharArray(String string) {
        int n = string.charAt(0) << 16 | string.charAt(1);
        char[] cArray = new char[n];
        int n2 = 0;
        for (int i = 2; i < string.length(); ++i) {
            int n3 = string.charAt(i);
            if (n3 == 42405) {
                if ((n3 = string.charAt(++i)) == 42405) {
                    cArray[n2++] = n3;
                    continue;
                }
                int n4 = n3;
                char c = string.charAt(++i);
                for (int j = 0; j < n4; ++j) {
                    cArray[n2++] = c;
                }
                continue;
            }
            cArray[n2++] = n3;
        }
        if (n2 != n) {
            throw new InternalError("Bad run-length encoded short array");
        }
        return cArray;
    }

    public static final int[] RLEStringToIntArray(String string) {
        int n = Utility.getInt(string, 0);
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 1;
        int n4 = string.length() / 2;
        while (n2 < n && n3 < n4) {
            int n5;
            if ((n5 = Utility.getInt(string, n3++)) == 42405) {
                if ((n5 = Utility.getInt(string, n3++)) == 42405) {
                    nArray[n2++] = n5;
                    continue;
                }
                int n6 = n5;
                int n7 = Utility.getInt(string, n3++);
                for (int i = 0; i < n6; ++i) {
                    nArray[n2++] = n7;
                }
                continue;
            }
            nArray[n2++] = n5;
        }
        if (n2 != n || n3 != n4) {
            throw new InternalError("Bad run-length encoded int array");
        }
        return nArray;
    }

    public static final short[] RLEStringToShortArray(String string) {
        int n = string.charAt(0) << 16 | string.charAt(1);
        short[] sArray = new short[n];
        int n2 = 0;
        for (int i = 2; i < string.length(); ++i) {
            int n3 = string.charAt(i);
            if (n3 == 42405) {
                if ((n3 = string.charAt(++i)) == 42405) {
                    sArray[n2++] = (short)n3;
                    continue;
                }
                int n4 = n3;
                short s = (short)string.charAt(++i);
                for (int j = 0; j < n4; ++j) {
                    sArray[n2++] = s;
                }
                continue;
            }
            sArray[n2++] = (short)n3;
        }
        if (n2 != n) {
            throw new InternalError("Bad run-length encoded short array");
        }
        return sArray;
    }

    static final int getInt(String string, int n) {
        return string.charAt(2 * n) << 16 | string.charAt(2 * n + 1);
    }

    public static final String arrayToRLEString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)(byArray.length >> 16));
        stringBuffer.append((char)byArray.length);
        byte by = byArray[0];
        int n = 1;
        byte[] byArray2 = new byte[2];
        for (int i = 1; i < byArray.length; ++i) {
            byte by2 = byArray[i];
            if (by2 == by && n < 255) {
                ++n;
                continue;
            }
            Utility.encodeRun(stringBuffer, by, n, byArray2);
            by = by2;
            n = 1;
        }
        Utility.encodeRun(stringBuffer, by, n, byArray2);
        if (byArray2[0] != 0) {
            Utility.appendEncodedByte(stringBuffer, (byte)0, byArray2);
        }
        return stringBuffer.toString();
    }

    public static final String arrayToRLEString(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)(cArray.length >> 16));
        stringBuffer.append((char)cArray.length);
        char c = cArray[0];
        int n = 1;
        for (int i = 1; i < cArray.length; ++i) {
            char c2 = cArray[i];
            if (c2 == c && n < 65535) {
                ++n;
                continue;
            }
            Utility.encodeRun(stringBuffer, (short)c, n);
            c = c2;
            n = 1;
        }
        Utility.encodeRun(stringBuffer, (short)c, n);
        return stringBuffer.toString();
    }

    public static final String arrayToRLEString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        Utility.appendInt(stringBuffer, nArray.length);
        int n = nArray[0];
        int n2 = 1;
        for (int i = 1; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (n3 == n && n2 < 65535) {
                ++n2;
                continue;
            }
            Utility.encodeRun(stringBuffer, n, n2);
            n = n3;
            n2 = 1;
        }
        Utility.encodeRun(stringBuffer, n, n2);
        return stringBuffer.toString();
    }

    public static final String arrayToRLEString(short[] sArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)(sArray.length >> 16));
        stringBuffer.append((char)sArray.length);
        short s = sArray[0];
        int n = 1;
        for (int i = 1; i < sArray.length; ++i) {
            short s2 = sArray[i];
            if (s2 == s && n < 65535) {
                ++n;
                continue;
            }
            Utility.encodeRun(stringBuffer, s, n);
            s = s2;
            n = 1;
        }
        Utility.encodeRun(stringBuffer, s, n);
        return stringBuffer.toString();
    }

    private static final void encodeRun(StringBuffer stringBuffer, byte by, int n, byte[] byArray) {
        if (n < 4) {
            for (int i = 0; i < n; ++i) {
                if (by == -91) {
                    Utility.appendEncodedByte(stringBuffer, (byte)-91, byArray);
                }
                Utility.appendEncodedByte(stringBuffer, by, byArray);
            }
        } else {
            if (n == -91) {
                if (by == -91) {
                    Utility.appendEncodedByte(stringBuffer, (byte)-91, byArray);
                }
                Utility.appendEncodedByte(stringBuffer, by, byArray);
                --n;
            }
            Utility.appendEncodedByte(stringBuffer, (byte)-91, byArray);
            Utility.appendEncodedByte(stringBuffer, (byte)n, byArray);
            Utility.appendEncodedByte(stringBuffer, by, byArray);
        }
    }

    private static final void appendEncodedByte(StringBuffer stringBuffer, byte by, byte[] byArray) {
        if (byArray[0] != 0) {
            char c = (char)(byArray[1] << 8 | by & 0xFF);
            stringBuffer.append(c);
            byArray[0] = 0;
        } else {
            byArray[0] = 1;
            byArray[1] = by;
        }
    }

    private static final void appendInt(StringBuffer stringBuffer, int n) {
        stringBuffer.append((char)(n >>> 16));
        stringBuffer.append((char)(n & 0xFFFF));
    }

    private static final void encodeRun(StringBuffer stringBuffer, int n, int n2) {
        if (n2 < 4) {
            for (int i = 0; i < n2; ++i) {
                if (n == 42405) {
                    Utility.appendInt(stringBuffer, n);
                }
                Utility.appendInt(stringBuffer, n);
            }
        } else {
            if (n2 == 42405) {
                if (n == 42405) {
                    Utility.appendInt(stringBuffer, 42405);
                }
                Utility.appendInt(stringBuffer, n);
                --n2;
            }
            Utility.appendInt(stringBuffer, 42405);
            Utility.appendInt(stringBuffer, n2);
            Utility.appendInt(stringBuffer, n);
        }
    }

    private static final void encodeRun(StringBuffer stringBuffer, short s, int n) {
        if (n < 4) {
            for (int i = 0; i < n; ++i) {
                if (s == 42405) {
                    stringBuffer.append('\ua5a5');
                }
                stringBuffer.append((char)s);
            }
        } else {
            if (n == 42405) {
                if (s == 42405) {
                    stringBuffer.append('\ua5a5');
                }
                stringBuffer.append((char)s);
                --n;
            }
            stringBuffer.append('\ua5a5');
            stringBuffer.append((char)n);
            stringBuffer.append((char)s);
        }
    }

    public static final boolean arrayEquals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object instanceof Object[]) {
            return Utility.arrayEquals((Object[])object, object2);
        }
        if (object instanceof int[]) {
            return Utility.arrayEquals((int[])object, object2);
        }
        if (object instanceof double[]) {
            return Utility.arrayEquals((int[])object, object2);
        }
        return object.equals(object2);
    }

    public static final boolean objectEquals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public static final boolean arrayRegionMatches(Object[] objectArray, int n, Object[] objectArray2, int n2, int n3) {
        int n4 = n + n3;
        int n5 = n2 - n;
        for (int i = n; i < n4; ++i) {
            if (Utility.arrayEquals(objectArray[i], objectArray2[i + n5])) continue;
            return false;
        }
        return true;
    }

    public static final boolean arrayEquals(Object[] objectArray, Object object) {
        if (objectArray == null) {
            return object == null;
        }
        if (!(object instanceof Object[])) {
            return false;
        }
        Object[] objectArray2 = (Object[])object;
        return objectArray.length == objectArray2.length && Utility.arrayRegionMatches(objectArray, 0, objectArray2, 0, objectArray.length);
    }

    public static final String formatForSource(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (n > 0) {
                stringBuffer.append("+\n");
            }
            stringBuffer.append("        \"");
            int n2 = 11;
            while (n < string.length() && n2 < 80) {
                char c;
                if ((c = string.charAt(n++)) < ' ' || c == '\"') {
                    stringBuffer.append('\\');
                    stringBuffer.append(HEX_DIGIT[(c & 0x1C0) >> 6]);
                    stringBuffer.append(HEX_DIGIT[(c & 0x38) >> 3]);
                    stringBuffer.append(HEX_DIGIT[c & 7]);
                    n2 += 4;
                    continue;
                }
                if (c <= '~') {
                    stringBuffer.append(c);
                    ++n2;
                    continue;
                }
                stringBuffer.append("\\u");
                stringBuffer.append(HEX_DIGIT[(c & 0xF000) >> 12]);
                stringBuffer.append(HEX_DIGIT[(c & 0xF00) >> 8]);
                stringBuffer.append(HEX_DIGIT[(c & 0xF0) >> 4]);
                stringBuffer.append(HEX_DIGIT[c & 0xF]);
                n2 += 6;
            }
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }

    public static final String hex(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Utility.hex(string, stringBuffer);
        return stringBuffer.toString();
    }

    public static final String hex(StringBuffer stringBuffer) {
        return Utility.hex(stringBuffer.toString());
    }

    public static final StringBuffer hex(char c, StringBuffer stringBuffer) {
        for (int i = 12; i >= 0; i -= 4) {
            stringBuffer.append(HEX_DIGIT[(byte)(c >> i & 0xF)]);
        }
        return stringBuffer;
    }

    public static final StringBuffer hex(String string, StringBuffer stringBuffer) {
        if (string != null && stringBuffer != null) {
            int n = string.length();
            int n2 = 0;
            Utility.hex(string.charAt(n2), stringBuffer);
            while (n2 < n) {
                stringBuffer.append(',');
                Utility.hex(string.charAt(n2++), stringBuffer);
            }
        }
        return stringBuffer;
    }
}

