/*
 * Decompiled with CFR 0.152.
 */
package sun.text.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sun.misc.Launcher;
import sun.security.action.GetPropertyAction;

public class LocaleData {
    private static Vector classPathSegments;
    private static Locale[] localeList;
    private static final String PACKAGE = "sun.text.resources";
    private static final String PREFIX = "LocaleElements_";
    private static final char ZIPSEPARATOR = '/';
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = !LocaleData.class.desiredAssertionStatus();
        classPathSegments = new Vector();
    }

    private static Locale[] createLocaleList() {
        Object object;
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.boot.class.path"));
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("java.class.path"));
        if (string2 != null && string2.length() != 0) {
            string = string + File.pathSeparator + string2;
        }
        while (string != null && string.length() != 0) {
            int n = string.lastIndexOf(File.pathSeparatorChar);
            object = string.substring(n + 1);
            string = n == -1 ? null : string.substring(0, n);
            classPathSegments.insertElementAt(object, 0);
        }
        ClassLoader classLoader = Launcher.getLauncher().getClassLoader();
        object = (URLClassLoader)classLoader.getParent();
        URL[] uRLArray = ((URLClassLoader)object).getURLs();
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                URI uRI = new URI(uRLArray[i].toString());
                classPathSegments.insertElementAt(uRI.getPath(), 0);
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                continue;
            }
        }
        String[] stringArray = (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return LocaleData.getClassList(LocaleData.PACKAGE, LocaleData.PREFIX);
            }
        });
        int n = PREFIX.length();
        Locale[] localeArray = new Locale[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = 0;
            int n3 = stringArray[i].indexOf(95, n);
            String string3 = "";
            String string4 = "";
            String string5 = "";
            if (n3 == -1) {
                string3 = stringArray[i].substring(n);
            } else {
                string3 = stringArray[i].substring(n, n3);
                n2 = stringArray[i].indexOf(95, n3 + 1);
                if (n2 == -1) {
                    string4 = stringArray[i].substring(n3 + 1);
                } else {
                    string4 = stringArray[i].substring(n3 + 1, n2);
                    if (n2 < stringArray[i].length()) {
                        string5 = stringArray[i].substring(n2 + 1);
                    }
                }
            }
            localeArray[i] = new Locale(string3, string4, string5);
        }
        return localeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale[] getAvailableLocales(String string) {
        Locale[] localeArray;
        if (localeList == null) {
            localeArray = LocaleData.class;
            synchronized (localeArray) {
                if (localeList == null) {
                    localeList = LocaleData.createLocaleList();
                }
            }
        }
        localeArray = new Locale[localeList.length];
        System.arraycopy(localeList, 0, localeArray, 0, localeList.length);
        return localeArray;
    }

    public static ResourceBundle getDateFormatZoneData(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.DateFormatZoneData", locale);
    }

    public static ResourceBundle getLocaleElements(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.LocaleElements", locale);
    }

    private static String[] getClassList(String string, String string2) {
        Vector vector = new Vector();
        String string3 = string.replace('.', File.separatorChar) + File.separatorChar;
        String string4 = string.replace('.', '/') + '/';
        for (int i = 0; i < classPathSegments.size(); ++i) {
            String string5;
            File file;
            String string6 = (String)classPathSegments.elementAt(i);
            File file2 = new File(string6);
            if (!file2.exists()) continue;
            if (file2.isFile()) {
                LocaleData.scanFile(file2, string4, vector, string2);
                continue;
            }
            if (!file2.isDirectory() || !(file = new File(string5 = string6.endsWith(File.separator) ? string6 + string3 : string6 + File.separatorChar + string3)).exists() || !file.isDirectory()) continue;
            LocaleData.scanDir(file, vector, string2);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static void scanDir(File file, Vector vector, String string) {
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            LocaleData.addClass(LocaleData.midString(stringArray[i], "", ".class"), vector, string);
        }
    }

    private static void addClass(String string, Vector vector, String string2) {
        if (string != null && string.startsWith(string2) && !vector.contains(string)) {
            vector.addElement(string);
        }
    }

    private static ResourceBundle getBundle(final String string, final Locale locale) {
        return (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ResourceBundle.getBundle(string, locale);
            }
        });
    }

    private static String midString(String string, String string2, String string3) {
        String string4 = string.startsWith(string2) && string.endsWith(string3) ? string.substring(string2.length(), string.length() - string3.length()) : null;
        return string4;
    }

    private static void scanFile(File file, String string, Vector vector, String string2) {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string3 = zipEntry.getName();
                if (!string3.startsWith(string) || !string3.endsWith(".class")) continue;
                LocaleData.addClass(LocaleData.midString(string3, string, ".class"), vector, string2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("file not found:" + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println("file IO Exception:" + iOException);
        }
        catch (Exception exception) {
            System.out.println("Exception:" + exception);
        }
    }
}

