/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics.dds.ddsutil;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eclipse.swt.graphics.ImageData;
import org.sf.feeling.swt.win32.extension.graphics.dds.compression.DXTBufferCompressor;
import org.sf.feeling.swt.win32.extension.graphics.dds.compression.DXTBufferDecompressor;
import org.sf.feeling.swt.win32.extension.graphics.dds.jogl.DDSImage;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Squish;
import org.sf.feeling.swt.win32.extension.graphics.dds.model.AbstractTextureMap;
import org.sf.feeling.swt.win32.extension.graphics.dds.model.MipMaps;
import org.sf.feeling.swt.win32.extension.graphics.dds.model.SingleTextureMap;
import org.sf.feeling.swt.win32.extension.graphics.dds.model.TextureMap;
import org.sf.feeling.swt.win32.extension.graphics.dds.util.ImageUtils;

public class DDSUtil {
    public static final int TOP_MOST_MIP_MAP = 0;

    private DDSUtil() {
    }

    public static ImageData decompressTexture(File file) throws IOException {
        return DDSUtil.decompressTexture(DDSImage.read(file));
    }

    public static ImageData decompressTexture(DDSImage dDSImage) {
        return DDSUtil.decompressTexture(dDSImage.getMipMap(0).getData(), dDSImage.getWidth(), dDSImage.getHeight(), DDSUtil.findCompressionFormat(dDSImage));
    }

    public static ImageData decompressTexture(byte[] byArray, int n, int n2, Squish.CompressionType compressionType) {
        return new DXTBufferDecompressor(byArray, n, n2, compressionType).getImage();
    }

    public static ImageData decompressTexture(ByteBuffer byteBuffer, int n, int n2, Squish.CompressionType compressionType) {
        return new DXTBufferDecompressor(byteBuffer, n, n2, compressionType).getImage();
    }

    public static ImageData decompressTexture(ByteBuffer byteBuffer, int n, int n2, int n3) {
        Squish.CompressionType compressionType = DDSUtil.getSquishCompressionFormat(n3);
        return new DXTBufferDecompressor(byteBuffer, n, n2, compressionType).getImage();
    }

    public static ByteBuffer compressTexture(ImageData imageData, Squish.CompressionType compressionType) {
        return new DXTBufferCompressor(imageData, compressionType).getByteBuffer();
    }

    public static byte[] compressTextureToArray(ImageData imageData, Squish.CompressionType compressionType) {
        return new DXTBufferCompressor(imageData, compressionType).getArray();
    }

    public static void write(File file, ImageData imageData, int n, boolean bl) throws IOException {
        AbstractTextureMap abstractTextureMap;
        int n2 = imageData.width;
        int n3 = imageData.height;
        if (imageData.depth < 32) {
            imageData = ImageUtils.convertToRGBA(imageData);
        }
        if (bl) {
            abstractTextureMap = new MipMaps();
            ((MipMaps)abstractTextureMap).generateMipMaps(imageData);
        } else {
            abstractTextureMap = new SingleTextureMap(imageData);
        }
        ByteBuffer[] byteBufferArray = null;
        byteBufferArray = DDSUtil.isDXTCompressed(n) ? abstractTextureMap.getDXTCompressedBuffer(n) : abstractTextureMap.getUncompressedBuffer();
        DDSUtil.writeDDSImage(file, byteBufferArray, n2, n3, n);
    }

    public static void write(OutputStream outputStream, ImageData imageData, int n, boolean bl) throws IOException {
        AbstractTextureMap abstractTextureMap;
        int n2 = imageData.width;
        int n3 = imageData.height;
        if (imageData.depth < 32) {
            imageData = ImageUtils.convertToRGBA(imageData);
        }
        if (bl) {
            abstractTextureMap = new MipMaps();
            ((MipMaps)abstractTextureMap).generateMipMaps(imageData);
        } else {
            abstractTextureMap = new SingleTextureMap(imageData);
        }
        ByteBuffer[] byteBufferArray = null;
        byteBufferArray = DDSUtil.isDXTCompressed(n) ? abstractTextureMap.getDXTCompressedBuffer(n) : abstractTextureMap.getUncompressedBuffer();
        DDSUtil.writeDDSImage(outputStream, byteBufferArray, n2, n3, n);
    }

    public void write(File file, TextureMap textureMap, int n) throws IOException {
        DDSUtil.writeDDSImage(file, textureMap.getDXTCompressedBuffer(n), textureMap.getWidth(), textureMap.getHeight(), n);
    }

    private static DDSImage writeDDSImage(File file, ByteBuffer[] byteBufferArray, int n, int n2, int n3) throws IllegalArgumentException, IOException {
        DDSImage dDSImage = DDSImage.createFromData(n3, n, n2, byteBufferArray);
        dDSImage.write(file);
        return dDSImage;
    }

    public void write(OutputStream outputStream, TextureMap textureMap, int n) throws IOException {
        DDSUtil.writeDDSImage(outputStream, textureMap.getDXTCompressedBuffer(n), textureMap.getWidth(), textureMap.getHeight(), n);
    }

    private static DDSImage writeDDSImage(OutputStream outputStream, ByteBuffer[] byteBufferArray, int n, int n2, int n3) throws IllegalArgumentException, IOException {
        DDSImage dDSImage = DDSImage.createFromData(n3, n, n2, byteBufferArray);
        dDSImage.write(outputStream);
        return dDSImage;
    }

    public static boolean isDXTCompressed(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 827611204: 
            case 844388420: 
            case 861165636: 
            case 877942852: 
            case 894720068: 
        }
        return true;
    }

    public static int getCompressionType(File file) throws IOException {
        return DDSImage.read(file).getFormatType();
    }

    private static Squish.CompressionType findCompressionFormat(DDSImage dDSImage) {
        int n = dDSImage.getFormatType();
        return DDSUtil.getSquishCompressionFormat(n);
    }

    public static Squish.CompressionType getSquishCompressionFormat(int n) {
        Squish.CompressionType compressionType = null;
        switch (n) {
            case 827611204: {
                compressionType = Squish.CompressionType.DXT1;
                break;
            }
            case 861165636: {
                compressionType = Squish.CompressionType.DXT3;
                break;
            }
            case 894720068: {
                compressionType = Squish.CompressionType.DXT5;
            }
        }
        return compressionType;
    }

    public static Squish.CompressionType selectedCompression(int n) {
        switch (n) {
            default: {
                return null;
            }
            case 827611204: {
                return Squish.CompressionType.DXT1;
            }
            case 861165636: {
                return Squish.CompressionType.DXT3;
            }
            case 894720068: {
                return Squish.CompressionType.DXT5;
            }
            case 20: 
        }
        return null;
    }
}

