/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics.dds.jsquish;

import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Squish;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Vec;

final class ColourSet {
    private int count;
    private final Vec[] points = new Vec[16];
    private final float[] weights = new float[16];
    private final int[] remap = new int[16];
    private boolean transparent;

    ColourSet() {
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new Vec();
        }
    }

    void init(byte[] byArray, int n, Squish.CompressionType compressionType, boolean bl) {
        boolean bl2 = compressionType == Squish.CompressionType.DXT1;
        this.count = 0;
        this.transparent = false;
        block0: for (int i = 0; i < 16; ++i) {
            int n2 = 1 << i;
            if ((n & n2) == 0) {
                this.remap[i] = -1;
                continue;
            }
            if (bl2 && (byArray[4 * i + 3] & 0xFF) < 128) {
                this.remap[i] = -1;
                this.transparent = true;
                continue;
            }
            int n3 = 0;
            while (true) {
                boolean bl3;
                if (n3 == i) {
                    float f = (float)(byArray[4 * i] & 0xFF) / 255.0f;
                    float f2 = (float)(byArray[4 * i + 1] & 0xFF) / 255.0f;
                    float f3 = (float)(byArray[4 * i + 2] & 0xFF) / 255.0f;
                    this.points[this.count].set(f, f2, f3);
                    this.weights[this.count] = bl ? (float)((byArray[4 * i + 3] & 0xFF) + 1) / 256.0f : 1.0f;
                    ++this.count;
                    continue block0;
                }
                int n4 = 1 << n3;
                boolean bl4 = bl3 = (n & n4) != 0 && byArray[4 * i] == byArray[4 * n3] && byArray[4 * i + 1] == byArray[4 * n3 + 1] && byArray[4 * i + 2] == byArray[4 * n3 + 2] && (byArray[4 * n3 + 3] != 0 || !bl2);
                if (bl3) {
                    int n5;
                    int n6 = n5 = this.remap[n3];
                    this.weights[n6] = this.weights[n6] + (bl ? (float)((byArray[4 * i + 3] & 0xFF) + 1) / 256.0f : 1.0f);
                    this.remap[i] = n5;
                    continue block0;
                }
                ++n3;
            }
        }
    }

    int getCount() {
        return this.count;
    }

    Vec[] getPoints() {
        return this.points;
    }

    float[] getWeights() {
        return this.weights;
    }

    boolean isTransparent() {
        return this.transparent;
    }

    void remapIndices(int[] nArray, int[] nArray2) {
        for (int i = 0; i < 16; ++i) {
            int n = this.remap[i];
            nArray2[i] = n == -1 ? 3 : nArray[n];
        }
    }
}

