/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics.dds.jsquish;

import java.util.Arrays;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.ColourSet;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Vec;

final class Matrix {
    private static final float FLT_EPSILON = 1.0E-5f;
    private static float[] m = new float[6];
    private static float[] u = new float[6];
    private float[] values = new float[6];

    Matrix() {
    }

    Matrix(float f) {
        for (int i = 0; i < 6; ++i) {
            this.values[i] = f;
        }
    }

    float get(int n) {
        return this.values[n];
    }

    static Matrix computeWeightedCovariance(ColourSet colourSet, Matrix matrix) {
        int n = colourSet.getCount();
        Vec[] vecArray = colourSet.getPoints();
        float[] fArray = colourSet.getWeights();
        Vec vec = new Vec();
        Vec vec2 = new Vec();
        Vec vec3 = new Vec();
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            f += fArray[i];
            vec.add(vec2.set(vecArray[i]).mul(fArray[i]));
        }
        vec.div(f);
        if (matrix == null) {
            matrix = new Matrix();
        } else {
            Arrays.fill(matrix.values, 0.0f);
        }
        float[] fArray2 = matrix.values;
        for (int i = 0; i < n; ++i) {
            vec2.set(vecArray[i]).sub(vec);
            vec3.set(vec2).mul(fArray[i]);
            fArray2[0] = fArray2[0] + vec2.x() * vec3.x();
            fArray2[1] = fArray2[1] + vec2.x() * vec3.y();
            fArray2[2] = fArray2[2] + vec2.x() * vec3.z();
            fArray2[3] = fArray2[3] + vec2.y() * vec3.y();
            fArray2[4] = fArray2[4] + vec2.y() * vec3.z();
            fArray2[5] = fArray2[5] + vec2.z() * vec3.z();
        }
        return matrix;
    }

    private static Vec getMultiplicity1Evector(Matrix matrix, float f) {
        float[] fArray = matrix.values;
        float[] fArray2 = m;
        fArray2[0] = fArray[0] - f;
        fArray2[1] = fArray[1];
        fArray2[2] = fArray[2];
        fArray2[3] = fArray[3] - f;
        fArray2[4] = fArray[4];
        fArray2[5] = fArray[5] - f;
        float[] fArray3 = u;
        fArray3[0] = fArray2[3] * fArray2[5] - fArray2[4] * fArray2[4];
        fArray3[1] = fArray2[2] * fArray2[4] - fArray2[1] * fArray2[5];
        fArray3[2] = fArray2[1] * fArray2[4] - fArray2[2] * fArray2[3];
        fArray3[3] = fArray2[0] * fArray2[5] - fArray2[2] * fArray2[2];
        fArray3[4] = fArray2[1] * fArray2[2] - fArray2[4] * fArray2[0];
        fArray3[5] = fArray2[0] * fArray2[3] - fArray2[1] * fArray2[1];
        float f2 = Math.abs(fArray3[0]);
        int n = 0;
        for (int i = 1; i < 6; ++i) {
            float f3 = Math.abs(fArray3[i]);
            if (!(f3 > f2)) continue;
            f2 = f3;
            n = i;
        }
        switch (n) {
            case 0: {
                return new Vec(fArray3[0], fArray3[1], fArray3[2]);
            }
            case 1: 
            case 3: {
                return new Vec(fArray3[1], fArray3[3], fArray3[4]);
            }
        }
        return new Vec(fArray3[2], fArray3[4], fArray3[5]);
    }

    private static Vec getMultiplicity2Evector(Matrix matrix, float f) {
        float[] fArray = matrix.values;
        float[] fArray2 = m;
        fArray2[0] = fArray[0] - f;
        fArray2[1] = fArray[1];
        fArray2[2] = fArray[2];
        fArray2[3] = fArray[3] - f;
        fArray2[4] = fArray[4];
        fArray2[5] = fArray[5] - f;
        float f2 = Math.abs(fArray2[0]);
        int n = 0;
        for (int i = 1; i < 6; ++i) {
            float f3 = Math.abs(fArray2[i]);
            if (!(f3 > f2)) continue;
            f2 = f3;
            n = i;
        }
        switch (n) {
            case 0: 
            case 1: {
                return new Vec(-fArray2[1], fArray2[0], 0.0f);
            }
            case 2: {
                return new Vec(fArray2[2], 0.0f, -fArray2[0]);
            }
            case 3: 
            case 4: {
                return new Vec(0.0f, -fArray2[4], fArray2[3]);
            }
        }
        return new Vec(0.0f, -fArray2[5], fArray2[4]);
    }

    static Vec computePrincipleComponent(Matrix matrix) {
        float[] fArray = matrix.values;
        float f = fArray[0] + fArray[3] + fArray[5];
        float f2 = fArray[0] * fArray[3] + fArray[0] * fArray[5] + fArray[3] * fArray[5] - fArray[1] * fArray[1] - fArray[2] * fArray[2] - fArray[4] * fArray[4];
        float f3 = fArray[0] * fArray[3] * fArray[5] + 2.0f * fArray[1] * fArray[2] * fArray[4] - fArray[0] * fArray[4] * fArray[4] - fArray[3] * fArray[2] * fArray[2] - fArray[5] * fArray[1] * fArray[1];
        float f4 = -0.074074075f * f * f * f + 0.33333334f * f2 * f - f3;
        float f5 = f2 - 0.33333334f * f * f;
        float f6 = 0.25f * f4 * f4 + 0.037037037f * f5 * f5 * f5;
        if (1.0E-5f < f6) {
            return new Vec(1.0f);
        }
        if (f6 < -1.0E-5f) {
            float f7 = (float)Math.atan2(Math.sqrt(-f6), -0.5f * f4);
            float f8 = (float)Math.sqrt(0.25f * f4 * f4 - f6);
            float f9 = (float)Math.pow(f8, 0.3333333432674408);
            float f10 = (float)Math.cos(f7 / 3.0f);
            float f11 = (float)Math.sin(f7 / 3.0f);
            float f12 = 0.33333334f * f + 2.0f * f9 * f10;
            float f13 = 0.33333334f * f - f9 * (f10 + (float)Math.sqrt(3.0) * f11);
            float f14 = 0.33333334f * f - f9 * (f10 - (float)Math.sqrt(3.0) * f11);
            if (Math.abs(f13) > Math.abs(f12)) {
                f12 = f13;
            }
            if (Math.abs(f14) > Math.abs(f12)) {
                f12 = f14;
            }
            return Matrix.getMultiplicity1Evector(matrix, f12);
        }
        float f15 = f4 < 0.0f ? (float)(-Math.pow(-0.5f * f4, 0.3333333432674408)) : (float)Math.pow(0.5f * f4, 0.3333333432674408);
        float f16 = 0.33333334f * f + f15;
        float f17 = 0.33333334f * f - 2.0f * f15;
        if (Math.abs(f16) > Math.abs(f17)) {
            return Matrix.getMultiplicity2Evector(matrix, f16);
        }
        return Matrix.getMultiplicity1Evector(matrix, f17);
    }
}

