/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics.dds.model;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Vector;
import org.eclipse.swt.graphics.ImageData;
import org.sf.feeling.swt.win32.extension.graphics.dds.compression.DXTBufferDecompressor;
import org.sf.feeling.swt.win32.extension.graphics.dds.ddsutil.DDSUtil;
import org.sf.feeling.swt.win32.extension.graphics.dds.ddsutil.MipMapsUtil;
import org.sf.feeling.swt.win32.extension.graphics.dds.ddsutil.NonCubicDimensionException;
import org.sf.feeling.swt.win32.extension.graphics.dds.jogl.DDSImage;
import org.sf.feeling.swt.win32.extension.graphics.dds.jsquish.Squish;
import org.sf.feeling.swt.win32.extension.graphics.dds.model.DDSFile;
import org.sf.feeling.swt.win32.extension.graphics.dds.model.MipMaps;

public class DDSImageFile
extends DDSFile {
    protected ImageData topmost;

    public DDSImageFile(File file) throws IOException {
        this(file, DDSImage.read(file));
    }

    public DDSImageFile(File file, DDSImage dDSImage) {
        super(file, dDSImage);
        Squish.CompressionType compressionType = DDSUtil.getSquishCompressionFormat(dDSImage.getFormatType());
        this.topmost = new DXTBufferDecompressor(dDSImage.getMipMap(0).getData(), dDSImage.getWidth(), dDSImage.getHeight(), compressionType).getImage();
    }

    public DDSImageFile(String string) throws IOException {
        this(new File(string));
    }

    public DDSImageFile(String string, DDSImage dDSImage) {
        this(new File(string), dDSImage);
    }

    public DDSImageFile(String string, ImageData imageData, int n, boolean bl) {
        this(new File(string), imageData, n, bl);
    }

    public DDSImageFile(File file, ImageData imageData, int n, boolean bl) {
        this.file = file;
        this.height = imageData.height;
        this.width = imageData.width;
        this.hasMipMaps = bl;
        this.topmost = imageData;
        this.pixelformat = n;
    }

    protected ByteBuffer[] getMipMapBuffer(DDSImage dDSImage) {
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.numMipMaps];
        if (this.hasMipMaps) {
            for (int i = 0; i < this.numMipMaps; ++i) {
                byteBufferArray[i] = dDSImage.getMipMap(i).getData();
            }
        } else {
            System.err.println("number of mipmaps: " + this.getNumMipMaps());
            byteBufferArray[0] = dDSImage.getMipMap(0).getData();
        }
        return byteBufferArray;
    }

    public ImageData getData() {
        return this.topmost;
    }

    public ImageData[] getAllMipMapsBI() {
        MipMaps mipMaps = new MipMaps();
        mipMaps.generateMipMaps(this.topmost);
        return mipMaps.getAllMipMapsArray();
    }

    public Vector generateAllMipMaps() {
        MipMaps mipMaps = new MipMaps();
        mipMaps.generateMipMaps(this.topmost);
        return mipMaps.getAllMipMaps();
    }

    public static int calculateMaxNumberOfMipMaps(int n, int n2) {
        return MipMapsUtil.calculateMaxNumberOfMipMaps(n, n2);
    }

    public void setData(ImageData imageData) {
        this.width = imageData.width;
        this.height = imageData.height;
        this.topmost = imageData;
    }

    public void write() throws IOException {
        this.write(this.file);
    }

    public void write(String string) throws IOException {
        this.write(new File(string));
    }

    public void write(File file) throws IOException {
        DDSUtil.write(file, this.topmost, this.pixelformat, this.hasMipMaps);
    }

    public void write(OutputStream outputStream) throws IOException {
        DDSUtil.write(outputStream, this.topmost, this.pixelformat, this.hasMipMaps);
    }

    public void activateMipMaps(boolean bl) throws IllegalArgumentException {
        if (!DDSImageFile.isPowerOfTwo(this.topmost.width) || !DDSImageFile.isPowerOfTwo(this.topmost.height)) {
            throw new NonCubicDimensionException();
        }
        this.hasMipMaps = bl;
    }

    public boolean hasMipMaps() {
        return this.hasMipMaps;
    }

    public static boolean isPowerOfTwo(int n) {
        double d = Math.floor(Math.log(n) / Math.log(2.0));
        double d2 = Math.pow(2.0, d);
        return d2 == (double)n;
    }
}

