/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.graphics.dds.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public class ImageUtils {
    public static ImageData convertToRGBA(ImageData imageData) {
        ImageData imageData2 = new ImageData(imageData.width, imageData.height, 32, new PaletteData(65280, 0xFF0000, -16777216));
        for (int i = 0; i < imageData.width; ++i) {
            for (int j = 0; j < imageData.height; ++j) {
                int n = imageData.getPixel(i, j);
                RGB rGB = imageData.palette.getRGB(n);
                byte[] byArray = new byte[]{(byte)rGB.red, (byte)rGB.green, (byte)rGB.blue, n == imageData.transparentPixel ? (byte)0 : -1};
                imageData2.setPixel(i, j, ImageUtils.getPixelFromRGBA(32, byArray));
            }
        }
        return imageData2;
    }

    public static ImageData convertBGRAToRGBA(byte[] byArray, Point point) {
        ImageData imageData = new ImageData(point.x, point.y, 32, new PaletteData(65280, 0xFF0000, -16777216));
        for (int i = 0; i < byArray.length; i += 4) {
            imageData.data[i] = byArray[i + 2];
            imageData.data[i + 1] = byArray[i + 1];
            imageData.data[i + 2] = byArray[i];
            imageData.data[i + 3] = byArray[i + 3];
        }
        return imageData;
    }

    public static byte[] convertRGBAToBGRA(ImageData imageData) {
        byte[] byArray = ImageUtils.convertDataBufferToArray(imageData);
        return byArray;
    }

    private static byte[] convertDataBufferToArray(ImageData imageData) {
        int n = imageData.height * imageData.width * 4;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += 4) {
            int n2 = imageData.getPixel(i / 4 % imageData.width, i / 4 / imageData.width);
            if (imageData.depth > 24) {
                byArray[i] = (byte)(n2 >> 8 & 0xFF);
                byArray[i + 1] = (byte)(n2 >> 16 & 0xFF);
                byArray[i + 2] = (byte)(n2 >> 24 & 0xFF);
                byArray[i + 3] = (byte)(n2 & 0xFF);
                continue;
            }
            byArray[i] = (byte)(n2 >> 16 & 0xFF);
            byArray[i + 1] = (byte)(n2 >> 8 & 0xFF);
            byArray[i + 2] = (byte)(n2 & 0xFF);
            byArray[i + 3] = -1;
        }
        return byArray;
    }

    public static int getPixelFromRGBA(int n, byte[] byArray) {
        switch (n) {
            case 32: {
                return ((byArray[0] & 0xFF) << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
            }
            case 24: {
                return ((byArray[0] & 0xFF) << 16) + ((byArray[1] & 0xFF) << 8) + (byArray[2] & 0xFF);
            }
            case 16: {
                return ((byArray[1] & 0xFF) << 8) + (byArray[0] & 0xFF);
            }
            case 8: {
                return byArray[0] & 0xFF;
            }
        }
        SWT.error((int)38);
        return 0;
    }
}

