/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.sf.feeling.swt.win32.extension.jna.Callback;
import org.sf.feeling.swt.win32.extension.jna.Convention;
import org.sf.feeling.swt.win32.extension.jna.StructConverter;
import org.sf.feeling.swt.win32.extension.jna.Type;
import org.sf.feeling.swt.win32.extension.jna.WindowProc;
import org.sf.feeling.swt.win32.extension.jna.datatype.BasicData;
import org.sf.feeling.swt.win32.extension.jna.datatype.CHAR;
import org.sf.feeling.swt.win32.extension.jna.datatype.DOUBLE;
import org.sf.feeling.swt.win32.extension.jna.datatype.FLOAT;
import org.sf.feeling.swt.win32.extension.jna.datatype.INT;
import org.sf.feeling.swt.win32.extension.jna.datatype.LONG;
import org.sf.feeling.swt.win32.extension.jna.datatype.LONGLONG;
import org.sf.feeling.swt.win32.extension.jna.datatype.SHORT;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.DWORD;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.HANDLE;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.Structure;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.NullPointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.NativeMemoryBlock;
import org.sf.feeling.swt.win32.extension.jna.win32.DbgHelp;
import org.sf.feeling.swt.win32.extension.jna.win32.Kernel32;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.HWND;
import org.sf.feeling.swt.win32.internal.extension.Extension;

public class Native {
    private static final Map mLibs;
    public static final String DLL_NAME = "swt-extension-jna-win32.dll";
    private static int currentModuleHandle;
    private int functionAddress;
    private boolean mIsClosed = false;
    private final String mDllName;
    private final String mFunctionName;
    private static Map mCallbacks;
    private Vector parameters = new Vector();
    private Vector parameterTypes = new Vector();
    private String mRetValue;
    private int moduleHandle;
    private int convention;
    private int lastError;
    private int mRetType;
    public static final int POINTER_SIZE;
    public static final int LONG_SIZE;
    public static final int WCHAR_SIZE;
    public static final int SIZE_T_SIZE;
    private static final int TYPE_VOIDP = 0;
    private static final int TYPE_LONG = 1;
    private static final int TYPE_WCHAR_T = 2;
    private static final int TYPE_SIZE_T = 3;

    private Vector getParameters() {
        return this.parameters;
    }

    private Vector getParameterTypes() {
        return this.parameterTypes;
    }

    public String toString() {
        return this.mDllName + "-" + this.mFunctionName;
    }

    public static void setDefaultCallingConvention(Convention convention) {
        Convention.setDefaultStyle(convention);
    }

    public Native(String string, String string2) throws NativeException {
        this(string, string2, Convention.DEFAULT);
    }

    public Native(String string, String string2, Convention convention) throws NativeException {
        this.convention = convention.getValue();
        this.mDllName = string;
        this.mFunctionName = string2;
        this.loadLibrary();
        try {
            this.setRetVal(Type.VOID);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public Native(int n, Convention convention) throws NativeException {
        this.convention = convention.getValue();
        this.mFunctionName = this.mDllName = "Anonymous";
        this.functionAddress = n;
        try {
            this.setRetVal(Type.VOID);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean loadLibrary() throws NativeException {
        Map map = mLibs;
        synchronized (map) {
            Native native_ = (Native)mLibs.get(this.mDllName);
            if (native_ == null || native_.getModuleHandle() == 0) {
                this.functionAddress = this.LoadLibrary(this.mDllName, this.mFunctionName);
                mLibs.put(this.mDllName, this);
            } else {
                this.moduleHandle = native_.getModuleHandle();
                this.functionAddress = this.FindFunction(this.moduleHandle, this.mFunctionName);
            }
            this.mIsClosed = false;
            return this.functionAddress != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isLibraryLoaded(String string) {
        Map map = mLibs;
        synchronized (map) {
            Native native_ = (Native)mLibs.get(string);
            return native_ != null && native_.getModuleHandle() != 0 && native_.getFunctionPointer() != 0;
        }
    }

    public int getFunctionPointer() {
        return this.functionAddress;
    }

    public int getModuleHandle() {
        return this.moduleHandle;
    }

    public void setParameter(int n, int n2) throws IllegalAccessException {
        this.setParameter(n, Type.INT, n2 + "");
    }

    public void setParameter(int n, Type type, String string) throws IllegalAccessException {
        if (string == null) {
            this.setParameter(n, 0);
        } else {
            this.setParameter(n, type, (string + '\u0000').getBytes());
        }
    }

    public void setParameter(int n, String string) throws IllegalAccessException {
        this.setParameter(n, Type.STRING, string);
    }

    public int getLastError() {
        return this.lastError;
    }

    public void setParameter(int n, Type type, byte[] byArray) throws IllegalAccessException {
        if (this.parameters.size() <= n) {
            int n2 = this.parameters.size();
            while (n2++ <= n) {
                this.parameters.add(new byte[4]);
                this.parameterTypes.add(new Integer(Type.INT.getNativeType()));
            }
        }
        this.parameters.set(n, byArray);
        this.parameterTypes.set(n, new Integer(type.getNativeType()));
    }

    public void setParameter(int n, Pointer pointer) throws NativeException, IllegalAccessException {
        if (pointer == null || pointer.getPointer() == 0) {
            this.setParameter(n, 0);
        } else {
            byte[] byArray = new byte[4];
            StructConverter.intIntoBytes(pointer.getPointer(), byArray, 0);
            this.setParameter(n, Type.PSTRUCT, byArray);
        }
    }

    public void setParameter(int n, Structure structure) throws NativeException, IllegalAccessException {
        this.setParameter(n, structure.createPointer());
    }

    public void setParameter(int n, BasicData basicData) throws NativeException, IllegalAccessException {
        if (basicData instanceof INT) {
            this.setParameter(n, Type.INT, ((INT)basicData).getValueAsString());
        } else if (basicData instanceof SHORT) {
            this.setParameter(n, Type.SHORT, ((SHORT)basicData).getValueAsString());
        } else if (basicData instanceof CHAR) {
            this.setParameter(n, Type.CHAR, ((SHORT)basicData).getValueAsString());
        } else if (basicData instanceof LONGLONG) {
            this.setParameter(n, Type.LONG, ((LONGLONG)basicData).getValueAsString());
        } else if (basicData instanceof FLOAT) {
            this.setParameter(n, Type.FLOAT, ((FLOAT)basicData).getValueAsString());
        } else if (basicData instanceof DOUBLE) {
            this.setParameter(n, Type.DOUBLE, ((DOUBLE)basicData).getValueAsString());
        } else if (basicData instanceof Structure) {
            this.setParameter(n, (Structure)basicData);
        } else {
            throw new IllegalArgumentException("Unknown Data Type");
        }
    }

    public void setRetVal(Type type) throws NativeException, IllegalAccessException {
        this.mRetType = type.getNativeType();
    }

    public String getRetVal() throws IllegalAccessException {
        this.throwClosed();
        return this.mRetValue;
    }

    public int getRetValAsInt() throws IllegalAccessException {
        return new Long(this.getRetVal()).intValue();
    }

    public void invoke() throws NativeException, IllegalAccessException {
        if (!Native.isLibraryLoaded(this.mDllName) && !"Anonymous".equals(this.mDllName)) {
            this.loadLibrary();
        }
        this.Invoke(this.functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void unLoad() throws NativeException {
        try {
            if (Native.isLibraryLoaded(this.mDllName)) {
                this.Dispose(this.moduleHandle);
            }
            this.mIsClosed = true;
            this.moduleHandle = 0;
        }
        finally {
            Map map = mLibs;
            synchronized (map) {
                mLibs.remove(this.mDllName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean unLoadLibrary(String string) throws NativeException {
        Map map = mLibs;
        synchronized (map) {
            if (mLibs.containsKey(string)) {
                ((Native)mLibs.get(string)).unLoad();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unLoadAllLibraries() {
        Map map = mLibs;
        synchronized (map) {
            if (!mLibs.isEmpty()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object[] objectArray = mLibs.keySet().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        Native.unLoadLibrary(objectArray[i].toString());
                        continue;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        }
    }

    public final String getFunctionName() {
        return this.mFunctionName;
    }

    public final String getDLLName() {
        return this.mDllName;
    }

    public Convention getStyle() {
        return Convention.fromInt(this.convention);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Native)) {
            return false;
        }
        Native native_ = (Native)object;
        return this.mDllName.equals(native_.getDLLName()) && this.mFunctionName.equals(native_.getFunctionName());
    }

    private void throwClosed() throws IllegalAccessException {
        if (this.mIsClosed) {
            throw new IllegalAccessException("This function (" + this.getFunctionName() + " in " + this.getDLLName() + ") is already closed");
        }
    }

    public static int allocMemory(int n) throws NativeException {
        return Native.Malloc(n);
    }

    public static void freeMemory(int n) throws NativeException {
        Native.Free(n);
    }

    public static void setMemory(int n, String string) throws NativeException {
        Native.setMemory(n, string.getBytes());
    }

    public static void setMemory(int n, byte[] byArray) throws NativeException {
        Native.setMemory(n, byArray, 0, byArray.length);
    }

    public static void setMemory(int n, byte[] byArray, int n2, int n3) throws NativeException {
        Native.SetMemory(n, byArray, n2, n3);
    }

    public static byte[] getMemory(int n, int n2) throws NativeException {
        return Native.GetMemory(n, n2);
    }

    public static int getStrLen(int n) throws NativeException {
        int n2 = 0;
        while (Native.getMemory(n++, 1)[0] != 0) {
            ++n2;
        }
        return n2;
    }

    public static String getMemoryAsString(int n) throws NativeException {
        return Native.getMemoryAsString(n, Native.getStrLen(n));
    }

    public static String getUnicodeMemoryAsString(int n) throws NativeException {
        byte[] byArray;
        StringBuffer stringBuffer = new StringBuffer();
        while ((byArray = Native.getMemory(n, 1))[0] != 0) {
            stringBuffer.append(new String(byArray));
            n += 2;
        }
        return stringBuffer.toString();
    }

    public static String getMemoryAsString(int n, int n2) throws NativeException {
        byte[] byArray = Native.GetMemory(n, n2);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            return new String(byArray, 0, i);
        }
        return new String(byArray);
    }

    public static String getMemoryAsString(int n, int n2, boolean bl) throws NativeException {
        if (bl) {
            return new String(Native.GetMemory(n, n2));
        }
        return Native.getMemoryAsString(n, n2);
    }

    public static int getCurrentModule() throws NativeException {
        if (currentModuleHandle == 0) {
            currentModuleHandle = Native.GetCurrentModule();
        }
        if (currentModuleHandle == 0) {
            try {
                currentModuleHandle = Kernel32.LoadLibrary(DLL_NAME).getValue();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return currentModuleHandle;
    }

    public static boolean isFunctionExported(String string, String string2) throws NativeException, InterruptedException {
        String[] stringArray = Native.getDLLFileExports(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] getDLLFileExports(String string, boolean bl) throws NativeException, InterruptedException {
        try {
            HANDLE hANDLE = Kernel32.CreateFile(string, Kernel32.AccessMask.GENERIC_READ, Kernel32.ShareMode.FILE_SHARE_READ, null, Kernel32.CreationDisposition.OPEN_EXISTING, Kernel32.FileAttribute.FILE_ATTRIBUTE_NORMAL, 0);
            if (hANDLE.equals(HANDLE.INVALID_HANDLE_VALUE)) {
                System.err.println(">>>ERROR<<< : " + string + " file not found, CreateFile returned an invalid handle\n");
                return null;
            }
            HANDLE hANDLE2 = Kernel32.CreateFileMapping(hANDLE, null, Kernel32.PageAccess.PAGE_READONLY, new DWORD(0), new DWORD(0), null);
            if (hANDLE2.equals(HANDLE.INVALID_HANDLE_VALUE)) {
                Kernel32.CloseHandle(hANDLE);
                System.err.println(">>>ERROR<<< : CreateFileMapping returned a NULL handle\n");
                return null;
            }
            LONG lONG = Kernel32.MapViewOfFileEx(hANDLE2, Kernel32.FileMap.FILE_MAP_READ, new DWORD(0), new DWORD(0), new DWORD(0), new LONG(0));
            if (lONG.getValue() == 0) {
                Kernel32.CloseHandle(hANDLE2);
                Kernel32.CloseHandle(hANDLE);
                System.err.println(">>>ERROR<<< : MapViewOfFile returned 0\n");
                return null;
            }
            int n = 64;
            int n2 = 16;
            int n3 = 96 + n2 * 2 * 4;
            int n4 = 24 + n3;
            int n5 = 17744;
            int n6 = 40;
            Pointer pointer = new Pointer(new NativeMemoryBlock(lONG.getValue(), n));
            Pointer pointer2 = new Pointer(new NativeMemoryBlock(pointer.getPointer() + pointer.getAsInt(n - 4), n4));
            if (!Kernel32.IsBadReadPtr(pointer2) || pointer2.getAsInt(0) != n5) {
                Kernel32.UnmapViewOfFile(lONG);
                Kernel32.CloseHandle(hANDLE2);
                Kernel32.CloseHandle(hANDLE);
                System.err.println(">>>ERROR<<< : IsBadReadPtr returned false, pointer is " + pointer2.getPointer() + "\n");
                return null;
            }
            System.err.println(">>>INFO<<< : IsBadReadPtr returned true, pointer is " + pointer2.getPointer() + "\n");
            Pointer pointer3 = new Pointer(new NativeMemoryBlock(pointer2.getPointer() + n4 - n3, n3));
            Pointer pointer4 = new Pointer(new NativeMemoryBlock(pointer3.getAsInt(96), 4));
            if (pointer4.isNull()) {
                Kernel32.UnmapViewOfFile(lONG);
                Kernel32.CloseHandle(hANDLE2);
                Kernel32.CloseHandle(hANDLE);
                System.err.println(">>>ERROR<<< : pImg_Export_Dir is NULL\n");
                return null;
            }
            pointer4 = new Pointer(new NativeMemoryBlock(DbgHelp.ImageRvaToVa(pointer2, pointer, pointer4.asLONG(), NullPointer.NULL).getValue(), n6));
            LONG lONG2 = new LONG(pointer4.getAsInt(32));
            if ((lONG2 = DbgHelp.ImageRvaToVa(pointer2, pointer, lONG2, NullPointer.NULL)).getValue() == 0) {
                Kernel32.UnmapViewOfFile(lONG);
                Kernel32.CloseHandle(hANDLE2);
                Kernel32.CloseHandle(hANDLE);
                System.err.println(">>>ERROR<<< : ImageRvaToVa returned NULL\n");
                return null;
            }
            int n7 = pointer4.getAsInt(24);
            String[] stringArray = new String[n7];
            System.err.println("pszFunctions = " + stringArray.length + "\n");
            int n8 = 0;
            int n9 = lONG2.getValue();
            while (n8 < n7) {
                System.err.println("ippdwNames[" + n8 + "] : " + n9);
                LONG lONG3 = DbgHelp.ImageRvaToVa(pointer2, pointer, new LONG(new Pointer(new NativeMemoryBlock(n9, 4)).getAsInt(0)), NullPointer.NULL);
                stringArray[n8] = new Pointer(new NativeMemoryBlock(lONG3.getValue(), 1000)).getAsString().trim();
                System.err.println(stringArray[n8] + "\n");
                ++n8;
                n9 += 4;
            }
            Kernel32.UnmapViewOfFile(lONG);
            Kernel32.CloseHandle(hANDLE2);
            Kernel32.CloseHandle(hANDLE);
            return stringArray;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    public static void copyMemory(Pointer pointer, Pointer pointer2) throws NativeException {
        if (pointer2 == null || pointer == null || pointer.getSize() == 0 || pointer2.getSize() == 0) {
            return;
        }
        if (pointer2.getSize() >= pointer.getSize()) {
            pointer2.setMemory(pointer.getMemory());
        } else {
            pointer2.setMemory(Native.getMemory(pointer.getPointer(), pointer2.getSize()));
        }
    }

    public static String[] getDLLFileExports(String string) throws NativeException, InterruptedException {
        return Native.getDLLFileExports(string, false);
    }

    public static int callback(int n, long[] lArray) {
        Callback callback = (Callback)mCallbacks.get(new Integer(n));
        if (callback != null) {
            return callback.callback(lArray);
        }
        return -1;
    }

    public static int createCallback(int n, Callback callback) throws NativeException {
        if ("1.5".compareTo(System.getProperty("java.version")) > 0) {
            throw new Error("Invalid Java Version.");
        }
        int n2 = Native.CreateCallBack(n);
        mCallbacks.put(new Integer(n2), callback);
        return n2;
    }

    public static boolean releaseCallback(Callback callback) throws NativeException {
        boolean bl = false;
        if (null != mCallbacks.remove(new Integer(callback.getCallbackAddress()))) {
            bl = Native.ReleaseCallBack(callback.getCallbackAddress());
        }
        return bl;
    }

    public static int registerWindowProc(int n, WindowProc windowProc) throws NativeException {
        return Native.RegisterWindowProc(n, windowProc);
    }

    public static int registerWindowProc(HWND hWND, WindowProc windowProc) throws NativeException {
        return Native.RegisterWindowProc(hWND.getValue(), windowProc);
    }

    public static String toString(byte[] byArray) {
        return Native.toString(byArray, System.getProperty("jna.encoding"));
    }

    public static String toString(byte[] byArray, String string) {
        int n;
        String string2 = null;
        if (string != null) {
            try {
                string2 = new String(byArray, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (string2 == null) {
            string2 = new String(byArray);
        }
        if ((n = string2.indexOf(0)) != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public static String toString(char[] cArray) {
        String string = new String(cArray);
        int n = string.indexOf(0);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = string3.indexOf(string)) == -1) break;
            stringBuffer.append(string3.substring(0, n));
            stringBuffer.append(string2);
            string3 = string3.substring(n + string.length());
        }
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    static native int Sizeof(int var0);

    private native int LoadLibrary(String var1, String var2) throws NativeException;

    private native int FindFunction(int var1, String var2) throws NativeException;

    private native void Invoke(int var1) throws NativeException;

    private native void Dispose(int var1) throws NativeException;

    private static native int Malloc(int var0) throws NativeException;

    private static native void Free(int var0) throws NativeException;

    private static native void SetMemory(int var0, byte[] var1, int var2, int var3) throws NativeException;

    private static native byte[] GetMemory(int var0, int var1) throws NativeException;

    private static native int GetCurrentModule() throws NativeException;

    private static native int CreateCallBack(int var0) throws NativeException;

    private static native boolean ReleaseCallBack(int var0) throws NativeException;

    private static native int RegisterWindowProc(int var0, Object var1) throws NativeException;

    static {
        Extension.loadNativeLibrary("swt-extension-jna-win32");
        mLibs = new HashMap();
        mCallbacks = new TreeMap();
        POINTER_SIZE = Native.Sizeof(0);
        LONG_SIZE = Native.Sizeof(1);
        WCHAR_SIZE = Native.Sizeof(2);
        SIZE_T_SIZE = Native.Sizeof(3);
    }
}

