/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.datatype;

import org.sf.feeling.swt.win32.extension.jna.datatype.BasicData;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;

public abstract class AbstractBasicData
implements BasicData {
    protected Object mValue;
    protected Pointer pointer;
    protected int offset;

    protected byte getNextByte() throws NativeException {
        return this.pointer.getAsByte(this.offset++);
    }

    protected void setNextByte(byte by) throws NativeException {
        this.pointer.setByteAt(this.offset++, by);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected short getNextShort() throws NativeException {
        try {
            short s = this.pointer.getAsShort(this.offset);
            return s;
        }
        finally {
            this.offset += 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNextShort(short s) throws NativeException {
        try {
            this.pointer.setShortAt(this.offset, s);
        }
        finally {
            this.offset += 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextInt() throws NativeException {
        try {
            int n = this.pointer.getAsInt(this.offset);
            return n;
        }
        finally {
            this.offset += 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNextInt(int n) throws NativeException {
        try {
            this.pointer.setIntAt(this.offset, n);
        }
        finally {
            this.offset += 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNextLong() throws NativeException {
        try {
            long l = this.pointer.getAsLong(this.offset);
            return l;
        }
        finally {
            this.offset += 8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNextLong(long l) throws NativeException {
        try {
            this.pointer.setLongAt(this.offset, l);
        }
        finally {
            this.offset += 8;
        }
    }

    public Pointer getPointer() {
        return this.pointer;
    }

    protected AbstractBasicData(Object object) {
        this.mValue = object;
    }

    public String getValueAsString() {
        if (this.mValue == null) {
            return null;
        }
        return this.mValue.toString();
    }

    public String toString() {
        if (this.mValue == null) {
            return "NULL";
        }
        return this.mValue.toString();
    }
}

