/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.internal.extension;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class LibraryLoader {
    private static HashMap nativeLibraryPath = new HashMap();
    static final Object finalizer = new Object(){

        protected void finalize() {
            LibraryLoader.deleteNativeLibraries();
        }
    };

    private static boolean deleteNativeLibrary(String string) {
        boolean bl = false;
        Object v = nativeLibraryPath.get(string);
        if (Boolean.TRUE.equals(v)) {
            bl = true;
        }
        if (string == null || !bl) {
            return true;
        }
        File file = new File(string);
        if (file.delete()) {
            nativeLibraryPath.remove(string);
            return true;
        }
        try {
            ClassLoader classLoader = LibraryLoader.class.getClassLoader();
            Field field = ClassLoader.class.getDeclaredField("nativeLibraries");
            field.setAccessible(true);
            List list = (List)field.get(classLoader);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                field = e.getClass().getDeclaredField("name");
                field.setAccessible(true);
                String string2 = (String)field.get(e);
                if (!string2.equals(string) && string2.indexOf(string) == -1 && !string2.equals(file.getCanonicalPath())) continue;
                Method method = e.getClass().getDeclaredMethod("finalize", new Class[0]);
                method.setAccessible(true);
                method.invoke(e, new Object[0]);
                if (bl && file.exists()) {
                    if (file.delete()) {
                        nativeLibraryPath.remove(string);
                        bl = false;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static void deleteNativeLibraries() {
        String[] stringArray = nativeLibraryPath.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            LibraryLoader.deleteNativeLibrary(stringArray[i]);
        }
    }

    private LibraryLoader() {
    }

    static void loadNativeLibrary(String string) {
        String string2 = System.getProperty("java.library.path");
        if (string2 != null) {
            String[] stringArray = string2.split(File.pathSeparator);
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(new File(stringArray[i]), System.mapLibraryName(string));
                if (!file.exists()) continue;
                try {
                    String string3 = file.getAbsolutePath();
                    System.load(string3);
                    System.out.println(string3);
                    nativeLibraryPath.put(string3, Boolean.FALSE);
                    return;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
            }
        }
        try {
            System.loadLibrary(string);
            nativeLibraryPath.put(string, Boolean.FALSE);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            LibraryLoader.loadNativeLibraryFromJar(string);
        }
    }

    private static void loadNativeLibraryFromJar(String string) {
        String string2;
        URL uRL = LibraryLoader.class.getResource(string2 = "/" + string + ".dll");
        if (uRL == null) {
            throw new UnsatisfiedLinkError(string + " (" + string2 + ") not found in resource path");
        }
        File file = null;
        if (uRL.getProtocol().toLowerCase().equals("file")) {
            try {
                file = new File(new URI(uRL.toString()));
            }
            catch (URISyntaxException uRISyntaxException) {
                file = new File(uRL.getPath());
            }
            if (!file.exists()) {
                throw new Error("File URL " + uRL + " could not be properly decoded");
            }
        } else {
            InputStream inputStream = LibraryLoader.class.getResourceAsStream(string2);
            if (inputStream == null) {
                throw new Error("Can't obtain " + string + " InputStream");
            }
            FileOutputStream fileOutputStream = null;
            try {
                int n;
                String string3 = "java.io.tmpdir";
                String string4 = System.getProperty(string3);
                file = new File(string4, string + System.currentTimeMillis() + ".dll");
                file.createNewFile();
                file.deleteOnExit();
                ClassLoader classLoader = LibraryLoader.class.getClassLoader();
                if (classLoader == null || classLoader.equals(ClassLoader.getSystemClassLoader())) {
                    Runtime.getRuntime().addShutdownHook(new DeleteNativeLibrary(file));
                }
                fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                throw new Error("Failed to create temporary file for " + string + " library: " + iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        System.load(file.getAbsolutePath());
        nativeLibraryPath.put(file.getAbsolutePath(), Boolean.TRUE);
    }

    public static class DeleteNativeLibrary
    extends Thread {
        private final File file;

        public DeleteNativeLibrary(File file) {
            this.file = file;
        }

        public void run() {
            if (!LibraryLoader.deleteNativeLibrary(this.file.getAbsolutePath())) {
                try {
                    Runtime.getRuntime().exec(new String[]{System.getProperty("java.home") + "/bin/java", "-cp", System.getProperty("java.class.path"), this.getClass().getName(), this.file.getAbsolutePath()});
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }

        public static void main(String[] stringArray) {
            File file;
            if (stringArray.length == 1 && (file = new File(stringArray[0])).exists()) {
                long l = System.currentTimeMillis();
                while (!file.delete() && file.exists()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() - l <= 5000L) continue;
                    System.err.println("Could not remove temp file: " + file.getAbsolutePath());
                    break;
                }
            }
            System.exit(0);
        }
    }
}

