/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.internal.extension.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tracker;
import org.sf.feeling.swt.win32.internal.extension.widgets.BorderCanvas;

public class MouseResizeListener
implements Listener,
DisposeListener {
    private Shell shell;
    private BorderCanvas border;
    private int borderType;
    private Point point = new Point(-1, -1);
    private boolean resizable;
    private boolean valid;
    private Tracker tracker;

    public MouseResizeListener(int n, BorderCanvas borderCanvas, boolean bl) {
        this.borderType = n;
        this.border = borderCanvas;
        this.resizable = bl;
        this.valid = false;
        this.shell = borderCanvas.getShell();
    }

    public void handleEvent(Event event) {
        if (!this.resizable) {
            return;
        }
        if (!this.shell.getMaximized()) {
            block0 : switch (event.type) {
                case 3: {
                    if (!this.valid) break;
                    this.point.x = event.x;
                    this.point.y = event.y;
                    int n = 16;
                    switch (this.borderType) {
                        case 1: {
                            n |= 0x80;
                            break;
                        }
                        case 6: {
                            n |= 0x400;
                            break;
                        }
                        case 3: {
                            n |= 0x4000;
                            break;
                        }
                        case 4: {
                            n |= 0x20000;
                            break;
                        }
                        case 0: {
                            n |= 0x4080;
                            break;
                        }
                        case 7: {
                            n |= 0x20400;
                            break;
                        }
                        case 2: {
                            n |= 0x20080;
                            break;
                        }
                        case 5: {
                            n |= 0x4400;
                            break;
                        }
                    }
                    this.tracker = new Tracker(this.border.getDisplay(), n);
                    this.tracker.setStippled(true);
                    this.tracker.setRectangles(new Rectangle[]{this.shell.getBounds()});
                    this.tracker.addDisposeListener((DisposeListener)this);
                    this.tracker.open();
                    this.tracker.dispose();
                    this.tracker = null;
                    break;
                }
                case 5: {
                    this.valid = false;
                    if (this.point.x < 0 && this.point.y < 0) {
                        int n = 5;
                        Rectangle rectangle = this.border.getBounds();
                        switch (this.borderType) {
                            case 1: {
                                if (event.y >= 0 && event.y <= n) {
                                    this.border.setCursor(this.border.getDisplay().getSystemCursor(7));
                                    this.valid = true;
                                    break block0;
                                }
                                this.border.setCursor(this.border.getDisplay().getSystemCursor(0));
                                break block0;
                            }
                            case 6: {
                                if (event.y >= rectangle.height - n && event.y <= rectangle.height) {
                                    this.border.setCursor(this.border.getDisplay().getSystemCursor(7));
                                    this.valid = true;
                                    break block0;
                                }
                                this.border.setCursor(this.border.getDisplay().getSystemCursor(0));
                                break block0;
                            }
                            case 3: {
                                if (event.x >= 0 && event.x <= n) {
                                    this.border.setCursor(this.border.getDisplay().getSystemCursor(9));
                                    this.valid = true;
                                    break block0;
                                }
                                this.border.setCursor(this.border.getDisplay().getSystemCursor(0));
                                break block0;
                            }
                            case 4: {
                                if (event.x >= rectangle.width - n && event.x <= rectangle.width) {
                                    this.border.setCursor(this.border.getDisplay().getSystemCursor(9));
                                    this.valid = true;
                                    break block0;
                                }
                                this.border.setCursor(this.border.getDisplay().getSystemCursor(0));
                                break block0;
                            }
                            case 0: {
                                if (event.x <= n && event.x >= 0 && event.y <= n && event.y >= 0) {
                                    this.border.setCursor(this.border.getDisplay().getSystemCursor(8));
                                    this.valid = true;
                                    break block0;
                                }
                                this.border.setCursor(this.border.getDisplay().getSystemCursor(0));
                                break block0;
                            }
                            case 7: {
                                if (event.x <= rectangle.width && event.x >= rectangle.width - n && event.y <= rectangle.height && event.y >= rectangle.height - n) {
                                    this.border.setCursor(this.border.getDisplay().getSystemCursor(8));
                                    this.valid = true;
                                    break block0;
                                }
                                this.border.setCursor(this.border.getDisplay().getSystemCursor(0));
                                break block0;
                            }
                            case 2: {
                                if (event.x <= rectangle.width && event.x >= rectangle.width - n && event.y <= n && event.y >= 0) {
                                    this.border.setCursor(this.border.getDisplay().getSystemCursor(6));
                                    this.valid = true;
                                    break block0;
                                }
                                this.border.setCursor(this.border.getDisplay().getSystemCursor(0));
                                break block0;
                            }
                            case 5: {
                                if (event.x <= n && event.x >= 0 && event.y <= rectangle.height && event.y >= rectangle.height - n) {
                                    this.border.setCursor(this.border.getDisplay().getSystemCursor(6));
                                    this.valid = true;
                                    break block0;
                                }
                                this.border.setCursor(this.border.getDisplay().getSystemCursor(0));
                                break block0;
                            }
                        }
                        this.border.setCursor(this.border.getDisplay().getSystemCursor(0));
                        break;
                    }
                    this.border.setCursor(this.border.getDisplay().getSystemCursor(0));
                    break;
                }
                case 7: {
                    this.valid = false;
                    this.border.setCursor(this.border.getDisplay().getSystemCursor(0));
                    break;
                }
                default: {
                    this.valid = false;
                }
            }
        }
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.valid = false;
        this.shell.setBounds(this.tracker.getRectangles()[0]);
        this.point.x = -1;
        this.point.y = -1;
    }
}

