/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.internal.extension.widgets;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.sf.feeling.swt.win32.extension.widgets.MenuBar;
import org.sf.feeling.swt.win32.extension.widgets.Separator;
import org.sf.feeling.swt.win32.internal.extension.widgets.BorderCanvas;
import org.sf.feeling.swt.win32.internal.extension.widgets.ClientAreaCanvas;
import org.sf.feeling.swt.win32.internal.extension.widgets.IContainer;
import org.sf.feeling.swt.win32.internal.extension.widgets.ISkinable;

public abstract class SkinableWidget
implements IContainer {
    private Composite composite;
    private ClientAreaCanvas clientArea;
    private HashMap borders;
    protected MenuBar menubar;
    protected Separator separator;
    private boolean showTopseperator = true;

    public SkinableWidget(Composite composite, int n) {
        this.createWidget(composite, n);
    }

    protected SkinableWidget() {
    }

    public ISkinable getSkin(int n) {
        return ((BorderCanvas)((Object)this.borders.get(new Integer(n)))).getDrawable();
    }

    public void setSkin(int n, ISkinable iSkinable) {
        ((BorderCanvas)((Object)this.borders.get(new Integer(n)))).setDrawable(iSkinable);
        Event event = new Event();
        event.type = 9;
        ((BorderCanvas)((Object)this.borders.get(new Integer(n)))).updateSkin(event);
    }

    public ISkinable getSkin() {
        return this.clientArea.getDrawable();
    }

    public void setSkin(ISkinable iSkinable) {
        this.clientArea.setDrawable(iSkinable);
    }

    protected abstract Composite createContents(Composite var1, int var2);

    protected Canvas getBorder(int n) {
        return (Canvas)this.borders.get(new Integer(n));
    }

    protected Composite getClientArea() {
        return this.clientArea;
    }

    protected void createWidget(Composite composite, int n) {
        this.composite = this.createContents(composite, n);
        if (this.composite == null) {
            throw new IllegalArgumentException("Can not create contents, null value found.");
        }
        this.createLayout(this.composite);
        this.clientArea = this.createBordersAndCilentArea(this.composite);
        if (this.clientArea == null) {
            throw new IllegalArgumentException("Can not create client area, null value found.");
        }
        this.applyEvents(this.composite);
    }

    private void createLayout(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setBackgroundMode(1);
    }

    private ClientAreaCanvas createBordersAndCilentArea(Composite composite) {
        this.borders = new HashMap(8);
        Composite composite2 = new Composite(composite, 0);
        this.borders.put(new Integer(0), new BorderCanvas(composite2, 0));
        this.borders.put(new Integer(1), new BorderCanvas(composite2, 1));
        this.borders.put(new Integer(2), new BorderCanvas(composite2, 2));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setBackgroundMode(1);
        this.borders.put(new Integer(3), new BorderCanvas(composite, 3));
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setBackgroundMode(1);
        this.menubar = new MenuBar(composite3, 0);
        gridData = new GridData(768);
        gridData.exclude = true;
        this.menubar.getControl().setLayoutData((Object)gridData);
        this.separator = new Separator(composite3, 260);
        gridData = new GridData(768);
        gridData.exclude = !this.showTopSeperator();
        this.separator.setLayoutData(gridData);
        ClientAreaCanvas clientAreaCanvas = new ClientAreaCanvas(composite3);
        clientAreaCanvas.setLayoutData(new GridData(4, 4, true, true));
        this.borders.put(new Integer(4), new BorderCanvas(composite, 4));
        Composite composite4 = new Composite(composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        composite4.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite4.setLayout((Layout)gridLayout);
        composite4.setBackgroundMode(1);
        this.borders.put(new Integer(5), new BorderCanvas(composite4, 5));
        this.borders.put(new Integer(6), new BorderCanvas(composite4, 6));
        this.borders.put(new Integer(7), new BorderCanvas(composite4, 7));
        return clientAreaCanvas;
    }

    private void applyEvents(Composite composite) {
        InternalListener internalListener = new InternalListener();
        composite.addListener(26, (Listener)internalListener);
        composite.addListener(27, (Listener)internalListener);
        composite.addListener(6, (Listener)internalListener);
        composite.addListener(7, (Listener)internalListener);
        composite.addListener(3, (Listener)internalListener);
        composite.addListener(4, (Listener)internalListener);
    }

    public void setShowTopseperator(boolean bl) {
        this.showTopseperator = bl;
    }

    protected boolean showTopSeperator() {
        return this.showTopseperator;
    }

    private class InternalListener
    implements Listener {
        private InternalListener() {
        }

        public void handleEvent(Event event) {
            Iterator iterator = SkinableWidget.this.borders.values().iterator();
            while (iterator.hasNext()) {
                BorderCanvas borderCanvas = (BorderCanvas)((Object)iterator.next());
                if (borderCanvas.isDisposed()) continue;
                borderCanvas.updateSkin(event);
            }
            if (!SkinableWidget.this.clientArea.isDisposed()) {
                SkinableWidget.this.clientArea.updateSkin(event);
            }
        }
    }
}

