/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.internal.extension.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.MINMAXINFO;
import org.sf.feeling.swt.win32.extension.shell.Windows;
import org.sf.feeling.swt.win32.extension.widgets.Window;
import org.sf.feeling.swt.win32.internal.extension.Extension;
import org.sf.feeling.swt.win32.internal.extension.Extension2;
import org.sf.feeling.swt.win32.internal.extension.callback.WNDCallback;
import org.sf.feeling.swt.win32.internal.extension.callback.WNDCallbackManager;

public class WindowResizeHook {
    private int oldAddress;
    private Window window;
    private Callback windowResizeCallback;
    private int newAddress;
    private WNDCallback callback;

    public WindowResizeHook(Window window) {
        this.window = window;
        window.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                WindowResizeHook.this.unInstallHook();
            }
        });
    }

    public void installHook() {
        if (this.callback == null) {
            this.windowResizeCallback = new Callback((Object)this, "WindowResizeProc", 4);
            this.newAddress = this.windowResizeCallback.getAddress();
            this.oldAddress = Extension2.SetWindowLongPtr(this.window.getShell().handle, -4, this.newAddress);
            this.callback = new WNDCallback(this.window.getShell(), this.oldAddress, this.newAddress){

                public void dispose() {
                    WindowResizeHook.this.disposeCallback();
                }
            };
            WNDCallbackManager.addCallback(this.window.getShell(), this.callback);
        }
    }

    public void unInstallHook() {
        if (this.callback != null) {
            WNDCallbackManager.disposeCallback(this.window.getShell(), this.callback);
        }
    }

    private void disposeCallback() {
        if (this.callback != null) {
            Extension2.SetWindowLongPtr(this.window.getShell().handle, -4, this.callback.getOldAddress());
            this.windowResizeCallback.dispose();
            this.windowResizeCallback = null;
            this.newAddress = 0;
            this.callback = null;
        }
    }

    int WindowResizeProc(int n, int n2, int n3, int n4) {
        if (n2 == 36 && this.window.isThemeInstalled()) {
            Rectangle rectangle = this.window.getShell().getDisplay().getPrimaryMonitor().getBounds();
            MINMAXINFO mINMAXINFO = new MINMAXINFO();
            Extension.MoveMemory((MINMAXINFO)mINMAXINFO, (int)n4, (int)MINMAXINFO.sizeof);
            if (mINMAXINFO.ptMaxSize_x > 0 && mINMAXINFO.ptMaxSize_y > 0) {
                Rectangle rectangle2 = Windows.getWindowRect(Windows.getSystemTray());
                if (rectangle2.x <= 0) {
                    if (rectangle2.y <= 0) {
                        if (rectangle2.width >= rectangle.width) {
                            mINMAXINFO.ptMaxPosition_y = rectangle2.y + rectangle2.height;
                            mINMAXINFO.ptMaxSize_y = rectangle.height - mINMAXINFO.ptMaxPosition_y;
                            mINMAXINFO.ptMaxPosition_x = 0;
                            mINMAXINFO.ptMaxSize_x = rectangle.width;
                        } else {
                            mINMAXINFO.ptMaxPosition_x = rectangle2.width + rectangle2.x;
                            mINMAXINFO.ptMaxSize_x = rectangle.width - (rectangle2.width + rectangle2.x);
                            mINMAXINFO.ptMaxPosition_y = 0;
                            mINMAXINFO.ptMaxSize_y = rectangle.height;
                        }
                    } else {
                        mINMAXINFO.ptMaxPosition_x = 0;
                        mINMAXINFO.ptMaxSize_x = rectangle.width;
                        mINMAXINFO.ptMaxPosition_y = 0;
                        mINMAXINFO.ptMaxSize_y = rectangle2.y;
                    }
                } else if (rectangle2.x > 0) {
                    mINMAXINFO.ptMaxPosition_x = 0;
                    mINMAXINFO.ptMaxSize_x = rectangle2.x;
                    mINMAXINFO.ptMaxPosition_y = 0;
                    mINMAXINFO.ptMaxSize_y = rectangle.height;
                }
                Extension.MoveMemory((int)n4, (MINMAXINFO)mINMAXINFO, (int)MINMAXINFO.sizeof);
            }
        }
        if (n2 == 295 && this.window.isThemeInstalled() && this.window.getShell().getMaximized()) {
            this.window.getShell().setMaximized(true);
        }
        return Extension.CallWindowProc((int)this.oldAddress, (int)n, (int)n2, (int)n3, (int)n4);
    }
}

