/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

public final class ZipLong
implements Cloneable {
    private long value;

    public ZipLong(long l) {
        this.value = l;
    }

    public ZipLong(byte[] byArray) {
        this(byArray, 0);
    }

    public ZipLong(byte[] byArray, int n) {
        this.value = ZipLong.getValue(byArray, n);
    }

    public byte[] getBytes() {
        return ZipLong.getBytes(this.value);
    }

    public long getValue() {
        return this.value;
    }

    public static byte[] getBytes(long l) {
        byte[] byArray = new byte[]{(byte)(l & 0xFFL), (byte)((l & 0xFF00L) >> 8), (byte)((l & 0xFF0000L) >> 16), (byte)((l & 0xFF000000L) >> 24)};
        return byArray;
    }

    public static long getValue(byte[] byArray, int n) {
        long l = (long)(byArray[n + 3] << 24) & 0xFF000000L;
        l += (long)(byArray[n + 2] << 16 & 0xFF0000);
        l += (long)(byArray[n + 1] << 8 & 0xFF00);
        return l += (long)(byArray[n] & 0xFF);
    }

    public static long getValue(byte[] byArray) {
        return ZipLong.getValue(byArray, 0);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ZipLong)) {
            return false;
        }
        return this.value == ((ZipLong)object).getValue();
    }

    public int hashCode() {
        return (int)this.value;
    }
}

