/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.sanguo.patch.page;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.tools.zip.ZipFileInfo;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.sf.feeling.sanguo.patch.Patch;
import org.sf.feeling.sanguo.patch.page.SimpleTabPage;
import org.sf.feeling.sanguo.patch.util.BakUtil;
import org.sf.feeling.sanguo.patch.widget.WidgetUtil;

public class BakAndRestorePage
extends SimpleTabPage
implements Listener {
    private String date;
    private TableViewer bakFileTable;
    private boolean IO_WAIT = false;
    private Button restoreButton;
    private Button applyRestoreButton;
    private Button initBakButton;
    private Button initApplyBakButton;
    private Button restoreBakButton;
    private Button applyRestoreBakButton;

    public void buildUI(Composite composite) {
        super.buildUI(composite);
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.leftMargin = 10;
        tableWrapLayout.rightMargin = 10;
        tableWrapLayout.topMargin = 15;
        tableWrapLayout.verticalSpacing = 20;
        this.container.getBody().setLayout(tableWrapLayout);
        this.initTime();
        this.createTitle();
        this.createPatchArea();
        FormText formText = WidgetUtil.createFormText(this.container.getBody(), "\u6ce8\u610f\uff1a\u5982\u679c\u8fd8\u539f\u5907\u4efd\u6587\u4ef6\u540e\u8fdb\u5165\u6e38\u620f\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u5c1d\u8bd5\u6362\u4e00\u4e2a\u7248\u672c\u8fd8\u539f\u3002\u82e5\u662f\u4f7f\u7528\u539f\u59cb\u6863\u8fd8\u539f\u5e76\u5bfc\u81f4\u8fdb\u5165\u6e38\u620f\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u518d\u6b21\u4f7f\u7528\u539f\u59cb\u6863\u8fd8\u539f\u3002");
        TableWrapData tableWrapData = new TableWrapData(128);
        tableWrapData.maxWidth = 600;
        formText.setLayoutData(tableWrapData);
    }

    private void initTime() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Etc/GMT-8"), Locale.CHINA);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        simpleDateFormat.setCalendar(calendar);
        this.date = simpleDateFormat.format(calendar.getTime());
    }

    private void createPatchArea() {
        Widget widget;
        Section section = WidgetUtil.getToolkit().createSection(this.container.getBody(), 64);
        TableWrapData tableWrapData = new TableWrapData(128);
        section.setLayoutData(tableWrapData);
        section.setText("\u5907\u4efd\u6e38\u620f\u6570\u636e");
        WidgetUtil.getToolkit().createCompositeSeparator(section);
        Composite composite = WidgetUtil.getToolkit().createComposite(section, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout(gridLayout);
        section.setClient(composite);
        this.initBakButton = WidgetUtil.getToolkit().createButton(composite, "\u8bbe\u7f6e\u5f53\u524d\u6e38\u620f\u6570\u636e\u4f5c\u4e3a\u539f\u59cb\u5907\u4efd\u6863\uff08\u8bf7\u52a1\u5fc5\u4fdd\u8bc1\u5f53\u524d\u6e38\u620f\u6570\u636e\u65e0\u5f02\u5e38\u72b6\u6001\uff09", 32);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.initBakButton.setLayoutData(gridData);
        this.initApplyBakButton = WidgetUtil.getToolkit().createButton(composite, 8, true);
        this.initApplyBakButton.setText("\u8bbe\u7f6e");
        this.initApplyBakButton.setEnabled(false);
        this.initBakButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BakAndRestorePage.this.checkButtonStatus();
            }
        });
        this.initApplyBakButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BakAndRestorePage.this.IO_WAIT = true;
                BakAndRestorePage.this.initApplyBakButton.setEnabled(false);
                BakUtil.bakToDefaultData(BakAndRestorePage.this);
            }
        });
        final Button button = WidgetUtil.getToolkit().createButton(composite, "\u5907\u4efd\u5f53\u524d\u6e38\u620f\u6570\u636e", 32);
        final Text text = WidgetUtil.getToolkit().createText(composite, "\u8bf7\u8f93\u5165\u5907\u4efd\u63cf\u8ff0", 0);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        text.setLayoutData(gridData);
        text.setEnabled(false);
        final Button button2 = WidgetUtil.getToolkit().createButton(composite, 8, true);
        button2.setText("\u5907\u4efd");
        button2.setEnabled(false);
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BakUtil.bakData(text.getText().trim());
                BakAndRestorePage.this.bakFileTable.refresh();
            }
        });
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                text.setEnabled(button.getSelection());
                button2.setEnabled(button.getSelection());
            }
        });
        final Button button3 = WidgetUtil.getToolkit().createButton(composite, "\u5220\u9664\u5168\u90e8\u5386\u53f2\u5907\u4efd\u8bb0\u5f55\uff08\u4e0d\u5305\u542b\u539f\u59cb\u6863\uff09", 32);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        gridData.horizontalSpan = 2;
        button3.setLayoutData(gridData);
        final Button button4 = WidgetUtil.getToolkit().createButton(composite, 8, true);
        button4.setText("\u5220\u9664");
        button4.setEnabled(false);
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                button4.setEnabled(button3.getSelection());
            }
        });
        button4.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object;
                int n;
                Object object2;
                File file = new File(BakUtil.bakFolderPath);
                if (file.exists() && file.isDirectory() && (object2 = file.listFiles()) != null) {
                    for (n = 0; n < ((File[])object2).length; ++n) {
                        object = object2[n];
                        if (!((File)object).isFile() || ((File)object).getAbsolutePath().equals(BakUtil.defalutBakFilePath)) continue;
                        ((File)object).delete();
                    }
                }
                if ((file = new File(BakUtil.bakIncreaseFolderPath)).exists() && file.isDirectory() && (object2 = file.listFiles()) != null) {
                    for (n = 0; n < ((File[])object2).length; ++n) {
                        object = object2[n];
                        if (!((File)object).isFile() || ((File)object).getAbsolutePath().equals(BakUtil.defalutResourceBakFilePath)) continue;
                        ((File)object).delete();
                    }
                }
                if (((File)(object2 = new File(BakUtil.patchFolderPath + "\\bak.properties"))).exists()) {
                    ((File)object2).delete();
                }
                BakAndRestorePage.this.refreshTable();
            }
        });
        this.restoreButton = WidgetUtil.getToolkit().createButton(composite, "\u8fd8\u539f\u6e38\u620f\u6570\u636e\u81f3\u539f\u59cb\u6863\u72b6\u6001\uff08\u89c6\u673a\u5668\u6027\u80fd\u4e0d\u540c\uff0c\u53ef\u80fd\u9700\u8981\u7b49\u5f85\u51e0\u5206\u949f\uff09", 32);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        gridData.horizontalSpan = 2;
        this.restoreButton.setLayoutData(gridData);
        this.applyRestoreButton = WidgetUtil.getToolkit().createButton(composite, 8, true);
        this.applyRestoreButton.setText("\u8fd8\u539f");
        this.applyRestoreButton.setEnabled(false);
        this.restoreButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BakAndRestorePage.this.checkButtonStatus();
            }
        });
        this.applyRestoreButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BakAndRestorePage.this.IO_WAIT = true;
                BakAndRestorePage.this.applyRestoreButton.setEnabled(false);
                BakUtil.restoreDefaultBakFile(BakAndRestorePage.this);
            }
        });
        Section section2 = WidgetUtil.getToolkit().createSection(this.container.getBody(), 64);
        tableWrapData = new TableWrapData(128);
        section2.setLayoutData(tableWrapData);
        section2.setText("\u8fd8\u539f\u5907\u4efd\u6570\u636e");
        WidgetUtil.getToolkit().createCompositeSeparator(section2);
        Composite composite2 = WidgetUtil.getToolkit().createComposite(section2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout(gridLayout);
        final DateTime dateTime = new DateTime(composite2, 1024);
        dateTime.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BakAndRestorePage.this.date = new String();
                BakAndRestorePage.this.date = BakAndRestorePage.this.date + String.valueOf(dateTime.getYear());
                if (dateTime.getMonth() < 9) {
                    BakAndRestorePage.this.date = BakAndRestorePage.this.date + ("0" + (dateTime.getMonth() + 1));
                } else {
                    BakAndRestorePage.this.date = BakAndRestorePage.this.date + String.valueOf(dateTime.getMonth() + 1);
                }
                if (dateTime.getDay() < 10) {
                    BakAndRestorePage.this.date = BakAndRestorePage.this.date + ("0" + dateTime.getDay());
                } else {
                    BakAndRestorePage.this.date = BakAndRestorePage.this.date + String.valueOf(dateTime.getDay());
                }
                BakAndRestorePage.this.refreshTable();
            }
        });
        Table table = WidgetUtil.getToolkit().createTable(composite2, 66304);
        this.bakFileTable = new TableViewer(table);
        table.setLinesVisible(false);
        table.setHeaderVisible(true);
        this.bakFileTable.setContentProvider((IContentProvider)new TableContentProvider());
        this.bakFileTable.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        String[] stringArray = new String[]{"\u5907\u4efd\u65f6\u95f4", "\u63cf\u8ff0"};
        int[] nArray = new int[]{90, 200};
        for (int i = 0; i < stringArray.length; ++i) {
            widget = new TableColumn(this.bakFileTable.getTable(), 16384);
            ((TableColumn)widget).setResizable(stringArray[i] != null);
            if (stringArray[i] != null) {
                ((TableColumn)widget).setText(stringArray[i]);
            }
            ((TableColumn)widget).setWidth(nArray[i]);
        }
        this.bakFileTable.setColumnProperties(stringArray);
        gridData = new GridData(1808);
        gridData.heightHint = 100;
        table.setLayoutData(gridData);
        this.bakFileTable.setInput((Object)new File(BakUtil.bakFolderPath));
        Composite composite3 = WidgetUtil.getToolkit().createComposite(composite2);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite3.setLayoutData(gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout(gridLayout);
        this.restoreBakButton = WidgetUtil.getToolkit().createButton(composite3, "\u4f7f\u7528\u9009\u4e2d\u5907\u4efd\u6587\u4ef6\u8fd8\u539f", 32);
        gridData = new GridData();
        gridData.widthHint = 300;
        this.restoreBakButton.setLayoutData(gridData);
        this.applyRestoreBakButton = WidgetUtil.getToolkit().createButton(composite3, 8, true);
        this.applyRestoreBakButton.setText("\u8fd8\u539f");
        this.applyRestoreBakButton.setEnabled(false);
        this.applyRestoreBakButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                File file;
                StructuredSelection structuredSelection;
                if (BakAndRestorePage.this.bakFileTable.getSelection() instanceof StructuredSelection && !(structuredSelection = (StructuredSelection)BakAndRestorePage.this.bakFileTable.getSelection()).isEmpty() && structuredSelection.getFirstElement() instanceof File && (file = (File)structuredSelection.getFirstElement()).exists()) {
                    BakAndRestorePage.this.IO_WAIT = true;
                    BakAndRestorePage.this.applyRestoreBakButton.setEnabled(false);
                    BakUtil.restoreBakFile(file, BakAndRestorePage.this);
                }
            }
        });
        this.restoreBakButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BakAndRestorePage.this.applyRestoreBakButton.setEnabled(BakAndRestorePage.this.restoreBakButton.getSelection());
            }
        });
        widget = WidgetUtil.getToolkit().createButton(composite3, "\u5220\u9664\u9009\u4e2d\u5907\u4efd\u6587\u4ef6", 32);
        gridData = new GridData();
        gridData.widthHint = 300;
        ((Control)widget).setLayoutData(gridData);
        final Button button5 = WidgetUtil.getToolkit().createButton(composite3, 8, true);
        button5.setText("\u5220\u9664");
        button5.setEnabled(false);
        ((Button)widget).addSelectionListener(new SelectionAdapter((Button)widget){
            private final /* synthetic */ Button val$deleteBakButton;
            {
                this.val$deleteBakButton = button2;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                button5.setEnabled(this.val$deleteBakButton.getSelection());
            }
        });
        button5.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StructuredSelection structuredSelection;
                if (BakAndRestorePage.this.bakFileTable.getSelection() instanceof StructuredSelection && !(structuredSelection = (StructuredSelection)BakAndRestorePage.this.bakFileTable.getSelection()).isEmpty() && structuredSelection.getFirstElement() instanceof File) {
                    int n = BakAndRestorePage.this.bakFileTable.getTable().getSelectionIndex();
                    File file = (File)structuredSelection.getFirstElement();
                    if (file.exists()) {
                        file.delete();
                    }
                    BakAndRestorePage.this.bakFileTable.refresh();
                    if (n < BakAndRestorePage.this.bakFileTable.getTable().getItemCount()) {
                        BakAndRestorePage.this.bakFileTable.getTable().select(n);
                    } else if (BakAndRestorePage.this.bakFileTable.getTable().getItemCount() > 0) {
                        BakAndRestorePage.this.bakFileTable.getTable().select(BakAndRestorePage.this.bakFileTable.getTable().getItemCount() - 1);
                    }
                }
            }
        });
        section2.setClient(composite2);
    }

    private void createTitle() {
        WidgetUtil.createFormText(this.container.getBody(), "\u672c\u9875\u9762\u7528\u4e8e\u5907\u4efd\u548c\u8fd8\u539f\u6e38\u620f\u5185\u91cd\u8981\u6570\u636e\u6587\u4ef6\uff0c\u82e5\u4fee\u6539\u5904\u8fc7\u591a\uff0c\u8fd8\u539f\u53ef\u80fd\u9700\u8981\u91cd\u65b0\u5f00\u6863\u3002");
    }

    public String getDisplayName() {
        return "\u5907\u4efd\u4e0e\u8fd8\u539f";
    }

    private void refreshTable() {
        if (this.bakFileTable != null && this.bakFileTable.getTable() != null && !this.bakFileTable.getTable().isDisposed()) {
            this.bakFileTable.refresh();
        }
    }

    public void refresh() {
        super.refresh();
        this.refreshTable();
    }

    public void handleEvent(Event event) {
        if (Patch.getInstance().getShell().isDisposed()) {
            return;
        }
        if (event.type == 0) {
            this.IO_WAIT = false;
        }
        this.checkButtonStatus();
    }

    private void checkButtonStatus() {
        if (this.restoreButton.getSelection() && !this.applyRestoreButton.isEnabled()) {
            this.applyRestoreButton.setEnabled(this.restoreButton.getSelection() && !this.IO_WAIT);
        } else if (this.initBakButton.getSelection() && !this.initApplyBakButton.isEnabled()) {
            this.initApplyBakButton.setEnabled(this.initBakButton.getSelection() && !this.IO_WAIT);
        } else if (this.restoreBakButton.getSelection() && !this.applyRestoreBakButton.isEnabled()) {
            this.applyRestoreBakButton.setEnabled(this.restoreBakButton.getSelection() && !this.IO_WAIT);
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object object) {
            File[] fileArray;
            File file;
            ArrayList<File> arrayList = new ArrayList<File>();
            if (object instanceof File && (file = (File)object).exists() && (fileArray = file.listFiles()) != null && BakAndRestorePage.this.date != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (!file2.getName().startsWith(BakAndRestorePage.this.date) || !file2.getName().endsWith(".zip")) continue;
                    arrayList.add(file2);
                }
            }
            return arrayList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    class TableLabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof File && ((File)object).exists()) {
                File file = (File)object;
                if (n == 0) {
                    String string = file.getName().replaceAll("\\.zip", "");
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    try {
                        Date date = simpleDateFormat.parse(string);
                        simpleDateFormat = new SimpleDateFormat("HH\u65f6mm\u5206");
                        return simpleDateFormat.format(date);
                    }
                    catch (ParseException parseException) {}
                } else if (n == 1) {
                    try {
                        ZipFileInfo zipFileInfo = new ZipFileInfo(file, "GBK");
                        String string = zipFileInfo.getComment();
                        zipFileInfo.close();
                        if (string != null) {
                            return string;
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }
}

