/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.sanguo.patch.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.sf.feeling.sanguo.patch.util.FileConstants;
import org.sf.feeling.sanguo.patch.util.Properties;

public class FileUtil {
    public static File bakFile(File file) {
        return FileUtil.bakFile(file, ".patch.bak");
    }

    public static File bakFile(File file, String string) {
        return FileUtil.bakFile(file, ".patch.bak", "GBK");
    }

    public static File bakFile(File file, String string, String string2) {
        String string3 = file.getAbsolutePath();
        String string4 = string3 + string;
        File file2 = new File(string4);
        if (!file2.exists()) {
            try {
                int n = (int)file.length();
                int n2 = 0;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string2));
                char[] cArray = new char[n];
                while (bufferedReader.ready()) {
                    n2 += bufferedReader.read(cArray, n2, n - n2);
                }
                bufferedReader.close();
                char[] cArray2 = new char[n2];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
                String string5 = new String(cArray2);
                PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), string2)), false);
                printWriter.print(string5);
                printWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return file2;
    }

    public static void restoreFile(File file) {
        FileUtil.restoreFile(file, ".patch.bak");
    }

    public static void restoreFile(File file, String string) {
        FileUtil.restoreFile(file, ".patch.bak", "GBK");
    }

    public static void restoreFile(File file, String string, String string2) {
        String string3 = file.getAbsolutePath();
        String string4 = string3 + string;
        File file2 = new File(string4);
        if (file2.exists()) {
            try {
                int n = (int)file2.length();
                int n2 = 0;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), string2));
                char[] cArray = new char[n];
                while (bufferedReader.ready()) {
                    n2 += bufferedReader.read(cArray, n2, n - n2);
                }
                bufferedReader.close();
                char[] cArray2 = new char[n2];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
                String string5 = new String(cArray2);
                PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string2)), false);
                printWriter.print(string5);
                printWriter.close();
                file2.delete();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void clearRestoreFile(File file) {
        String string = file.getAbsolutePath();
        String string2 = string + ".patch.bak";
        File file2 = new File(string2);
        if (file2.exists()) {
            file2.delete();
        }
    }

    public static void replaceFile(File file, String string, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string2, string3);
        FileUtil.replaceFile(file, string, hashMap);
    }

    public static void replaceFile(File file, String string, String string2, String string3, String string4) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string2, string3);
        FileUtil.replaceFile(file, string, hashMap, string4);
    }

    public static void replaceFile(File file, String string, Map map) {
        FileUtil.replaceFile(file, string, map, "GBK");
    }

    public static void replaceFile(File file, String string, Map map, String string2) {
        try {
            Object object;
            int n = (int)file.length();
            int n2 = 0;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string2));
            char[] cArray = new char[n];
            while (bufferedReader.ready()) {
                n2 += bufferedReader.read(cArray, n2, n - n2);
            }
            bufferedReader.close();
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, 0, cArray2, 0, n2);
            String string3 = new String(cArray2);
            Pattern pattern = Pattern.compile(string);
            Matcher matcher = pattern.matcher(string3);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                object = map.keySet().iterator();
                String string4 = matcher.group();
                while (object.hasNext()) {
                    String string5 = (String)object.next();
                    Pattern pattern2 = Pattern.compile(string5);
                    Matcher matcher2 = pattern2.matcher(string4);
                    string4 = matcher2.replaceAll((String)map.get(string5));
                }
                matcher.appendReplacement(stringBuffer, string4);
            }
            matcher.appendTail(stringBuffer);
            object = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string2)), false);
            ((PrintWriter)object).print(stringBuffer);
            ((PrintWriter)object).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String findMatchString(File file, String string, String string2) {
        try {
            int n = (int)file.length();
            int n2 = 0;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "GBK"));
            char[] cArray = new char[n];
            while (bufferedReader.ready()) {
                n2 += bufferedReader.read(cArray, n2, n - n2);
            }
            bufferedReader.close();
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, 0, cArray2, 0, n2);
            String string3 = new String(cArray2);
            Pattern pattern = Pattern.compile(string);
            Matcher matcher = pattern.matcher(string3);
            while (matcher.find()) {
                Pattern pattern2 = Pattern.compile(string2);
                Matcher matcher2 = pattern2.matcher(matcher.group());
                if (!matcher2.find()) continue;
                return matcher2.group();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    public static boolean containMatchString(File file, String string) {
        try {
            int n = (int)file.length();
            int n2 = 0;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "GBK"));
            char[] cArray = new char[n];
            while (bufferedReader.ready()) {
                n2 += bufferedReader.read(cArray, n2, n - n2);
            }
            bufferedReader.close();
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, 0, cArray2, 0, n2);
            String string2 = new String(cArray2);
            Pattern pattern = Pattern.compile(string);
            Matcher matcher = pattern.matcher(string2);
            if (matcher.find()) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static void appendToFile(File file, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "GBK"));
            printWriter.println();
            printWriter.println(string);
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void appendToFile(File file, InputStream inputStream) {
        try {
            char[] cArray;
            int n = 0;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "GBK"));
            ArrayList<char[]> arrayList = new ArrayList<char[]>();
            while (bufferedReader.ready()) {
                cArray = new char[1024];
                n += bufferedReader.read(cArray, 0, 1024);
                arrayList.add(cArray);
            }
            bufferedReader.close();
            inputStream.close();
            cArray = new char[n];
            char[] cArray2 = new char[arrayList.size() * 1024];
            for (int i = 0; i < arrayList.size(); ++i) {
                System.arraycopy((char[])arrayList.get(i), 0, cArray2, i * 1024, 1024);
            }
            System.arraycopy(cArray2, 0, cArray, 0, n);
            String string = new String(cArray);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "GBK"));
            printWriter.println();
            printWriter.println(string);
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToBinarayFile(File file, InputStream inputStream) {
        FileUtil.writeToBinarayFile(file, inputStream, true);
    }

    public static void writeToBinarayFile(File file, InputStream inputStream, boolean bl) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            if (bl) {
                bufferedInputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static Properties loadProperties(String string) {
        return FileUtil.loadProperties(string, false);
    }

    public static Properties loadProperties(String string, boolean bl) {
        try {
            Properties properties = new Properties();
            InputStream inputStream = null;
            inputStream = "faction".equals(string) && !bl ? new FileInputStream(FileConstants.factionPropertiesFile) : FileUtil.class.getResourceAsStream("/org/sf/feeling/sanguo/patch/code/" + string + ".properties");
            properties.load(inputStream);
            ((InputStream)inputStream).close();
            Set set = properties.entrySet();
            Map.Entry[] entryArray = set.toArray(new Map.Entry[0]);
            for (int i = 0; i < entryArray.length; ++i) {
                Map.Entry entry = entryArray[i];
                String string2 = (String)entry.getKey();
                String string3 = (String)entry.getValue();
                properties.remove(entry.getKey());
                properties.put(FileUtil.convert(string2), FileUtil.convert(string3));
            }
            return properties;
        }
        catch (Exception exception) {
            SWT.error(39, exception);
            return null;
        }
    }

    private static Object convert(String string) {
        try {
            return new String(string.getBytes("ISO-8859-1"), "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static Properties loadProperties(File file) {
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
            return properties;
        }
        catch (Exception exception) {
            SWT.error(39, exception);
            return null;
        }
    }

    public static void checkAndSaveFile(File file) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedOutputStream.flush();
            bufferedInputStream.close();
            String string = byteArrayOutputStream.toString("gbk");
            bufferedOutputStream.close();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\r') {
                    if (i < string.length() - 1 && string.charAt(i + 1) != '\n') continue;
                    stringBuffer.append(c);
                    continue;
                }
                if (c == '\n') {
                    if (i > 0 && string.charAt(i - 1) != '\r') continue;
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append(c);
            }
            PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileConstants.unitFile), "GBK")), false);
            printWriter.print(stringBuffer);
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    FileUtil.deleteFile(fileArray[i]);
                }
            }
            file.delete();
        }
    }

    public static String getMD5Str(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
            byte[] byArray = new byte[4096];
            FileInputStream fileInputStream = new FileInputStream(file);
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            ((InputStream)fileInputStream).close();
            byteArrayOutputStream.close();
            MessageDigest messageDigest = null;
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(byArray2);
            byte[] byArray3 = messageDigest.digest();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray3.length; ++i) {
                if (Integer.toHexString(0xFF & byArray3[i]).length() == 1) {
                    stringBuffer.append("0").append(Integer.toHexString(0xFF & byArray3[i]));
                    continue;
                }
                stringBuffer.append(Integer.toHexString(0xFF & byArray3[i]));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

