/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.DeviceResourceManager;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class JFaceResources {
    private static final Map registries = new HashMap();
    public static final String BANNER_FONT = "org.eclipse.jface.bannerfont";
    protected static final ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.ui.forms.messages");
    private static ColorRegistry colorRegistry;
    public static final String DEFAULT_FONT = "org.eclipse.jface.defaultfont";
    public static final String DIALOG_FONT = "org.eclipse.jface.dialogfont";
    private static FontRegistry fontRegistry;
    public static final String HEADER_FONT = "org.eclipse.jface.headerfont";
    private static ImageRegistry imageRegistry;
    public static final String TEXT_FONT = "org.eclipse.jface.textfont";
    public static final String VIEWER_FONT = "org.eclipse.jface.viewerfont";
    public static final String WINDOW_FONT = "org.eclipse.jface.windowfont";

    public static String format(String string, Object[] objectArray) {
        return MessageFormat.format(JFaceResources.getString(string), objectArray);
    }

    public static Font getBannerFont() {
        return JFaceResources.getFontRegistry().get(BANNER_FONT);
    }

    public static ResourceBundle getBundle() {
        return bundle;
    }

    public static ColorRegistry getColorRegistry() {
        if (colorRegistry == null) {
            colorRegistry = new ColorRegistry();
        }
        return colorRegistry;
    }

    public static ResourceManager getResources(final Display display) {
        ResourceManager resourceManager = (ResourceManager)registries.get(display);
        if (resourceManager == null) {
            final DeviceResourceManager deviceResourceManager = new DeviceResourceManager((Device)display);
            resourceManager = deviceResourceManager;
            registries.put(display, resourceManager);
            display.disposeExec(new Runnable(){

                public void run() {
                    deviceResourceManager.dispose();
                    registries.remove(display);
                }
            });
        }
        return resourceManager;
    }

    public static ResourceManager getResources() {
        return JFaceResources.getResources(Display.getCurrent());
    }

    public static Font getDefaultFont() {
        return JFaceResources.getFontRegistry().defaultFont();
    }

    public static FontDescriptor getDefaultFontDescriptor() {
        return JFaceResources.getFontRegistry().defaultFontDescriptor();
    }

    public static Font getDialogFont() {
        return JFaceResources.getFontRegistry().get(DIALOG_FONT);
    }

    public static FontDescriptor getDialogFontDescriptor() {
        return JFaceResources.getFontRegistry().getDescriptor(DIALOG_FONT);
    }

    public static Font getFont(String string) {
        return JFaceResources.getFontRegistry().get(string);
    }

    public static FontDescriptor getFontDescriptor(String string) {
        return JFaceResources.getFontRegistry().getDescriptor(string);
    }

    public static FontRegistry getFontRegistry() {
        if (fontRegistry == null) {
            fontRegistry = new FontRegistry("org.eclipse.ui.forms.resource.jfacefonts");
        }
        return fontRegistry;
    }

    public static Font getHeaderFont() {
        return JFaceResources.getFontRegistry().get(HEADER_FONT);
    }

    public static FontDescriptor getHeaderFontDescriptor() {
        return JFaceResources.getFontRegistry().getDescriptor(HEADER_FONT);
    }

    public static Image getImage(String string) {
        return JFaceResources.getImageRegistry().get(string);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry(JFaceResources.getResources(Display.getCurrent()));
            JFaceResources.initializeDefaultImages();
        }
        return imageRegistry;
    }

    private static void initializeDefaultImages() {
        imageRegistry.put("dialog_messasge_info_image", ImageDescriptor.createFromFile(JFaceResources.class, "message_info.gif"));
        imageRegistry.put("dialog_messasge_warning_image", ImageDescriptor.createFromFile(JFaceResources.class, "message_warning.gif"));
        imageRegistry.put("dialog_message_error_image", ImageDescriptor.createFromFile(JFaceResources.class, "message_error.gif"));
    }

    public static String getString(String string) {
        try {
            return bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public static String[] getStrings(String[] stringArray) {
        Assert.isNotNull(stringArray);
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = JFaceResources.getString(stringArray[i]);
        }
        return stringArray2;
    }

    public static Font getTextFont() {
        return JFaceResources.getFontRegistry().get(TEXT_FONT);
    }

    public static FontDescriptor getTextFontDescriptor() {
        return JFaceResources.getFontRegistry().getDescriptor(TEXT_FONT);
    }

    public static Font getViewerFont() {
        return JFaceResources.getFontRegistry().get(VIEWER_FONT);
    }

    public static void setFontRegistry(FontRegistry fontRegistry) {
        Assert.isTrue(JFaceResources.fontRegistry == null, "Font registry can only be set once.");
        JFaceResources.fontRegistry = fontRegistry;
    }

    private JFaceResources() {
    }

    static {
        fontRegistry = null;
        imageRegistry = null;
    }
}

