/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class Geometry {
    private Geometry() {
    }

    public static int distanceSquared(Point point, Point point2) {
        int n = point.x - point2.x;
        int n2 = point.y - point2.y;
        return n * n + n2 * n2;
    }

    public static double magnitude(Point point) {
        return Math.sqrt(Geometry.magnitudeSquared(point));
    }

    public static int magnitudeSquared(Point point) {
        return point.x * point.x + point.y * point.y;
    }

    public static int dotProduct(Point point, Point point2) {
        return point.x * point2.x + point.y * point2.y;
    }

    public static Point min(Point point, Point point2) {
        return new Point(Math.min(point.x, point2.x), Math.min(point.y, point2.y));
    }

    public static Point max(Point point, Point point2) {
        return new Point(Math.max(point.x, point2.x), Math.max(point.y, point2.y));
    }

    public static Point getDirectionVector(int n, int n2) {
        switch (n2) {
            case 128: {
                return new Point(0, -n);
            }
            case 1024: {
                return new Point(0, n);
            }
            case 16384: {
                return new Point(-n, 0);
            }
            case 131072: {
                return new Point(n, 0);
            }
        }
        return new Point(0, 0);
    }

    public static Point centerPoint(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    public static Point copy(Point point) {
        return new Point(point.x, point.y);
    }

    public static void set(Point point, Point point2) {
        point.x = point2.x;
        point.y = point2.y;
    }

    public static void set(Rectangle rectangle, Rectangle rectangle2) {
        rectangle.x = rectangle2.x;
        rectangle.y = rectangle2.y;
        rectangle.width = rectangle2.width;
        rectangle.height = rectangle2.height;
    }

    public static Rectangle subtract(Rectangle rectangle, Rectangle rectangle2) {
        return new Rectangle(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y, rectangle.width - rectangle2.width, rectangle.height - rectangle2.height);
    }

    public static Rectangle add(Rectangle rectangle, Rectangle rectangle2) {
        return new Rectangle(rectangle.x + rectangle2.x, rectangle.y + rectangle2.y, rectangle.width + rectangle2.width, rectangle.height + rectangle2.height);
    }

    public static Point add(Point point, Point point2) {
        return new Point(point.x + point2.x, point.y + point2.y);
    }

    public static Point divide(Point point, int n) {
        return new Point(point.x / n, point.y / n);
    }

    public static Point subtract(Point point, Point point2) {
        return new Point(point.x - point2.x, point.y - point2.y);
    }

    public static void flipXY(Point point) {
        int n = point.x;
        point.x = point.y;
        point.y = n;
    }

    public static void flipXY(Rectangle rectangle) {
        int n = rectangle.x;
        rectangle.x = rectangle.y;
        rectangle.y = n;
        n = rectangle.width;
        rectangle.width = rectangle.height;
        rectangle.height = n;
    }

    public static int getDimension(Rectangle rectangle, boolean bl) {
        if (bl) {
            return rectangle.width;
        }
        return rectangle.height;
    }

    public static int getCoordinate(Point point, boolean bl) {
        return bl ? point.x : point.y;
    }

    public static int getCoordinate(Rectangle rectangle, boolean bl) {
        return bl ? rectangle.x : rectangle.y;
    }

    public static void setDimension(Rectangle rectangle, boolean bl, int n) {
        if (bl) {
            rectangle.width = n;
        } else {
            rectangle.height = n;
        }
    }

    public static void setCoordinate(Rectangle rectangle, boolean bl, int n) {
        if (bl) {
            rectangle.x = n;
        } else {
            rectangle.y = n;
        }
    }

    public static void setCoordinate(Point point, boolean bl, int n) {
        if (bl) {
            point.x = n;
        } else {
            point.y = n;
        }
    }

    public static int getDistanceFromEdge(Rectangle rectangle, Point point, int n) {
        switch (n) {
            case 128: {
                return point.y - rectangle.y;
            }
            case 1024: {
                return rectangle.y + rectangle.height - point.y;
            }
            case 16384: {
                return point.x - rectangle.x;
            }
            case 131072: {
                return rectangle.x + rectangle.width - point.x;
            }
        }
        return 0;
    }

    public static Rectangle getExtrudedEdge(Rectangle rectangle, int n, int n2) {
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (!Geometry.isHorizontal(n2)) {
            rectangle2.width = n;
        } else {
            rectangle2.height = n;
        }
        switch (n2) {
            case 131072: {
                rectangle2.x = rectangle.x + rectangle.width - rectangle2.width;
                break;
            }
            case 1024: {
                rectangle2.y = rectangle.y + rectangle.height - rectangle2.height;
            }
        }
        Geometry.normalize(rectangle2);
        return rectangle2;
    }

    public static int getOppositeSide(int n) {
        switch (n) {
            case 128: {
                return 1024;
            }
            case 1024: {
                return 128;
            }
            case 16384: {
                return 131072;
            }
            case 131072: {
                return 16384;
            }
        }
        return n;
    }

    public static int getSwtHorizontalOrVerticalConstant(boolean bl) {
        if (bl) {
            return 256;
        }
        return 512;
    }

    public static boolean isHorizontal(int n) {
        return n != 16384 && n != 131072;
    }

    public static void moveRectangle(Rectangle rectangle, Point point) {
        rectangle.x += point.x;
        rectangle.y += point.y;
    }

    public static void expand(Rectangle rectangle, Rectangle rectangle2) {
        rectangle.x += rectangle2.x;
        rectangle.y += rectangle2.y;
        rectangle.height = Math.max(0, rectangle.height + rectangle2.height);
        rectangle.width = Math.max(0, rectangle.width + rectangle2.width);
    }

    public static Rectangle createDiffRectangle(int n, int n2, int n3, int n4) {
        return new Rectangle(-n, -n3, n + n2, n3 + n4);
    }

    public static void expand(Rectangle rectangle, int n, int n2, int n3, int n4) {
        rectangle.x -= n;
        rectangle.width = Math.max(0, rectangle.width + n + n2);
        rectangle.y -= n3;
        rectangle.height = Math.max(0, rectangle.height + n3 + n4);
    }

    public static void normalize(Rectangle rectangle) {
        if (rectangle.width < 0) {
            rectangle.width = -rectangle.width;
            rectangle.x -= rectangle.width;
        }
        if (rectangle.height < 0) {
            rectangle.height = -rectangle.height;
            rectangle.y -= rectangle.height;
        }
    }

    public static Rectangle toControl(Control control, Rectangle rectangle) {
        return control.getDisplay().map(null, control, rectangle);
    }

    public static Rectangle toDisplay(Control control, Rectangle rectangle) {
        return control.getDisplay().map(control, null, rectangle);
    }

    public static int getRelativePosition(Rectangle rectangle, Point point) {
        int n = 0;
        if (point.x < rectangle.x) {
            n |= 0x4000;
        } else if (point.x >= rectangle.x + rectangle.width) {
            n |= 0x20000;
        }
        if (point.y < rectangle.y) {
            n |= 0x80;
        } else if (point.y >= rectangle.y + rectangle.height) {
            n |= 0x400;
        }
        return n;
    }

    public static int getDistanceFrom(Rectangle rectangle, Point point) {
        int n = Geometry.getClosestSide(rectangle, point);
        return Geometry.getDistanceFromEdge(rectangle, point, n);
    }

    public static int getClosestSide(Rectangle rectangle, Point point) {
        int[] nArray = new int[]{16384, 131072, 128, 1024};
        int n = 16384;
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            int n4 = Geometry.getDistanceFromEdge(rectangle, point, n3);
            if (n4 >= n2) continue;
            n2 = n4;
            n = n3;
        }
        return n;
    }

    public static Rectangle copy(Rectangle rectangle) {
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static Point getSize(Rectangle rectangle) {
        return new Point(rectangle.width, rectangle.height);
    }

    public static void setSize(Rectangle rectangle, Point point) {
        rectangle.width = point.x;
        rectangle.height = point.y;
    }

    public static void setLocation(Rectangle rectangle, Point point) {
        rectangle.width = point.x;
        rectangle.height = point.y;
    }

    public static Point getLocation(Rectangle rectangle) {
        return new Point(rectangle.x, rectangle.y);
    }

    public static Rectangle createRectangle(Point point, Point point2) {
        return new Rectangle(point.x, point.y, point2.x, point2.y);
    }

    public static void moveInside(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle.x < rectangle2.x) {
            rectangle.x = rectangle2.x;
        }
        if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
            rectangle.x -= rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width);
        }
        if (rectangle.y < rectangle2.y) {
            rectangle.y = rectangle2.y;
        }
        if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
            rectangle.y -= rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
        }
    }
}

