/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import java.util.Comparator;
import org.eclipse.jface.dialogs.ErrorSupportProvider;
import org.eclipse.jface.runtime.IStatus;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ILogger;

public class Policy {
    public static final boolean DEFAULT = false;
    public static final String JFACE = "org.eclipse.jface";
    private static ILogger log;
    private static Comparator viewerComparator;
    public static boolean DEBUG_DIALOG_NO_PARENT;
    public static boolean TRACE_ACTIONS;
    public static boolean TRACE_TOOLBAR;
    private static ErrorSupportProvider errorSupportProvider;

    private static ILogger getDummyLog() {
        return new ILogger(){

            public void log(IStatus iStatus) {
                System.err.println(iStatus.getMessage());
            }
        };
    }

    public static void setLog(ILogger iLogger) {
        log = iLogger;
    }

    public static ILogger getLog() {
        if (log == null) {
            log = Policy.getDummyLog();
        }
        return log;
    }

    private static Comparator getDefaultComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                return ((String)object).compareTo((String)object2);
            }
        };
    }

    public static Comparator getComparator() {
        if (viewerComparator == null) {
            viewerComparator = Policy.getDefaultComparator();
        }
        return viewerComparator;
    }

    public static void setComparator(Comparator comparator) {
        Assert.isTrue(viewerComparator == null);
        viewerComparator = comparator;
    }

    public static void setErrorSupportProvider(ErrorSupportProvider errorSupportProvider) {
        Policy.errorSupportProvider = errorSupportProvider;
    }

    public static ErrorSupportProvider getErrorSupportProvider() {
        return errorSupportProvider;
    }

    static {
        DEBUG_DIALOG_NO_PARENT = false;
        TRACE_ACTIONS = false;
        TRACE_TOOLBAR = false;
    }
}

