/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.runtime.ISafeRunnable;
import org.eclipse.jface.runtime.OperationCanceledException;
import org.eclipse.jface.runtime.Status;
import org.eclipse.jface.util.ISafeRunnableRunner;
import org.eclipse.swt.widgets.Display;

public abstract class SafeRunnable
implements ISafeRunnable {
    private static boolean ignoreErrors = false;
    private static ISafeRunnableRunner runner;
    private String message;

    public SafeRunnable() {
    }

    public SafeRunnable(String string) {
        this.message = string;
    }

    public void handleException(Throwable throwable) {
        if (!ignoreErrors) {
            if (this.message == null) {
                this.message = JFaceResources.getString("SafeRunnable.errorMessage");
            }
            Status status = new Status(4, "org.eclipse.jface", this.message, throwable);
            Runnable runnable = new Runnable(){

                public void run() {
                }
            };
            if (Display.getCurrent() != null) {
                runnable.run();
            } else {
                Display.getDefault().asyncExec(runnable);
            }
        }
    }

    public static boolean getIgnoreErrors(boolean bl) {
        return ignoreErrors;
    }

    public static boolean getIgnoreErrors() {
        return ignoreErrors;
    }

    public static void setIgnoreErrors(boolean bl) {
        ignoreErrors = bl;
    }

    public static ISafeRunnableRunner getRunner() {
        if (runner == null) {
            runner = SafeRunnable.createDefaultRunner();
        }
        return runner;
    }

    private static ISafeRunnableRunner createDefaultRunner() {
        return new ISafeRunnableRunner(){

            public void run(ISafeRunnable iSafeRunnable) {
                try {
                    iSafeRunnable.run();
                }
                catch (Exception exception) {
                    this.handleException(iSafeRunnable, exception);
                }
                catch (LinkageError linkageError) {
                    this.handleException(iSafeRunnable, linkageError);
                }
            }

            private void handleException(ISafeRunnable iSafeRunnable, Throwable throwable) {
                if (!(throwable instanceof OperationCanceledException)) {
                    throwable.printStackTrace();
                }
                iSafeRunnable.handleException(throwable);
            }
        };
    }

    public static void setRunner(ISafeRunnableRunner iSafeRunnableRunner) {
        runner = iSafeRunnableRunner;
    }

    public static void run(ISafeRunnable iSafeRunnable) {
        SafeRunnable.getRunner().run(iSafeRunnable);
    }
}

