/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractTableViewer
extends ColumnViewer {
    private VirtualManager virtualManager;

    protected void hookControl(Control control) {
        super.hookControl(control);
        this.initializeVirtualManager(this.getControl().getStyle());
    }

    private void initializeVirtualManager(int n) {
        if ((n & 0x10000000) == 0) {
            return;
        }
        this.virtualManager = new VirtualManager();
    }

    public void add(Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        if (this.isBusy()) {
            return;
        }
        Object[] objectArray2 = this.filter(objectArray);
        for (int i = 0; i < objectArray2.length; ++i) {
            Object object = objectArray2[i];
            int n = this.indexForElement(object);
            this.createItem(object, n);
        }
    }

    private void createItem(Object object, int n) {
        if (this.virtualManager == null) {
            this.updateItem(this.internalCreateNewRowPart(0, n).getItem(), object);
        } else {
            this.virtualManager.notVisibleAdded(object, n);
        }
    }

    protected abstract ViewerRow internalCreateNewRowPart(int var1, int var2);

    public void add(Object object) {
        this.add(new Object[]{object});
    }

    protected Widget doFindInputItem(Object object) {
        if (this.equals(object, this.getRoot())) {
            return this.getControl();
        }
        return null;
    }

    protected Widget doFindItem(Object object) {
        Item[] itemArray = this.doGetItems();
        for (int i = 0; i < itemArray.length; ++i) {
            Item item = itemArray[i];
            Object object2 = item.getData();
            if (object2 == null || !this.equals(object2, object)) continue;
            return item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpdateItem(Widget widget, Object object, boolean bl) {
        boolean bl2 = this.busy;
        this.busy = true;
        try {
            if (widget instanceof Item) {
                boolean bl3;
                Item item = (Item)widget;
                if (bl) {
                    this.associate(object, item);
                } else {
                    Object object2 = item.getData();
                    if (object2 != null) {
                        this.unmapElement(object2, (Widget)item);
                    }
                    item.setData(object);
                    this.mapElement(object, (Widget)item);
                }
                int n = this.doGetColumnCount();
                if (n == 0) {
                    n = 1;
                }
                ViewerRow viewerRow = this.getViewerRowFromItem((Widget)item);
                boolean bl4 = bl3 = (this.getControl().getStyle() & 0x10000000) != 0;
                if (bl3) {
                    viewerRow = (ViewerRow)viewerRow.clone();
                }
                for (int i = 0; i < n || i == 0; ++i) {
                    ViewerColumn viewerColumn = this.getViewerColumn(i);
                    ViewerCell viewerCell = this.updateCell(viewerRow, i, object);
                    if (bl3) {
                        viewerCell = new ViewerCell(viewerCell.getViewerRow(), viewerCell.getColumnIndex(), object);
                    }
                    viewerColumn.refresh(viewerCell);
                    if (!item.isDisposed()) continue;
                    this.unmapElement(object, (Widget)item);
                    return;
                }
            }
        }
        finally {
            this.busy = bl2;
        }
    }

    protected Widget getColumnViewerOwner(int n) {
        int n2 = this.doGetColumnCount();
        if (n < 0 || n > 0 && n >= n2) {
            return null;
        }
        if (n2 == 0) {
            return this.getControl();
        }
        return this.doGetColumn(n);
    }

    public Object getElementAt(int n) {
        Item item;
        if (n >= 0 && n < this.doGetItemCount() && (item = this.doGetItem(n)) != null) {
            return item.getData();
        }
        return null;
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    protected List getSelectionFromWidget() {
        if (this.virtualManager != null) {
            return this.getVirtualSelection();
        }
        Item[] itemArray = this.doGetSelection();
        ArrayList<Object> arrayList = new ArrayList<Object>(itemArray.length);
        for (int i = 0; i < itemArray.length; ++i) {
            Item item = itemArray[i];
            Object object = item.getData();
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    private List getVirtualSelection() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int[] nArray = this.doGetSelectionIndices();
        if (this.getContentProvider() instanceof ILazyContentProvider) {
            ILazyContentProvider iLazyContentProvider = (ILazyContentProvider)this.getContentProvider();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                iLazyContentProvider.updateElement(n);
                Object object = this.doGetItem(n).getData();
                if (object == null) continue;
                arrayList.add(object);
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                Object object = null;
                int n = nArray[i];
                if (n < this.virtualManager.cachedElements.length) {
                    object = this.virtualManager.cachedElements[n];
                }
                if (object == null) {
                    Item item = this.doGetItem(n);
                    object = item.getData();
                }
                if (object == null) continue;
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    protected int indexForElement(Object object) {
        ViewerComparator viewerComparator = this.getComparator();
        if (viewerComparator == null) {
            return this.doGetItemCount();
        }
        int n = this.doGetItemCount();
        int n2 = 0;
        int n3 = n - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            Object object2 = this.doGetItem(n4).getData();
            int n5 = viewerComparator.compare(this, object2, object);
            if (n5 == 0) {
                while (n5 == 0 && ++n4 < n) {
                    object2 = this.doGetItem(n4).getData();
                    n5 = viewerComparator.compare(this, object2, object);
                }
                return n4;
            }
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inputChanged(Object object, Object object2) {
        this.getControl().setRedraw(false);
        try {
            this.preservingSelection(new Runnable(){

                public void run() {
                    AbstractTableViewer.this.internalRefresh(AbstractTableViewer.this.getRoot());
                }
            });
        }
        finally {
            this.getControl().setRedraw(true);
        }
    }

    public void insert(Object object, int n) {
        this.applyEditorValue();
        if (this.getComparator() != null || this.hasFilters()) {
            this.add(object);
            return;
        }
        if (n == -1) {
            n = this.doGetItemCount();
        }
        if (this.isBusy()) {
            return;
        }
        this.createItem(object, n);
    }

    protected void internalRefresh(Object object) {
        this.internalRefresh(object, true);
    }

    protected void internalRefresh(Object object, boolean bl) {
        this.applyEditorValue();
        if (object == null || this.equals(object, this.getRoot())) {
            if (this.virtualManager == null) {
                this.internalRefreshAll(bl);
            } else {
                this.internalVirtualRefreshAll();
            }
        } else {
            Widget widget = this.findItem(object);
            if (widget != null) {
                this.updateItem(widget, object);
            }
        }
    }

    private void internalVirtualRefreshAll() {
        Object object = this.getRoot();
        IContentProvider iContentProvider = this.getContentProvider();
        if (!(iContentProvider instanceof ILazyContentProvider) && iContentProvider instanceof IStructuredContentProvider && object != null) {
            VirtualManager.access$102(this.virtualManager, this.getSortedChildren(object));
            this.doSetItemCount(this.virtualManager.cachedElements.length);
        }
        this.doClearAll();
    }

    private void internalRefreshAll(boolean bl) {
        Item item;
        int n;
        Object[] objectArray = this.getSortedChildren(this.getRoot());
        Item[] itemArray = this.doGetItems();
        int n2 = Math.min(objectArray.length, itemArray.length);
        for (n = 0; n < n2; ++n) {
            item = itemArray[n];
            if (this.equals(objectArray[n], item.getData())) {
                if (bl) {
                    this.updateItem((Widget)item, objectArray[n]);
                    continue;
                }
                this.associate(objectArray[n], item);
                continue;
            }
            this.disassociate(item);
            this.doClear(n);
        }
        if (n2 < itemArray.length) {
            n = itemArray.length;
            while (--n >= n2) {
                this.disassociate(itemArray[n]);
            }
            if (this.virtualManager != null) {
                this.virtualManager.removeIndicesFromTo(n2, itemArray.length - 1);
            }
            this.doRemove(n2, itemArray.length - 1);
        }
        if (this.doGetItemCount() == 0) {
            this.doRemoveAll();
        }
        for (n = 0; n < n2; ++n) {
            item = itemArray[n];
            if (item.getData() != null) continue;
            this.updateItem((Widget)item, objectArray[n]);
        }
        for (n = n2; n < objectArray.length; ++n) {
            this.createItem(objectArray[n], n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRemove(Object[] objectArray) {
        Object object = this.getInput();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.equals(objectArray[i], object)) continue;
            boolean bl = this.busy;
            this.busy = false;
            try {
                this.setInput(null);
            }
            finally {
                this.busy = bl;
            }
            return;
        }
        int[] nArray = new int[objectArray.length];
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Widget widget = this.findItem(objectArray[i]);
            if (widget == null && this.virtualManager != null) {
                int n2 = this.virtualManager.find(objectArray[i]);
                if (n2 == -1) continue;
                nArray[n++] = n2;
                continue;
            }
            if (!(widget instanceof Item)) continue;
            Item item = (Item)widget;
            this.disassociate(item);
            nArray[n++] = this.doIndexOf(item);
        }
        if (n < nArray.length) {
            int[] nArray2 = nArray;
            nArray = new int[n];
            System.arraycopy(nArray2, 0, nArray, 0, n);
        }
        if (this.virtualManager != null) {
            this.virtualManager.removeIndices(nArray);
        }
        this.doRemove(nArray);
        if (this.doGetItemCount() == 0) {
            this.doRemoveAll();
        }
    }

    public void remove(final Object[] objectArray) {
        this.assertElementsNotNull(objectArray);
        if (this.isBusy()) {
            return;
        }
        if (objectArray.length == 0) {
            return;
        }
        this.preservingSelection(new Runnable(){

            public void run() {
                AbstractTableViewer.this.internalRemove(objectArray);
            }
        });
    }

    public void remove(Object object) {
        this.remove(new Object[]{object});
    }

    public void reveal(Object object) {
        Assert.isNotNull(object);
        Widget widget = this.findItem(object);
        if (widget instanceof Item) {
            this.doShowItem((Item)widget);
        }
    }

    protected void setSelectionToWidget(List list, boolean bl) {
        if (list == null) {
            this.doDeselectAll();
            return;
        }
        if (this.virtualManager != null) {
            this.virtualSetSelectionToWidget(list, bl);
            return;
        }
        if (bl) {
            int n = list.size();
            Item[] itemArray = new Item[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Object e = list.get(i);
                Widget widget = this.findItem(e);
                if (!(widget instanceof Item)) continue;
                Item item = (Item)widget;
                itemArray[n2++] = item;
            }
            if (n2 < n) {
                Item[] itemArray2 = itemArray;
                itemArray = new Item[n2];
                System.arraycopy(itemArray2, 0, itemArray, 0, n2);
            }
            this.doSetSelection(itemArray);
        } else {
            this.doDeselectAll();
            if (!list.isEmpty()) {
                int[] nArray = new int[list.size()];
                Iterator iterator = list.iterator();
                Item[] itemArray = this.doGetItems();
                int n = 0;
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    boolean bl2 = false;
                    for (int i = 0; i < itemArray.length && !bl2; ++i) {
                        if (!this.equals(e, itemArray[i].getData())) continue;
                        nArray[n++] = i;
                        bl2 = true;
                    }
                }
                if (n < nArray.length) {
                    int[] nArray2 = nArray;
                    nArray = new int[n];
                    System.arraycopy(nArray2, 0, nArray, 0, n);
                }
                this.doSelect(nArray);
            }
        }
    }

    private void virtualSetSelectionToWidget(List list, boolean bl) {
        Widget widget;
        Object object;
        int n;
        int n2 = list.size();
        int[] nArray = new int[list.size()];
        Item item = null;
        int n3 = 0;
        HashSet hashSet = new HashSet();
        for (n = 0; n < n2; ++n) {
            object = list.get(n);
            widget = this.findItem(object);
            if (widget instanceof Item) {
                Item item2 = (Item)widget;
                nArray[n3++] = this.doIndexOf(item2);
                if (item != null) continue;
                item = item2;
                continue;
            }
            hashSet.add(object);
        }
        if (this.getContentProvider() instanceof ILazyContentProvider) {
            ILazyContentProvider iLazyContentProvider = (ILazyContentProvider)this.getContentProvider();
            for (int i = 0; hashSet.size() > 0 && i < this.doGetItemCount(); ++i) {
                iLazyContentProvider.updateElement(i);
                widget = this.doGetItem(i);
                if (!hashSet.contains(widget.getData())) continue;
                nArray[n3++] = i;
                hashSet.remove(widget.getData());
                if (item != null) continue;
                item = widget;
            }
        } else if (n3 != list.size()) {
            for (n = 0; n < this.virtualManager.cachedElements.length; ++n) {
                object = this.virtualManager.cachedElements[n];
                if (!hashSet.contains(object)) continue;
                widget = this.doGetItem(n);
                widget.getText();
                nArray[n3++] = n;
                hashSet.remove(object);
                if (item != null) continue;
                item = widget;
            }
        }
        if (n3 < n2) {
            int[] nArray2 = nArray;
            nArray = new int[n3];
            System.arraycopy(nArray2, 0, nArray, 0, n3);
        }
        this.doSetSelection(nArray);
        if (bl && item != null) {
            this.doShowItem(item);
        }
    }

    public void setItemCount(int n) {
        if (this.isBusy()) {
            return;
        }
        int n2 = this.doGetItemCount();
        if (n < n2) {
            for (int i = n; i < n2; ++i) {
                Item item = this.doGetItem(i);
                if (item.getData() == null) continue;
                this.disassociate(item);
            }
        }
        this.doSetItemCount(n);
        if (this.virtualManager != null) {
            this.virtualManager.adjustCacheSize(n);
        }
        this.getControl().redraw();
    }

    public void replace(Object object, int n) {
        if (this.isBusy()) {
            return;
        }
        Item item = this.doGetItem(n);
        this.refreshItem((Widget)item, object);
    }

    public void clear(int n) {
        Item item = this.doGetItem(n);
        if (item.getData() != null) {
            this.disassociate(item);
        }
        this.doClear(n);
    }

    protected Object[] getRawChildren(Object object) {
        Assert.isTrue(!(this.getContentProvider() instanceof ILazyContentProvider), "Cannot get raw children with an ILazyContentProvider");
        return super.getRawChildren(object);
    }

    protected void assertContentProviderType(IContentProvider iContentProvider) {
        Assert.isTrue(iContentProvider instanceof IStructuredContentProvider || iContentProvider instanceof ILazyContentProvider);
    }

    protected abstract int doIndexOf(Item var1);

    protected abstract int doGetItemCount();

    protected abstract void doSetItemCount(int var1);

    protected abstract Item[] doGetItems();

    protected abstract Widget doGetColumn(int var1);

    protected abstract Item doGetItem(int var1);

    protected abstract Item[] doGetSelection();

    protected abstract int[] doGetSelectionIndices();

    protected abstract void doClearAll();

    protected abstract void doResetItem(Item var1);

    protected abstract void doRemove(int var1, int var2);

    protected abstract void doRemoveAll();

    protected abstract void doRemove(int[] var1);

    protected abstract void doShowItem(Item var1);

    protected abstract void doDeselectAll();

    protected abstract void doSetSelection(Item[] var1);

    protected abstract void doShowSelection();

    protected abstract void doSetSelection(int[] var1);

    protected abstract void doClear(int var1);

    protected abstract void doSelect(int[] var1);

    private class VirtualManager {
        private Object[] cachedElements = new Object[0];

        public VirtualManager() {
            this.addTableListener();
        }

        private void addTableListener() {
            AbstractTableViewer.this.getControl().addListener(36, new Listener(this){
                private final /* synthetic */ VirtualManager this$1;
                {
                    this.this$1 = virtualManager;
                }

                public void handleEvent(Event event) {
                    IContentProvider iContentProvider;
                    Item item = (Item)event.item;
                    int n = VirtualManager.access$000(this.this$1).doIndexOf(item);
                    Object object = this.this$1.resolveElement(n);
                    if (object == null && (iContentProvider = VirtualManager.access$000(this.this$1).getContentProvider()) instanceof ILazyContentProvider) {
                        ((ILazyContentProvider)iContentProvider).updateElement(n);
                        return;
                    }
                    VirtualManager.access$000(this.this$1).associate(object, item);
                    VirtualManager.access$000(this.this$1).updateItem((Widget)item, object);
                }
            });
        }

        protected Object resolveElement(int n) {
            Object object = null;
            if (n < this.cachedElements.length) {
                object = this.cachedElements[n];
            }
            return object;
        }

        public void notVisibleAdded(Object object, int n) {
            int n2 = AbstractTableViewer.this.doGetItemCount() + 1;
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.cachedElements, 0, objectArray, 0, n);
            if (n < this.cachedElements.length) {
                System.arraycopy(this.cachedElements, n, objectArray, n + 1, this.cachedElements.length - n);
            }
            objectArray[n] = object;
            this.cachedElements = objectArray;
            AbstractTableViewer.this.doSetItemCount(n2);
        }

        public void removeIndices(int[] nArray) {
            if (nArray.length == 1) {
                this.removeIndicesFromTo(nArray[0], nArray[0]);
            }
            int n = AbstractTableViewer.this.doGetItemCount() - nArray.length;
            Arrays.sort(nArray);
            Object[] objectArray = new Object[n];
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < this.cachedElements.length; ++i) {
                if (n3 < nArray.length && i == nArray[n3]) {
                    ++n3;
                    continue;
                }
                objectArray[n2++] = this.cachedElements[i];
            }
            this.cachedElements = objectArray;
        }

        public void removeIndicesFromTo(int n, int n2) {
            int n3 = n2 + 1;
            Object[] objectArray = new Object[this.cachedElements.length - (n3 - n)];
            System.arraycopy(this.cachedElements, 0, objectArray, 0, n);
            if (n3 < this.cachedElements.length) {
                System.arraycopy(this.cachedElements, n3, objectArray, n, this.cachedElements.length - n3);
            }
        }

        public int find(Object object) {
            return Arrays.asList(this.cachedElements).indexOf(object);
        }

        public void adjustCacheSize(int n) {
            if (n == this.cachedElements.length) {
                return;
            }
            if (n < this.cachedElements.length) {
                Object[] objectArray = new Object[n];
                System.arraycopy(this.cachedElements, 0, objectArray, 0, n);
                this.cachedElements = objectArray;
            } else {
                Object[] objectArray = new Object[n];
                System.arraycopy(this.cachedElements, 0, objectArray, 0, this.cachedElements.length);
                this.cachedElements = objectArray;
            }
        }

        static /* synthetic */ AbstractTableViewer access$000(VirtualManager virtualManager) {
            return virtualManager.AbstractTableViewer.this;
        }

        static /* synthetic */ Object[] access$102(VirtualManager virtualManager, Object[] objectArray) {
            virtualManager.cachedElements = objectArray;
            return objectArray;
        }
    }
}

