/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;

public class StructuredSelection
implements IStructuredSelection {
    private Object[] elements;
    public static final StructuredSelection EMPTY = new StructuredSelection();

    public StructuredSelection() {
    }

    public StructuredSelection(Object[] objectArray) {
        this.elements = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, this.elements, 0, objectArray.length);
    }

    public StructuredSelection(Object object) {
        Assert.isNotNull(object);
        this.elements = new Object[]{object};
    }

    public StructuredSelection(List list) {
        Assert.isNotNull(list);
        this.elements = list.toArray();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StructuredSelection)) {
            return false;
        }
        StructuredSelection structuredSelection = (StructuredSelection)object;
        if (this.isEmpty()) {
            return structuredSelection.isEmpty();
        }
        if (structuredSelection.isEmpty()) {
            return false;
        }
        int n = this.elements.length;
        if (n != structuredSelection.elements.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.elements[i].equals(structuredSelection.elements[i])) continue;
            return false;
        }
        return true;
    }

    public Object getFirstElement() {
        return this.isEmpty() ? null : this.elements[0];
    }

    public boolean isEmpty() {
        return this.elements == null || this.elements.length == 0;
    }

    public Iterator iterator() {
        return Arrays.asList(this.elements == null ? new Object[]{} : this.elements).iterator();
    }

    public int size() {
        return this.elements == null ? 0 : this.elements.length;
    }

    public Object[] toArray() {
        return this.elements == null ? new Object[]{} : (Object[])this.elements.clone();
    }

    public List toList() {
        return Arrays.asList(this.elements == null ? new Object[]{} : this.elements);
    }

    public String toString() {
        return this.isEmpty() ? JFaceResources.getString("<empty_selection>") : this.toList().toString();
    }
}

