/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Widget;

public abstract class ViewerColumn {
    private CellLabelProvider labelProvider;
    static String COLUMN_VIEWER_KEY = "org.eclipse.jface.columnViewer";
    private EditingSupport editingSupport;
    private ILabelProviderListener listener;
    private boolean listenerRegistered = false;

    protected ViewerColumn(final ColumnViewer columnViewer, Widget widget) {
        widget.setData(COLUMN_VIEWER_KEY, (Object)this);
        this.listener = new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
                columnViewer.handleLabelProviderChanged(labelProviderChangedEvent);
            }
        };
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ViewerColumn.this.handleDispose();
            }
        });
    }

    CellLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(CellLabelProvider cellLabelProvider) {
        this.setLabelProvider(cellLabelProvider, true);
    }

    void setLabelProvider(CellLabelProvider cellLabelProvider, boolean bl) {
        if (this.listenerRegistered && this.labelProvider != null) {
            this.labelProvider.removeListener(this.listener);
            this.listenerRegistered = false;
        }
        this.labelProvider = cellLabelProvider;
        if (bl) {
            this.labelProvider.addListener(this.listener);
            this.listenerRegistered = true;
        }
    }

    EditingSupport getEditingSupport() {
        return this.editingSupport;
    }

    public void setEditingSupport(EditingSupport editingSupport) {
        this.editingSupport = editingSupport;
    }

    void refresh(ViewerCell viewerCell) {
        this.getLabelProvider().update(viewerCell);
    }

    protected void handleDispose() {
        boolean bl = this.listenerRegistered;
        CellLabelProvider cellLabelProvider = this.labelProvider;
        this.setLabelProvider(null, false);
        if (bl) {
            cellLabelProvider.dispose();
        }
        this.editingSupport = null;
        this.listener = null;
    }
}

