/*
 * Decompiled with CFR 0.152.
 */
package sun.security.validator;

import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidator;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.validator.Validator;
import sun.security.validator.ValidatorException;

public final class PKIXValidator
extends Validator {
    private static final boolean TRY_VALIDATOR = true;
    private final Set trustedCerts;
    private final PKIXBuilderParameters parameterTemplate;
    private int certPathLength = -1;
    private Map<X500Principal, X509Certificate> trustedSubjects;
    private CertificateFactory factory;
    private boolean plugin = false;

    PKIXValidator(String string, Collection collection) {
        super("PKIX", string);
        this.trustedCerts = collection instanceof Set ? (Set)collection : new HashSet(collection);
        HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
        for (X509Certificate x509Certificate : collection) {
            hashSet.add(new TrustAnchor(x509Certificate, null));
        }
        try {
            this.parameterTemplate = new PKIXBuilderParameters(hashSet, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException("Unexpected error: " + invalidAlgorithmParameterException.toString(), invalidAlgorithmParameterException);
        }
        this.setDefaultParameters(string);
        this.initCommon();
    }

    PKIXValidator(String string, PKIXBuilderParameters pKIXBuilderParameters) {
        super("PKIX", string);
        this.trustedCerts = new HashSet();
        for (TrustAnchor trustAnchor : pKIXBuilderParameters.getTrustAnchors()) {
            X509Certificate x509Certificate = trustAnchor.getTrustedCert();
            if (x509Certificate == null) continue;
            this.trustedCerts.add(x509Certificate);
        }
        this.parameterTemplate = pKIXBuilderParameters;
        this.initCommon();
    }

    private void initCommon() {
        this.trustedSubjects = new HashMap<X500Principal, X509Certificate>();
        for (X509Certificate x509Certificate : this.trustedCerts) {
            this.trustedSubjects.put(x509Certificate.getSubjectX500Principal(), x509Certificate);
        }
        try {
            this.factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException("Internal error", certificateException);
        }
        this.plugin = this.variant.equals("plugin code signing");
    }

    public Collection getTrustedCertificates() {
        return this.trustedCerts;
    }

    public int getCertPathLength() {
        return this.certPathLength;
    }

    private void setDefaultParameters(String string) {
        this.parameterTemplate.setRevocationEnabled(false);
    }

    public PKIXBuilderParameters getParameters() {
        return this.parameterTemplate;
    }

    X509Certificate[] engineValidate(X509Certificate[] x509CertificateArray, Collection collection, Object object) throws CertificateException {
        Serializable serializable;
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new CertificateException("null or zero-length certificate chain");
        }
        X500Principal x500Principal = null;
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            serializable = x509CertificateArray[i];
            if (i != 0 && !((X509Certificate)serializable).getSubjectX500Principal().equals(x500Principal)) {
                return this.doBuild(x509CertificateArray, collection);
            }
            if (this.trustedCerts.contains(serializable)) {
                if (i == 0) {
                    return new X509Certificate[]{x509CertificateArray[0]};
                }
                X509Certificate[] x509CertificateArray2 = new X509Certificate[i];
                System.arraycopy(x509CertificateArray, 0, x509CertificateArray2, 0, i);
                return this.doValidate(x509CertificateArray2);
            }
            x500Principal = ((X509Certificate)serializable).getIssuerX500Principal();
        }
        X509Certificate x509Certificate = x509CertificateArray[x509CertificateArray.length - 1];
        serializable = x509Certificate.getIssuerX500Principal();
        X500Principal x500Principal2 = x509Certificate.getSubjectX500Principal();
        if (this.trustedSubjects.containsKey(serializable) && this.isSignatureValid(this.trustedSubjects.get(serializable), x509Certificate)) {
            return this.doValidate(x509CertificateArray);
        }
        if (this.plugin) {
            if (x509CertificateArray.length > 1) {
                X509Certificate[] x509CertificateArray3 = new X509Certificate[x509CertificateArray.length - 1];
                System.arraycopy(x509CertificateArray, 0, x509CertificateArray3, 0, x509CertificateArray3.length);
                PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)this.parameterTemplate.clone();
                try {
                    pKIXBuilderParameters.setTrustAnchors(Collections.singleton(new TrustAnchor(x509CertificateArray[x509CertificateArray.length - 1], null)));
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new CertificateException(invalidAlgorithmParameterException);
                }
                this.doValidate(x509CertificateArray3, pKIXBuilderParameters);
            }
            throw new ValidatorException(ValidatorException.T_NO_TRUST_ANCHOR);
        }
        return this.doBuild(x509CertificateArray, collection);
    }

    private boolean isSignatureValid(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        if (this.plugin) {
            try {
                x509Certificate2.verify(x509Certificate.getPublicKey());
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        return true;
    }

    private static X509Certificate[] toArray(CertPath certPath, TrustAnchor trustAnchor) throws CertificateException {
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate[] x509CertificateArray = new X509Certificate[list.size() + 1];
        list.toArray(x509CertificateArray);
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        if (x509Certificate == null) {
            throw new ValidatorException("TrustAnchor must be specified as certificate");
        }
        x509CertificateArray[x509CertificateArray.length - 1] = x509Certificate;
        return x509CertificateArray;
    }

    private void setDate(PKIXBuilderParameters pKIXBuilderParameters) {
        Date date = this.validationDate;
        if (date != null) {
            pKIXBuilderParameters.setDate(date);
        }
    }

    private X509Certificate[] doValidate(X509Certificate[] x509CertificateArray) throws CertificateException {
        PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)this.parameterTemplate.clone();
        return this.doValidate(x509CertificateArray, pKIXBuilderParameters);
    }

    private X509Certificate[] doValidate(X509Certificate[] x509CertificateArray, PKIXBuilderParameters pKIXBuilderParameters) throws CertificateException {
        try {
            this.setDate(pKIXBuilderParameters);
            CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
            CertPath certPath = this.factory.generateCertPath(Arrays.asList(x509CertificateArray));
            this.certPathLength = x509CertificateArray.length;
            PKIXCertPathValidatorResult pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)certPathValidator.validate(certPath, pKIXBuilderParameters);
            return PKIXValidator.toArray(certPath, pKIXCertPathValidatorResult.getTrustAnchor());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ValidatorException("PKIX path validation failed: " + generalSecurityException.toString(), generalSecurityException);
        }
    }

    private X509Certificate[] doBuild(X509Certificate[] x509CertificateArray, Collection collection) throws CertificateException {
        try {
            PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)this.parameterTemplate.clone();
            this.setDate(pKIXBuilderParameters);
            X509CertSelector x509CertSelector = new X509CertSelector();
            x509CertSelector.setCertificate(x509CertificateArray[0]);
            pKIXBuilderParameters.setTargetCertConstraints(x509CertSelector);
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            arrayList.addAll(Arrays.asList(x509CertificateArray));
            if (collection != null) {
                arrayList.addAll(collection);
            }
            CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(arrayList));
            pKIXBuilderParameters.addCertStore(certStore);
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX");
            PKIXCertPathBuilderResult pKIXCertPathBuilderResult = (PKIXCertPathBuilderResult)certPathBuilder.build(pKIXBuilderParameters);
            return PKIXValidator.toArray(pKIXCertPathBuilderResult.getCertPath(), pKIXCertPathBuilderResult.getTrustAnchor());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ValidatorException("PKIX path building failed: " + generalSecurityException.toString(), generalSecurityException);
        }
    }
}

