/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.resource;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.resource.AbstractResourceManager;
import org.eclipse.ui.forms.resource.DeviceResourceDescriptor;
import org.eclipse.ui.forms.resource.DeviceResourceException;
import org.eclipse.ui.forms.resource.ImageDescriptor;

public final class DeviceResourceManager
extends AbstractResourceManager {
    private Device device;
    private Image missingImage;

    public Device getDevice() {
        return this.device;
    }

    public DeviceResourceManager(Device device) {
        this.device = device;
    }

    protected Object allocate(DeviceResourceDescriptor descriptor) throws DeviceResourceException {
        return descriptor.createResource(this.device);
    }

    protected void deallocate(Object resource, DeviceResourceDescriptor descriptor) {
        descriptor.destroyResource(resource);
    }

    protected Image getDefaultImage() {
        if (this.missingImage == null) {
            this.missingImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return this.missingImage;
    }

    public void dispose() {
        super.dispose();
        if (this.missingImage != null) {
            this.missingImage.dispose();
            this.missingImage = null;
        }
    }
}

