-- V8.1 Wetness value is always displayed
-- V8.0 In game configuration (and all-in-one Bars versions). Shortcuts removed. Issues with custom characters should be resolved
-- V7.74 Bugfix for the status values disappearing when opening the craft tab while using a controller
-- V7.73 Minor cosmetic change on the health down arrow for the Bars version only.
-- V7.72 The naughtiness meter should no longer display 0/nil
-- V7.71 The temperature/naughtiness meters will now show in the caves
-- V7.7 Fix for the new moisture meter (WX78 only)
-- V7.62 Temperature, naughtiness and temperature unit are now saved in individual saves
-- V7.61 Shortcuts : 'U' switches between celcius and fahrenheit, 'P' turns temperature on/off and 'N' turns naughtiness on/off
-- V7.6 Fixed the disappearing crafting tab when using a pad.
-- V7.5 The mod is compatible with Backpack and/or Amulet Slot(s) again.
-- V7.4 The mod is compatible with RPG HUD again.
-- V7.3 The mod is compatible with Display Food Values again.
-- V7.2 Fixed the status display disappearing values bug.
-- V7.1 All's Well That Maxwell update
-- v7.0 Six Feet Under update
-- v6.1 Bugfix on the naughtiness meter
-- V6.0 A Moderately Friendly Update
-- V5.0 The Stuff of Nightmares update
-- V4.4 Bugfix - WX78 upgrades will show correctly
-- V4.3 Hungry for your hunger update
-- V4.2 No more incompatibilities with Display Food Values
-- V4.1 Bugfix for crashing when eating gears with WX78
-- V4.0 Strange new powers update
-- V3.1 Added temperature tab
-- V3.0 It's not a rock update - added naughtiness tab
-- V2.0 Underground update - downscaled the icons' size by 10% and rearranged their position
-- V1.1 Added custom background
-- V1.0 Release version

-- Created by Kiopho
--------------------------------------------------------------------------------------------

Assets = {
	Asset("ATLAS", "images/status_bg.xml"),
}

--------------------------------------------------------------------------------------------
local naughty_on = (GetModConfigData("Naughtiness_state")=="default")
local naughty_off = (GetModConfigData("Naughtiness_state")=="off")

local temp_on = (GetModConfigData("Temperature_state")=="default")
local temp_off = (GetModConfigData("Temperature_state")=="off")

local temp_c = (GetModConfigData("Temperature_Unit")=="default")
local temp_f = (GetModConfigData("Temperature_Unit")=="fahrenheit")

local T_onoff, N_onoff = 1,1

local Badge = GLOBAL.require "widgets/badge"
local kramped = GLOBAL.require "components/kramped"

local NaughtyBadge = Class(Badge, function(status, owner)
    Badge._ctor(status, "naughty", owner)
end)

local TemperatureBadge = Class(Badge, function(status, owner)
    Badge._ctor(status, "temperature", owner)
end)



local function StatusPost()

	local player = GLOBAL.GetPlayer()
	local controls = player.HUD.controls
	local status = controls.status
	
	controls.clock.text:SetPosition(5,0,0)
	controls.clock.text:SetScale(.9,.9,0)
	
	controls.sidepanel:SetPosition(-100,-70,0)

	status.brain:SetPosition(0,10,0)
	status.stomach:SetPosition(-62,35,0)
	status.heart:SetPosition(62,35,0)
	
	status.temperature = status:AddChild(TemperatureBadge(owner))
	status.temperature:SetTemperature(status.owner.components.temperature:GetCurrent())
	
	status.naughty = status:AddChild(NaughtyBadge(owner))
	status.naughty:SetNaughty(status.owner.components.kramped:GetNaughtyness(), status.owner.components.kramped:GetLimit())
	
	if temp_c then
		status.temperature.numtempf:Kill()
	elseif temp_f then
		status.temperature.num:Kill()
	end
	
	if temp_on then
		T_onoff = 1
	else
		T_onoff = 0
		status.temperature:Hide()
	end
	
	if naughty_on then
		N_onoff = 1
	else
		N_onoff = 0
		status.naughty:Hide()
	end

	status.temperature:SetPosition(57.5*T_onoff,5*(50-49*T_onoff),0)
	status.naughty:SetPosition(-57.5*(N_onoff + 2*(T_onoff-1)),5*(50-49*N_onoff),0)

	status.inst:ListenForEvent("temperaturedelta", function(inst) status.temperature:SetTemperature(status.owner.components.temperature:GetCurrent()) end, status.owner)
	status.inst:ListenForEvent("naughtydelta", function(inst) status.naughty:SetNaughty(player.components.kramped.GetNaughtyness(), player.components.kramped.GetLimit()) end, status.owner)
	
	if status.moisturemeter then
		status.moisturemeter:SetPosition(0,-80,0)
	end
end

AddSimPostInit(StatusPost)

-- WX78 Upgrade Animation Fix
local function applyupgrades(inst)

	local max_upgrades = 15
	local upgrades = math.min(inst.level, max_upgrades)

	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()

	inst.components.hunger.max = math.ceil(TUNING.WX78_MIN_HUNGER + upgrades* (TUNING.WX78_MAX_HUNGER - TUNING.WX78_MIN_HUNGER)/max_upgrades)
	inst.components.health.maxhealth = math.ceil(TUNING.WX78_MIN_HEALTH + upgrades* (TUNING.WX78_MAX_HEALTH - TUNING.WX78_MIN_HEALTH)/max_upgrades)
	inst.components.sanity.max = math.ceil(TUNING.WX78_MIN_SANITY + upgrades* (TUNING.WX78_MAX_SANITY - TUNING.WX78_MIN_SANITY)/max_upgrades)

	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)
	
end

local function newoneat(inst, food)
	
	if food and food.components.edible and food.components.edible.foodtype == "GEARS" then
		inst.level = inst.level + 1
		applyupgrades(inst)	
		inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
		inst.HUD.controls.status.heart:PulseGreen()
		inst.HUD.controls.status.stomach:PulseGreen()
		inst.HUD.controls.status.brain:PulseGreen()
		
		inst.HUD.controls.status.brain:ScaleTo(1.2,.9,.7)
		inst.HUD.controls.status.heart:ScaleTo(1.2,.9,.7)
		inst.HUD.controls.status.stomach:ScaleTo(1.2,.9,.7)
	end
end

local function wx78eat(inst)
	inst.components.eater:SetOnEatFn(newoneat)
end

AddPrefabPostInit("wx78", wx78eat)
--

-- Status Display Fix
local function StatusDisplayFix(self)
	function self:CloseControllerInventory()
		TheFrontEnd:GetSound():PlaySound("dontstarve/HUD/craft_close")
		self.controls:ShowStatusNumbers()
		self:ShowControllerCrafting()
		self.controls.inv:CloseControllerInventory()
	end
end

local RPGActive = 0
for _, moddir in ipairs(GLOBAL.KnownModIndex:GetModsToLoad()) do
    if GLOBAL.KnownModIndex:GetModInfo(moddir).name == "RPG HUD" then
		RPGActive = 1
    end
end

if RPGActive == 0 then
	AddClassPostConstruct("screens/playerhud", StatusDisplayFix)
end
--

-- Wetness Text
local function MoistureTextFix(self)

	self.OnLoseFocus = function(self)
		self._base:OnLoseFocus(self)
		self.num:Show()					--MOD
	end
	
	local oldActivate = self.Activate
	function self:Activate()
		oldActivate(self)
		self.num:Show()
	end
	
	local oldDeactivate = self.Deactivate
	function self:Deactivate()
		oldDeactivate(self)
		self.num:Hide()
	end
	
	self.num:SetScale(.85,.78,0)
	
	local oldUpdateArrowAnim = self.UpdateArrowAnim
	self.UpdateArrowAnim = function(self)
	
		oldUpdateArrowAnim(self)
	
		if self.owner.components.moisture:GetDelta() > 0 and self.owner.components.moisture:GetMoisture() < 100 then
			self.arrow:SetPosition(0,10,0)		
		elseif self.owner.components.moisture:GetDelta() < 0 and self.owner.components.moisture:GetMoisture() > 0 then
			self.arrow:SetPosition(0,-10,0)
		end
	end
	
end

if GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS) then
	AddClassPostConstruct("widgets/moisturemeter", MoistureTextFix)
end
--