local UIAnim = require "widgets/uianim"
local Text = require "widgets/text"
local easing = require "easing"
local Widget = require "widgets/widget"

local Badge = Class(Widget, function(self, anim, owner)
    
    Widget._ctor(self, "Badge")
	self.owner = owner
    
    self.percent = 1
    self:SetScale(.9,.9,.9)
    
    
    self.pulse = self:AddChild(UIAnim())
    self.pulse:GetAnimState():SetBank("pulse")
    self.pulse:GetAnimState():SetBuild("hunger_health_pulse")

    self.warning = self:AddChild(UIAnim())
    self.warning:GetAnimState():SetBank("pulse")
    self.warning:GetAnimState():SetBuild("hunger_health_pulse")
    self.warning:Hide()

    self.anim = self:AddChild(UIAnim())
    self.anim:GetAnimState():SetBank(anim)
    self.anim:GetAnimState():SetBuild(anim)
    self.anim:GetAnimState():PlayAnimation("anim")
    
    self.underNumber = self:AddChild(Widget("undernumber"))

	self.bg = self:AddChild(Image("images/status_bg.xml", "status_bg.tex"))
	self.bg:SetScale(.4,.43,0)
    self.bg:SetPosition(-.5,-25,0)
    
    self.num = self:AddChild(Text(NUMBERFONT, 28))
    self.num:SetHAlign(ANCHOR_MIDDLE)
    self.num:SetPosition(3.5, -40.5, 0)
	self.num:SetScale(1,.78,1)
	
	self.numtempf = self:AddChild(Text(NUMBERFONT, 28))
    self.numtempf:SetHAlign(ANCHOR_MIDDLE)
    self.numtempf:SetPosition(3.5, -40.5, 0)
	self.numtempf:SetScale(1,.78,1)
    
	self.maxnum = self:AddChild(Text(NUMBERFONT, 33))
    self.maxnum:SetPosition(6, 0, 0)
	self.num:SetScale(1,.78,1)
    self.maxnum:Hide()
    
end)

function Badge:SetPercent(val, max)
    val = val or self.percent
    max = max or 100
	
    self.anim:GetAnimState():SetPercent("anim", 1 - val)
    self.num:SetString(tostring(math.ceil(val*max)))
            
    self.percent = val
	
	self.maxnum:SetString(tostring(math.ceil(max)))
end

function Badge:OnGainFocus()
	Badge._base.OnGainFocus(self)
    self.maxnum:Show()
end

function Badge:OnLoseFocus()
    Badge._base.OnLoseFocus(self)
    self.maxnum:Hide()
end

function Badge:PulseGreen()
    self.pulse:GetAnimState():SetMultColour(0,1,0,1)
	self.pulse:GetAnimState():PlayAnimation("pulse")
end

function Badge:PulseRed()
    self.pulse:GetAnimState():SetMultColour(1,0,0,1)
	self.pulse:GetAnimState():PlayAnimation("pulse")
end

function Badge:StopWarning()
	if self.warning.shown then
		self.warning:Hide()
	end
end

function Badge:StartWarning()
	if not self.warning.shown then
		self.warning:Show()
		self.warning:GetAnimState():SetMultColour(1,0,0,1)
		self.warning:GetAnimState():PlayAnimation("pulse", true)
	end
end

-- Naughty
function Badge:SetNaughty(val, max)
	self.num:SetString(tostring(val).."/"..tostring(max))
	self.bg:SetScale(.5,.43,0)
end

--Temp
function Badge:SetTemperature(val)
	if not IsDLCEnabled(REIGN_OF_GIANTS) then
		self.num:SetString(tostring(math.ceil(val)).."\176C")
		self.numtempf:SetString(tostring(math.ceil(1.8*val + 32)).."\176F")
	else
		self.num:SetString(tostring(math.ceil(val/2)).."\176C")
		self.numtempf:SetString(tostring(math.ceil(1.8*(val/2) + 32)).."\176F")
	end
	
	self.bg:SetScale(.5,.43,0)
end

return Badge