/*
 * Decompiled with CFR 0.152.
 */
package com.msc.applet;

import com.msc.applet.AudioConverterUtil;
import com.msc.applet.RecognizeApplet;
import com.msc.applet.UploadRecordFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

class PcmRecord
implements Runnable {
    TargetDataLine mTargetDataLine;
    Thread mThread;
    String mErrStr;
    AudioInputStream mAudioInputStream;
    RecognizeApplet mRecognizeApplet;
    private String recordName;
    private String uploadUrl;

    PcmRecord() {
    }

    public void start(RecognizeApplet applet, String fileName, String uploadUrl) {
        this.recordName = fileName;
        this.uploadUrl = uploadUrl;
        this.mErrStr = null;
        this.mRecognizeApplet = applet;
        this.mThread = new Thread(this);
        this.mThread.setName("PcmRecord");
        this.mThread.start();
    }

    public void stop() {
        this.mThread = null;
    }

    public void uploadRecord() {
        this.mThread = null;
        UploadRecordFile upload = new UploadRecordFile("c:/record/" + this.recordName, this.recordName, this.uploadUrl);
        upload.send();
    }

    private void shutDown(String message) {
        this.mErrStr = message;
        if (this.mErrStr != null && this.mThread != null) {
            this.mThread = null;
            System.err.println(this.mErrStr);
        }
    }

    @Override
    public void run() {
        this.mAudioInputStream = null;
        AudioFormat format = this.getRecordFormat();
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
        if (!AudioSystem.isLineSupported(info)) {
            this.shutDown("Line matching " + info + " not supported.");
            return;
        }
        try {
            this.mTargetDataLine = (TargetDataLine)AudioSystem.getLine(info);
            this.mTargetDataLine.open(format, this.mTargetDataLine.getBufferSize());
        }
        catch (LineUnavailableException ex) {
            ex.printStackTrace();
            this.shutDown("Unable to open the line: " + ex);
            return;
        }
        catch (SecurityException ex) {
            this.shutDown(ex.toString());
            return;
        }
        catch (Exception ex) {
            this.shutDown(ex.toString());
            return;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int frameSizeInBytes = format.getFrameSize();
        int bufferLengthInFrames = this.mTargetDataLine.getBufferSize() / 8;
        int bufferLengthInBytes = bufferLengthInFrames * frameSizeInBytes;
        byte[] data = new byte[bufferLengthInBytes];
        this.mTargetDataLine.start();
        while (this.mThread != null) {
            int numBytesRead = this.mTargetDataLine.read(data, 0, bufferLengthInBytes);
            if (numBytesRead == -1) break;
            out.write(data, 0, numBytesRead);
        }
        this.mTargetDataLine.stop();
        this.mTargetDataLine.close();
        this.mTargetDataLine = null;
        try {
            out.flush();
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        byte[] audioBytes = out.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(audioBytes);
        this.mAudioInputStream = new AudioInputStream(bais, format, audioBytes.length / frameSizeInBytes);
        try {
            this.mAudioInputStream.reset();
            File file = new File("c:\\record");
            if (!file.isDirectory()) {
                file.mkdir();
            }
            this.save(this.mAudioInputStream, "c:\\record\\" + this.recordName);
            this.AudioConverter();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    public void AudioConverter() {
        String path = "c:\\record\\" + this.recordName;
        String filePathwma = String.valueOf(path.substring(0, path.lastIndexOf("."))) + ".wma";
        String src = path;
        String target = filePathwma;
        AudioConverterUtil audioConverter = new AudioConverterUtil();
        try {
            audioConverter.convertAudioFiles(src, target);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void save(InputStream is, String path) throws Exception {
        File file = new File(path);
        FileOutputStream os = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(os);
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] b = new byte[1000];
        int of = b.length;
        while ((of = bis.read(b, 0, of)) != -1) {
            bos.write(b, 0, of);
        }
        bos.flush();
        bis.close();
        bos.close();
        is.close();
        ((OutputStream)os).close();
    }

    public AudioFormat getRecordFormat() {
        float sampleRate = 16000.0f;
        int sampleSizeInBits = 16;
        int channels = 1;
        boolean signed = true;
        boolean bigEndian = false;
        return new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
    }

    public String getRecordName() {
        return this.recordName;
    }

    public void setRecordName(String recordName) {
        this.recordName = recordName;
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
    }
}

